/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzrl();

    protected abstract Object zzcN(String var1);

    protected boolean zza(Field field) {
        if (field.zzrk() == 11) {
            if (field.zzrq()) {
                return this.zzcQ(field.zzrr());
            }
            return this.zzcP(field.zzrr());
        }
        return this.zzcO(field.zzrr());
    }

    protected abstract boolean zzcO(String var1);

    protected boolean zzcP(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzcQ(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zzamU != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzrm() {
        return null;
    }

    public HashMap<String, Object> zzrn() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzrl();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzrk()) {
                case 8: {
                    stringBuilder.append("\"").append(zzmo.zzj((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzmo.zzk((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zznc.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzrp()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzrr();
        if (field.zzrt() != null) {
            HashMap<String, Object> hashMap;
            zzx.zza(this.zzcN(field.zzrr()) == null, "Concrete field shouldn't be value object: %s", field.zzrr());
            HashMap<String, Object> hashMap2 = hashMap = field.zzrq() ? this.zzrn() : this.zzrm();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                String string3 = "get" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
                return this.getClass().getMethod(string3, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzcN(field.zzrr());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzrj() == 11) {
            Class<FastJsonResponse> clazz = field.zzrt();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzrj() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zznb.zzcU((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzrj();

        public int zzrk();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    implements SafeParcelable {
        private final int mVersionCode;
        protected final int zzamL;
        protected final boolean zzamM;
        protected final int zzamN;
        protected final boolean zzamO;
        protected final String zzamP;
        protected final int zzamQ;
        protected final Class<? extends FastJsonResponse> zzamR;
        protected final String zzamS;
        private FieldMappingDictionary zzamT;
        private zza<I, O> zzamU;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int versionCode, int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, String concreteTypeName, ConverterWrapper wrappedConverter) {
            this.mVersionCode = versionCode;
            this.zzamL = typeIn;
            this.zzamM = typeInArray;
            this.zzamN = typeOut;
            this.zzamO = typeOutArray;
            this.zzamP = outputFieldName;
            this.zzamQ = safeParcelableFieldId;
            if (concreteTypeName == null) {
                this.zzamR = null;
                this.zzamS = null;
            } else {
                this.zzamR = SafeParcelResponse.class;
                this.zzamS = concreteTypeName;
            }
            this.zzamU = wrappedConverter == null ? null : wrappedConverter.zzrh();
        }

        protected Field(int typeIn, boolean typeInArray, int typeOut, boolean typeOutArray, String outputFieldName, int safeParcelableFieldId, Class<? extends FastJsonResponse> concreteType, zza<I, O> converter) {
            this.mVersionCode = 1;
            this.zzamL = typeIn;
            this.zzamM = typeInArray;
            this.zzamN = typeOut;
            this.zzamO = typeOutArray;
            this.zzamP = outputFieldName;
            this.zzamQ = safeParcelableFieldId;
            this.zzamR = concreteType;
            this.zzamS = concreteType == null ? null : concreteType.getCanonicalName();
            this.zzamU = converter;
        }

        public Field<I, O> zzro() {
            return new Field<I, O>(this.mVersionCode, this.zzamL, this.zzamM, this.zzamN, this.zzamO, this.zzamP, this.zzamQ, this.zzamS, this.zzrw());
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzrj() {
            return this.zzamL;
        }

        public boolean zzrp() {
            return this.zzamM;
        }

        public int zzrk() {
            return this.zzamN;
        }

        public boolean zzrq() {
            return this.zzamO;
        }

        public String zzrr() {
            return this.zzamP;
        }

        public int zzrs() {
            return this.zzamQ;
        }

        public Class<? extends FastJsonResponse> zzrt() {
            return this.zzamR;
        }

        String zzru() {
            if (this.zzamS == null) {
                return null;
            }
            return this.zzamS;
        }

        public boolean zzrv() {
            return this.zzamU != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zzamT = fieldMappingDictionary;
        }

        ConverterWrapper zzrw() {
            if (this.zzamU == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zzamU);
        }

        public Map<String, Field<?, ?>> zzrx() {
            zzx.zzz(this.zzamS);
            zzx.zzz(this.zzamT);
            return this.zzamT.zzcR(this.zzamS);
        }

        public I convertBack(O output) {
            return this.zzamU.convertBack(output);
        }

        public static Field<Integer, Integer> zzi(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Double, Double> zzj(String string2, int n) {
            return new Field<Double, Double>(4, false, 4, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzk(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzl(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static Field<ArrayList<String>, ArrayList<String>> zzm(String string2, int n) {
            return new Field<ArrayList<String>, ArrayList<String>>(7, true, 7, true, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzrj(), bl, zza2.zzrk(), false, string2, n, null, zza2);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            com.google.android.gms.common.server.response.zza.zza(this, out, flags);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zzamL).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zzamM).append('\n');
            stringBuilder.append("                typeOut=").append(this.zzamN).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zzamO).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zzamP).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zzamQ).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzru()).append('\n');
            if (this.zzrt() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzrt().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zzamU == null ? "null" : this.zzamU.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

