/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzz;

public final class Status
extends AbstractSafeParcelable
implements Result {
    public static final Status zzalw = new Status(0);
    public static final Status zzalx = new Status(14);
    public static final Status zzaly = new Status(8);
    public static final Status zzalz = new Status(15);
    public static final Status zzalA = new Status(16);
    public static final Status zzalB = new Status(17);
    public static final Parcelable.Creator<Status> CREATOR = new zzf();
    private final int mVersionCode;
    private final int zzahG;
    private final String zzakk;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.zzahG = n2;
        this.zzakk = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzrx() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zzakk;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzahG <= 0;
    }

    public boolean isCanceled() {
        return this.zzahG == 16;
    }

    public boolean isInterrupted() {
        return this.zzahG == 14;
    }

    public int getStatusCode() {
        return this.zzahG;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzz.hashCode(this.mVersionCode, this.zzahG, this.zzakk, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.zzahG == status.zzahG && zzz.equal(this.zzakk, status.zzakk) && zzz.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzry() {
        if (this.zzakk != null) {
            return this.zzakk;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzahG);
    }

    public String toString() {
        return zzz.zzy(this).zzg("statusCode", this.zzry()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

