/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzapv;
import com.google.android.gms.internal.zzapy;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzapo {
    private final ByteBuffer bjw;

    private zzapo(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzapo(ByteBuffer byteBuffer) {
        this.bjw = byteBuffer;
        this.bjw.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzapo zzbe(byte[] byArray) {
        return zzapo.zzc(byArray, 0, byArray.length);
    }

    public static zzapo zzc(byte[] byArray, int n, int n2) {
        return new zzapo(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzai(n, 1);
        this.zzo(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzai(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzct(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzcu(l);
    }

    public void zzae(int n, int n2) throws IOException {
        this.zzai(n, 0);
        this.zzafv(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzai(n, 1);
        this.zzcv(l);
    }

    public void zzj(int n, boolean bl) throws IOException {
        this.zzai(n, 0);
        this.zzdf(bl);
    }

    public void zzr(int n, String string2) throws IOException {
        this.zzai(n, 2);
        this.zztw(string2);
    }

    public void zza(int n, zzapv zzapv2) throws IOException {
        this.zzai(n, 2);
        this.zzc(zzapv2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzai(n, 2);
        this.zzbf(byArray);
    }

    public void zzaf(int n, int n2) throws IOException {
        this.zzai(n, 0);
        this.zzafw(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzai(n, 0);
        this.zzcw(l);
    }

    public void zzo(double d) throws IOException {
        this.zzdd(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzagd(Float.floatToIntBits(f));
    }

    public void zzct(long l) throws IOException {
        this.zzdb(l);
    }

    public void zzcu(long l) throws IOException {
        this.zzdb(l);
    }

    public void zzafv(int n) throws IOException {
        if (n >= 0) {
            this.zzagb(n);
        } else {
            this.zzdb(n);
        }
    }

    public void zzcv(long l) throws IOException {
        this.zzdd(l);
    }

    public void zzdf(boolean bl) throws IOException {
        this.zzafz(bl ? 1 : 0);
    }

    public void zztw(String string2) throws IOException {
        try {
            int n = zzapo.zzagc(string2.length());
            int n2 = zzapo.zzagc(string2.length() * 3);
            if (n == n2) {
                int n3 = this.bjw.position();
                if (this.bjw.remaining() < n) {
                    throw new zza(n3 + n, this.bjw.limit());
                }
                this.bjw.position(n3 + n);
                zzapo.zza((CharSequence)string2, this.bjw);
                int n4 = this.bjw.position();
                this.bjw.position(n3);
                this.zzagb(n4 - n3 - n);
                this.bjw.position(n4);
            } else {
                this.zzagb(zzapo.zzd(string2));
                zzapo.zza((CharSequence)string2, this.bjw);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.bjw.position(), this.bjw.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzd(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzapo.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzapo.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzapo.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        n5 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzapv zzapv2) throws IOException {
        zzapv2.zza(this);
    }

    public void zzc(zzapv zzapv2) throws IOException {
        this.zzagb(zzapv2.aL());
        zzapv2.zza(this);
    }

    public void zzbf(byte[] byArray) throws IOException {
        this.zzagb(byArray.length);
        this.zzbh(byArray);
    }

    public void zzafw(int n) throws IOException {
        this.zzagb(zzapo.zzage(n));
    }

    public void zzcw(long l) throws IOException {
        this.zzdb(zzapo.zzde(l));
    }

    public static int zzb(int n, double d) {
        return zzapo.zzaga(n) + zzapo.zzp(d);
    }

    public static int zzd(int n, float f) {
        return zzapo.zzaga(n) + zzapo.zzl(f);
    }

    public static int zze(int n, long l) {
        return zzapo.zzaga(n) + zzapo.zzcy(l);
    }

    public static int zzag(int n, int n2) {
        return zzapo.zzaga(n) + zzapo.zzafx(n2);
    }

    public static int zzf(int n, long l) {
        return zzapo.zzaga(n) + zzapo.zzcz(l);
    }

    public static int zzk(int n, boolean bl) {
        return zzapo.zzaga(n) + zzapo.zzdg(bl);
    }

    public static int zzs(int n, String string2) {
        return zzapo.zzaga(n) + zzapo.zztx(string2);
    }

    public static int zzb(int n, zzapv zzapv2) {
        return zzapo.zzaga(n) * 2 + zzapo.zzd(zzapv2);
    }

    public static int zzc(int n, zzapv zzapv2) {
        return zzapo.zzaga(n) + zzapo.zze(zzapv2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zzapo.zzaga(n) + zzapo.zzbg(byArray);
    }

    public static int zzah(int n, int n2) {
        return zzapo.zzaga(n) + zzapo.zzafy(n2);
    }

    public static int zzg(int n, long l) {
        return zzapo.zzaga(n) + zzapo.zzda(l);
    }

    public static int zzp(double d) {
        return 8;
    }

    public static int zzl(float f) {
        return 4;
    }

    public static int zzcx(long l) {
        return zzapo.zzdc(l);
    }

    public static int zzcy(long l) {
        return zzapo.zzdc(l);
    }

    public static int zzafx(int n) {
        if (n >= 0) {
            return zzapo.zzagc(n);
        }
        return 10;
    }

    public static int zzcz(long l) {
        return 8;
    }

    public static int zzdg(boolean bl) {
        return 1;
    }

    public static int zztx(String string2) {
        int n = zzapo.zzd(string2);
        return zzapo.zzagc(n) + n;
    }

    public static int zzd(zzapv zzapv2) {
        return zzapv2.aM();
    }

    public static int zze(zzapv zzapv2) {
        int n = zzapv2.aM();
        return zzapo.zzagc(n) + n;
    }

    public static int zzbg(byte[] byArray) {
        return zzapo.zzagc(byArray.length) + byArray.length;
    }

    public static int zzafy(int n) {
        return zzapo.zzagc(zzapo.zzage(n));
    }

    public static int zzda(long l) {
        return zzapo.zzdc(zzapo.zzde(l));
    }

    public int ay() {
        return this.bjw.remaining();
    }

    public void az() {
        if (this.ay() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.bjw.hasRemaining()) {
            throw new zza(this.bjw.position(), this.bjw.limit());
        }
        this.bjw.put(by);
    }

    public void zzafz(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzbh(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.bjw.remaining() < n2) {
            throw new zza(this.bjw.position(), this.bjw.limit());
        }
        this.bjw.put(byArray, n, n2);
    }

    public void zzai(int n, int n2) throws IOException {
        this.zzagb(zzapy.zzaj(n, n2));
    }

    public static int zzaga(int n) {
        return zzapo.zzagc(zzapy.zzaj(n, 0));
    }

    public void zzagb(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzafz(n);
                return;
            }
            this.zzafz(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzagc(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzdb(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzafz((int)l);
                return;
            }
            this.zzafz((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzdc(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzagd(int n) throws IOException {
        if (this.bjw.remaining() < 4) {
            throw new zza(this.bjw.position(), this.bjw.limit());
        }
        this.bjw.putInt(n);
    }

    public void zzdd(long l) throws IOException {
        if (this.bjw.remaining() < 8) {
            throw new zza(this.bjw.position(), this.bjw.limit());
        }
        this.bjw.putLong(l);
    }

    public static int zzage(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzde(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

