/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaof;
import com.google.android.gms.internal.zzaog;
import com.google.android.gms.internal.zzaoh;
import com.google.android.gms.internal.zzaol;
import com.google.android.gms.internal.zzaon;
import com.google.android.gms.internal.zzaoo;
import com.google.android.gms.internal.zzaop;
import com.google.android.gms.internal.zzaoq;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzanw
implements zzaog<Date>,
zzaop<Date> {
    private final DateFormat bkz;
    private final DateFormat bkA;
    private final DateFormat bkB;

    zzanw() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzanw(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    public zzanw(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzanw(DateFormat dateFormat, DateFormat dateFormat2) {
        this.bkz = dateFormat;
        this.bkA = dateFormat2;
        this.bkB = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.bkB.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzaoh zza(Date date, Type type, zzaoo zzaoo2) {
        DateFormat dateFormat = this.bkA;
        synchronized (dateFormat) {
            String string2 = this.bkz.format(date);
            return new zzaon(string2);
        }
    }

    public Date zza(zzaoh zzaoh2, Type type, zzaof zzaof2) throws zzaol {
        if (!(zzaoh2 instanceof zzaon)) {
            throw new zzaol("The date should be a string value");
        }
        Date date = this.zza(zzaoh2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string2 = String.valueOf(this.getClass());
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" cannot deserialize to ").append(string3).toString());
    }

    private Date zza(zzaoh zzaoh2) {
        DateFormat dateFormat = this.bkA;
        synchronized (dateFormat) {
            try {
                return this.bkA.parse(zzaoh2.aR());
            }
            catch (ParseException parseException) {
                try {
                    return this.bkz.parse(zzaoh2.aR());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.bkB.parse(zzaoh2.aR());
                    }
                    catch (ParseException parseException3) {
                        throw new zzaoq(zzaoh2.aR(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzanw.class.getSimpleName());
        stringBuilder.append('(').append(this.bkA.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzaoh zzaoh2, Type type, zzaof zzaof2) throws zzaol {
        return this.zza(zzaoh2, type, zzaof2);
    }
}

