/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcl;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzalf;
    zzcl zzalg;
    boolean zzalh;
    Object zzali = new Object();
    zza zzalj;
    private final Context mContext;
    final long zzalk;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzaa.zzy(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzalh = false;
        this.zzalk = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zze(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zze(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzaa.zzht("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzalh) {
                this.finish();
            }
            this.zzalf = AdvertisingIdClient.zzf(this.mContext);
            this.zzalg = AdvertisingIdClient.zza(this.mContext, this.zzalf);
            this.zzalh = true;
            if (bl) {
                this.zzea();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzea() {
        Object object = this.zzali;
        synchronized (object) {
            if (this.zzalj != null) {
                this.zzalj.cancel();
                try {
                    this.zzalj.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.zzalk > 0L) {
                this.zzalj = new zza(this, this.zzalk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        zzaa.zzht("Calling this from your main thread can lead to deadlock");
        Info info = null;
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzalh) {
                Object object = this.zzali;
                synchronized (object) {
                    if (this.zzalj == null || !this.zzalj.zzeb()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zze(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzalh) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzaa.zzy(this.zzalf);
            zzaa.zzy(this.zzalg);
            try {
                info = new Info(this.zzalg.getId(), this.zzalg.zzf(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzea();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzaa.zzht("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzalf == null) {
                return;
            }
            try {
                if (this.zzalh) {
                    com.google.android.gms.common.stats.zza.zzaxr().zza(this.mContext, this.zzalf);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzalh = false;
            this.zzalg = null;
            this.zzalf = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzf(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        int n = zzc.zzaql().isGooglePlayServicesAvailable(context);
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzaxr().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        SharedPreferences sharedPreferences = null;
        boolean bl = false;
        float f = 0.0f;
        try {
            object = zze.getRemoteContext(context);
            if (object != null) {
                sharedPreferences = object.getSharedPreferences("google_ads_flags", 1);
                bl = sharedPreferences.getBoolean("gads:ad_id_app_context:enabled", false);
                f = sharedPreferences.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
            }
        }
        catch (Exception exception) {
            Log.w((String)"AdvertisingIdClient", (String)"Error while reading from SharedPreferences ", (Throwable)exception);
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            ((AdvertisingIdClient)object).zze(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            Object var6_9 = null;
            return null;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private void zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return;
        }
        Uri uri = this.zza(info, bl, throwable);
        final String string2 = uri.toString();
        new Thread(){

            @Override
            public void run() {
                new com.google.android.gms.ads.identifier.zza().zzv(string2);
            }
        }.start();
    }

    Uri zza(Info info, boolean bl, Throwable throwable) {
        Bundle bundle = new Bundle();
        bundle.putString("app_context", bl ? "1" : "0");
        if (info != null) {
            bundle.putString("limit_ad_tracking", info.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info != null && info.getId() != null) {
            bundle.putString("ad_id_size", Integer.toString(info.getId().length()));
        }
        if (throwable != null) {
            bundle.putString("error", throwable.getClass().getName());
        }
        Uri.Builder builder = Uri.parse((String)"https://pagead2.googlesyndication.com/pagead/gen_204?id=gmob-apps").buildUpon();
        for (String string2 : bundle.keySet()) {
            builder.appendQueryParameter(string2, bundle.getString(string2));
        }
        return builder.build();
    }

    static zzcl zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzcl.zza.zzf(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzalr;
        private final boolean zzals;

        public Info(String string2, boolean bl) {
            this.zzalr = string2;
            this.zzals = bl;
        }

        public String getId() {
            return this.zzalr;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzals;
        }

        public String toString() {
            String string2 = this.zzalr;
            boolean bl = this.zzals;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzaln;
        private long zzalo;
        CountDownLatch zzalp;
        boolean zzalq;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzaln = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzalo = l;
            this.zzalp = new CountDownLatch(1);
            this.zzalq = false;
            this.start();
        }

        public void cancel() {
            this.zzalp.countDown();
        }

        public boolean zzeb() {
            return this.zzalq;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzaln.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzalq = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzalp.await(this.zzalo, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

