/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zze<T extends IInterface> {
    private int Dj;
    private long Dk;
    private long Dl;
    private int Dm;
    private long Dn;
    private final Context mContext;
    private final Looper zzajy;
    private final zzl Do;
    private final com.google.android.gms.common.zzc zm;
    final Handler mHandler;
    private final Object zzako = new Object();
    private final Object Dp = new Object();
    private zzt Dq;
    protected zzf Dr;
    private T Ds;
    private final ArrayList<zze<?>> Dt = new ArrayList();
    private zzh Du;
    private int Dv = 1;
    private final zzb Dw;
    private final zzc Dx;
    private final int Dy;
    private final String Dz;
    protected AtomicInteger DA = new AtomicInteger(0);
    public static final String[] DB = new String[]{"service_esmobile", "service_googleme"};

    protected zze(Context context, Looper looper, int n, zzb zzb2, zzc zzc2, String string2) {
        this(context, looper, zzl.zzcc(context), com.google.android.gms.common.zzc.zzaql(), n, zzaa.zzy(zzb2), zzaa.zzy(zzc2), string2);
    }

    protected zze(Context context, Looper looper, zzl zzl2, com.google.android.gms.common.zzc zzc2, int n, zzb zzb2, zzc zzc3, String string2) {
        this.mContext = zzaa.zzb(context, (Object)"Context must not be null");
        this.zzajy = zzaa.zzb(looper, (Object)"Looper must not be null");
        this.Do = zzaa.zzb(zzl2, (Object)"Supervisor must not be null");
        this.zm = zzaa.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzd(looper);
        this.Dy = n;
        this.Dw = zzb2;
        this.Dx = zzc3;
        this.Dz = string2;
    }

    @NonNull
    protected abstract String zzjx();

    protected String zzauz() {
        return "com.google.android.gms";
    }

    @NonNull
    protected abstract String zzjy();

    @Nullable
    protected final String zzava() {
        return this.Dz == null ? this.mContext.getClass().getName() : this.Dz;
    }

    @Nullable
    protected abstract T zzh(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.Dl = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int n) {
        this.Dj = n;
        this.Dk = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.Dm = connectionResult.getErrorCode();
        this.Dn = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzaa.zzbt(n == 3 == (t != null));
        Object object = this.zzako;
        synchronized (object) {
            this.Dv = n;
            this.Ds = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzavb();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzavc();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzavb() {
        String string2;
        if (this.Du != null) {
            String string3 = String.valueOf(this.zzjx());
            string2 = String.valueOf(this.zzauz());
            Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
            this.Do.zzb(this.zzjx(), this.zzauz(), this.Du, this.zzava());
            this.DA.incrementAndGet();
        }
        this.Du = new zzh(this.DA.get());
        boolean bl = this.Do.zza(this.zzjx(), this.zzauz(), this.Du, this.zzava());
        if (!bl) {
            string2 = String.valueOf(this.zzjx());
            String string4 = String.valueOf(this.zzauz());
            Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string4).toString());
            this.zza(16, null, this.DA.get());
        }
    }

    private void zzavc() {
        if (this.Du != null) {
            this.Do.zzb(this.zzjx(), this.zzauz(), this.Du, this.zzava());
            this.Du = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzako;
        synchronized (object) {
            if (this.Dv != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzavd() {
        int n = this.zm.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.Dr = new zzi();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.DA.get(), n));
            return;
        }
        this.zza(new zzi());
    }

    public void zza(@NonNull zzf zzf2) {
        this.Dr = zzaa.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.zzako;
        synchronized (object) {
            return this.Dv == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzako;
        synchronized (object) {
            return this.Dv == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.DA.incrementAndGet();
        Object object = this.Dt;
        synchronized (object) {
            int n = this.Dt.size();
            for (int i = 0; i < n; ++i) {
                this.Dt.get(i).zzavm();
            }
            this.Dt.clear();
        }
        object = this.Dp;
        synchronized (object) {
            this.Dq = null;
        }
        this.zzb(1, null);
    }

    public void zzgk(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.DA.get(), n));
    }

    public void zza(zzf zzf2, ConnectionResult connectionResult) {
        this.Dr = zzaa.zzb(zzf2, (Object)"Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.DA.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    private void zzl(ConnectionResult connectionResult) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.DA.get(), connectionResult.getErrorCode(), (Object)connectionResult.getResolution()));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzajy;
    }

    public Account getAccount() {
        return null;
    }

    public final Account zzave() {
        return this.getAccount() != null ? this.getAccount() : new Account("<<default account>>", "com.google");
    }

    protected Bundle zzahv() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzj(n, iBinder, bundle)));
    }

    protected void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzk(n, bundle)));
    }

    protected final void zzavf() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public Bundle zzapn() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzavg() throws DeadObjectException {
        Object object = this.zzako;
        synchronized (object) {
            if (this.Dv == 4) {
                throw new DeadObjectException();
            }
            this.zzavf();
            zzaa.zza(this.Ds != null, (Object)"Client is connected but service is null");
            return this.Ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void zza(zzp zzp2, Set<Scope> set) {
        Bundle bundle = this.zzahv();
        GetServiceRequest getServiceRequest = new GetServiceRequest(this.Dy).zzhv(this.mContext.getPackageName()).zzo(bundle);
        if (set != null) {
            getServiceRequest.zzf(set);
        }
        if (this.zzain()) {
            getServiceRequest.zze(this.zzave()).zzb(zzp2);
        } else if (this.zzavh()) {
            getServiceRequest.zze(this.getAccount());
        }
        try {
            Object object = this.Dp;
            synchronized (object) {
                if (this.Dq != null) {
                    this.Dq.zza((zzs)new zzg(this, this.DA.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzgk(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)runtimeException);
            this.zzl(new ConnectionResult(8, null, "IGmsServiceBroker.getService failed."));
        }
    }

    public boolean zzain() {
        return false;
    }

    public boolean zzavh() {
        return false;
    }

    public boolean zzaqx() {
        return true;
    }

    public boolean zzajc() {
        return false;
    }

    public Intent zzajd() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    protected Set<Scope> zzavi() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        T t;
        int n;
        Object object = this.zzako;
        synchronized (object) {
            n = this.Dv;
            t = this.Ds;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("CONNECTED");
                break;
            }
            case 4: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.println("null");
        } else {
            printWriter.append(this.zzjy()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.Dl > 0L) {
            l = this.Dl;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Dl)));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.Dk > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.Dj) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.Dj));
                }
            }
            l = this.Dk;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Dk)));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.Dn > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.Dm));
            l = this.Dn;
            string3 = String.valueOf(((DateFormat)object).format(new Date(this.Dn)));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IBinder zzaqy() {
        Object object = this.Dp;
        synchronized (object) {
            if (this.Dq == null) {
                return null;
            }
            return this.Dq.asBinder();
        }
    }

    public static final class zzg
    extends zzs.zza {
        private zze DF;
        private final int DG;

        public zzg(@NonNull zze zze2, int n) {
            this.DF = zze2;
            this.DG = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzaa.zzb(this.DF, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.DF.zza(n, iBinder, bundle, this.DG);
            this.zzavn();
        }

        private void zzavn() {
            this.DF = null;
        }
    }

    private abstract class zza
    extends zze<Boolean> {
        public final int statusCode;
        public final Bundle DC;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.DC = bundle;
        }

        protected abstract boolean zzavj();

        protected abstract void zzm(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zze.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzavj()) break;
                    zze.this.zzb(1, null);
                    this.zzm(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zze.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zze.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.DC != null) {
                        pendingIntent = (PendingIntent)this.DC.getParcelable("pendingIntent");
                    }
                    this.zzm(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzavk() {
        }

        @Override
        protected /* synthetic */ void zzv(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzj
    extends zza {
        public final IBinder DH;

        @BinderThread
        public zzj(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.DH = iBinder;
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            if (zze.this.Dx != null) {
                zze.this.Dx.onConnectionFailed(connectionResult);
            }
            zze.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzavj() {
            String string2;
            try {
                string2 = this.DH.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zze.this.zzjy().equals(string2)) {
                String string3 = String.valueOf(zze.this.zzjy());
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = zze.this.zzh(this.DH);
            if (t != null && zze.this.zza(2, 3, t)) {
                Bundle bundle = zze.this.zzapn();
                if (zze.this.Dw != null) {
                    zze.this.Dw.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzk
    extends zza {
        @BinderThread
        public zzk(int n, @Nullable Bundle bundle) {
            super(n, bundle);
        }

        @Override
        protected void zzm(ConnectionResult connectionResult) {
            zze.this.Dr.zzg(connectionResult);
            zze.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzavj() {
            zze.this.Dr.zzg(ConnectionResult.wO);
            return true;
        }
    }

    protected class zzi
    implements zzf {
        @Override
        public void zzg(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zze.this.zza(null, zze.this.zzavi());
            } else if (zze.this.Dx != null) {
                zze.this.Dx.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zze<TListener> {
        private TListener mListener;
        private boolean DE;

        public zze(TListener TListener) {
            this.mListener = TListener;
            this.DE = false;
        }

        protected abstract void zzv(TListener var1);

        protected abstract void zzavk();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzavl() {
            TListener TListener;
            zze zze2 = this;
            synchronized (zze2) {
                TListener = this.mListener;
                if (this.DE) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zzv(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzavk();
                    throw runtimeException;
                }
            } else {
                this.zzavk();
            }
            zze2 = this;
            synchronized (zze2) {
                this.DE = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzavm();
            ArrayList arrayList = zze.this.Dt;
            synchronized (arrayList) {
                zze.this.Dt.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzavm() {
            zze zze2 = this;
            synchronized (zze2) {
                this.mListener = null;
            }
        }
    }

    final class zzd
    extends Handler {
        public zzd(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            if (zze.this.DA.get() != message.arg1) {
                if (this.zzb(message)) {
                    this.zza(message);
                }
                return;
            }
            if (!(message.what != 1 && message.what != 5 || zze.this.isConnecting())) {
                this.zza(message);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                zze.this.Dr.zzg(connectionResult);
                zze.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 4) {
                zze.this.zzb(4, null);
                if (zze.this.Dw != null) {
                    zze.this.Dw.onConnectionSuspended(message.arg2);
                }
                zze.this.onConnectionSuspended(message.arg2);
                zze.this.zza(4, 1, null);
                return;
            }
            if (message.what == 2 && !zze.this.isConnected()) {
                this.zza(message);
                return;
            }
            if (this.zzb(message)) {
                zze zze2 = (zze)message.obj;
                zze2.zzavl();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zze zze2 = (zze)message.obj;
            zze2.zzavk();
            zze2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public static interface zzf {
        public void zzg(@NonNull ConnectionResult var1);
    }

    public static interface zzc {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface zzb {
        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }

    public final class zzh
    implements ServiceConnection {
        private final int DG;

        public zzh(int n) {
            this.DG = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                zze.this.zzl(new ConnectionResult(8, null, "ServiceBroker IBinder is null"));
                return;
            }
            Object object = zze.this.Dp;
            synchronized (object) {
                zze.this.Dq = zzt.zza.zzdu(iBinder);
            }
            zze.this.zza(0, null, this.DG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = zze.this.Dp;
            synchronized (object) {
                zze.this.Dq = null;
            }
            zze.this.mHandler.sendMessage(zze.this.mHandler.obtainMessage(4, this.DG, 1));
        }
    }
}

