/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzasa;
import com.google.android.gms.internal.zzasd;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzart {
    private final ByteBuffer btF;

    private zzart(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzart(ByteBuffer byteBuffer) {
        this.btF = byteBuffer;
        this.btF.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzart zzbe(byte[] byArray) {
        return zzart.zzc(byArray, 0, byArray.length);
    }

    public static zzart zzc(byte[] byArray, int n, int n2) {
        return new zzart(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzaj(n, 1);
        this.zzn(d);
    }

    public void zzc(int n, float f) throws IOException {
        this.zzaj(n, 5);
        this.zzk(f);
    }

    public void zza(int n, long l) throws IOException {
        this.zzaj(n, 0);
        this.zzcu(l);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzaj(n, 0);
        this.zzcv(l);
    }

    public void zzaf(int n, int n2) throws IOException {
        this.zzaj(n, 0);
        this.zzagx(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzaj(n, 1);
        this.zzcw(l);
    }

    public void zzg(int n, boolean bl) throws IOException {
        this.zzaj(n, 0);
        this.zzdm(bl);
    }

    public void zzq(int n, String string2) throws IOException {
        this.zzaj(n, 2);
        this.zzux(string2);
    }

    public void zza(int n, zzasa zzasa2) throws IOException {
        this.zzaj(n, 2);
        this.zzc(zzasa2);
    }

    public void zzb(int n, byte[] byArray) throws IOException {
        this.zzaj(n, 2);
        this.zzbf(byArray);
    }

    public void zzag(int n, int n2) throws IOException {
        this.zzaj(n, 0);
        this.zzagy(n2);
    }

    public void zzd(int n, long l) throws IOException {
        this.zzaj(n, 0);
        this.zzcx(l);
    }

    public void zzn(double d) throws IOException {
        this.zzdd(Double.doubleToLongBits(d));
    }

    public void zzk(float f) throws IOException {
        this.zzahf(Float.floatToIntBits(f));
    }

    public void zzcu(long l) throws IOException {
        this.zzdb(l);
    }

    public void zzcv(long l) throws IOException {
        this.zzdb(l);
    }

    public void zzagx(int n) throws IOException {
        if (n >= 0) {
            this.zzahd(n);
        } else {
            this.zzdb(n);
        }
    }

    public void zzcw(long l) throws IOException {
        this.zzdd(l);
    }

    public void zzdm(boolean bl) throws IOException {
        this.zzahb(bl ? 1 : 0);
    }

    public void zzux(String string2) throws IOException {
        try {
            int n = zzart.zzahe(string2.length());
            int n2 = zzart.zzahe(string2.length() * 3);
            if (n == n2) {
                int n3 = this.btF.position();
                if (this.btF.remaining() < n) {
                    throw new zza(n3 + n, this.btF.limit());
                }
                this.btF.position(n3 + n);
                zzart.zza((CharSequence)string2, this.btF);
                int n4 = this.btF.position();
                this.btF.position(n3);
                this.zzahd(n4 - n3 - n);
                this.btF.position(n4);
            } else {
                this.zzahd(zzart.zzb(string2));
                zzart.zza((CharSequence)string2, this.btF);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.btF.position(), this.btF.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zzart.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                int n5 = i;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n5).toString());
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zzart.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zzart.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                n2 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n2).toString());
            }
            n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n + n4;
        }
        n5 = n + n3;
        while (n3 < n4) {
            int n7;
            char c2;
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    n7 = n3 - 1;
                    throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                }
                n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                c2 = c;
                n7 = n5;
                throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n7).toString());
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zzasa zzasa2) throws IOException {
        zzasa2.zza(this);
    }

    public void zzc(zzasa zzasa2) throws IOException {
        this.zzahd(zzasa2.cy());
        zzasa2.zza(this);
    }

    public void zzbf(byte[] byArray) throws IOException {
        this.zzahd(byArray.length);
        this.zzbh(byArray);
    }

    public void zzagy(int n) throws IOException {
        this.zzahd(zzart.zzahg(n));
    }

    public void zzcx(long l) throws IOException {
        this.zzdb(zzart.zzde(l));
    }

    public static int zzb(int n, double d) {
        return zzart.zzahc(n) + 8;
    }

    public static int zzd(int n, float f) {
        return zzart.zzahc(n) + 4;
    }

    public static int zze(int n, long l) {
        return zzart.zzahc(n) + zzart.zzcy(l);
    }

    public static int zzf(int n, long l) {
        return zzart.zzahc(n) + zzart.zzcz(l);
    }

    public static int zzah(int n, int n2) {
        return zzart.zzahc(n) + zzart.zzagz(n2);
    }

    public static int zzg(int n, long l) {
        return zzart.zzahc(n) + 8;
    }

    public static int zzh(int n, boolean bl) {
        return zzart.zzahc(n) + 1;
    }

    public static int zzr(int n, String string2) {
        return zzart.zzahc(n) + zzart.zzuy(string2);
    }

    public static int zzb(int n, zzasa zzasa2) {
        return zzart.zzahc(n) * 2 + zzart.zzd(zzasa2);
    }

    public static int zzc(int n, zzasa zzasa2) {
        return zzart.zzahc(n) + zzart.zze(zzasa2);
    }

    public static int zzc(int n, byte[] byArray) {
        return zzart.zzahc(n) + zzart.zzbg(byArray);
    }

    public static int zzai(int n, int n2) {
        return zzart.zzahc(n) + zzart.zzaha(n2);
    }

    public static int zzh(int n, long l) {
        return zzart.zzahc(n) + zzart.zzda(l);
    }

    public static int zzcy(long l) {
        return zzart.zzdc(l);
    }

    public static int zzcz(long l) {
        return zzart.zzdc(l);
    }

    public static int zzagz(int n) {
        if (n >= 0) {
            return zzart.zzahe(n);
        }
        return 10;
    }

    public static int zzuy(String string2) {
        int n = zzart.zzb(string2);
        return zzart.zzahe(n) + n;
    }

    public static int zzd(zzasa zzasa2) {
        return zzasa2.cz();
    }

    public static int zze(zzasa zzasa2) {
        int n = zzasa2.cz();
        return zzart.zzahe(n) + n;
    }

    public static int zzbg(byte[] byArray) {
        return zzart.zzahe(byArray.length) + byArray.length;
    }

    public static int zzaha(int n) {
        return zzart.zzahe(zzart.zzahg(n));
    }

    public static int zzda(long l) {
        return zzart.zzdc(zzart.zzde(l));
    }

    public int cl() {
        return this.btF.remaining();
    }

    public void cm() {
        if (this.cl() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzc(byte by) throws IOException {
        if (!this.btF.hasRemaining()) {
            throw new zza(this.btF.position(), this.btF.limit());
        }
        this.btF.put(by);
    }

    public void zzahb(int n) throws IOException {
        this.zzc((byte)n);
    }

    public void zzbh(byte[] byArray) throws IOException {
        this.zzd(byArray, 0, byArray.length);
    }

    public void zzd(byte[] byArray, int n, int n2) throws IOException {
        if (this.btF.remaining() < n2) {
            throw new zza(this.btF.position(), this.btF.limit());
        }
        this.btF.put(byArray, n, n2);
    }

    public void zzaj(int n, int n2) throws IOException {
        this.zzahd(zzasd.zzak(n, n2));
    }

    public static int zzahc(int n) {
        return zzart.zzahe(zzasd.zzak(n, 0));
    }

    public void zzahd(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzahb(n);
                return;
            }
            this.zzahb(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzahe(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzdb(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzahb((int)l);
                return;
            }
            this.zzahb((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzdc(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzahf(int n) throws IOException {
        if (this.btF.remaining() < 4) {
            throw new zza(this.btF.position(), this.btF.limit());
        }
        this.btF.putInt(n);
    }

    public void zzdd(long l) throws IOException {
        if (this.btF.remaining() < 8) {
            throw new zza(this.btF.position(), this.btF.limit());
        }
        this.btF.putLong(l);
    }

    public static int zzahg(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzde(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super(new StringBuilder(108).append("CodedOutputStream was writing to a flat byte array and ran out of space (pos ").append(n).append(" limit ").append(n2).append(").").toString());
        }
    }
}

