/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzxa;

public class zzxi
extends UIController {
    private final ImageView zzasy;
    private final ImageHints zzarV;
    private final Bitmap zzasC;
    private final View zzasD;
    private final ImagePicker zzaqL;
    private final zzxa zzasA;

    public zzxi(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzasy = imageView;
        this.zzarV = imageHints;
        this.zzasC = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzasD = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzaqL = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzasA = new zzxa(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzasA.zza(new zzxa.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    if (zzxi.this.zzasD != null) {
                        zzxi.this.zzasD.setVisibility(4);
                    }
                    zzxi.this.zzasy.setVisibility(0);
                    zzxi.this.zzasy.setImageBitmap(bitmap);
                }
            }
        });
        this.zzty();
        this.zztx();
    }

    @Override
    public void onSessionEnded() {
        this.zzasA.clear();
        this.zzty();
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztx();
    }

    private void zztx() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzty();
            return;
        }
        Uri uri = this.zzd(remoteMediaClient.getMediaInfo());
        if (uri == null) {
            this.zzty();
        } else {
            this.zzasA.zzo(uri);
        }
    }

    private Uri zzd(MediaInfo mediaInfo) {
        WebImage webImage;
        if (mediaInfo == null) {
            return null;
        }
        if (this.zzaqL != null && (webImage = this.zzaqL.onPickImage(mediaInfo.getMetadata(), this.zzarV)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }

    private void zzty() {
        if (this.zzasD != null) {
            this.zzasD.setVisibility(0);
            this.zzasy.setVisibility(4);
        }
        if (this.zzasC != null) {
            this.zzasy.setImageBitmap(this.zzasC);
        }
    }
}

