/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzg;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzwp;
import com.google.android.gms.internal.zzwq;
import com.google.android.gms.internal.zzwr;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzyu;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzyu zzaoQ = new zzyu("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static zza zzaoR;
    private static CastContext zzaoS;
    private final Context zzOZ;
    private final zzg zzaoT;
    private final SessionManager zzaoU;
    private final zzd zzaoV;
    private final CastOptions zzaoW;
    private zzwz zzaoX;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (zzaoS == null) {
            OptionsProvider optionsProvider = CastContext.zzab(context.getApplicationContext());
            zzaoS = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
            if (zzs.zzyA()) {
                zzaoR = new zza(context.getApplicationContext());
                Application application = (Application)context.getApplicationContext();
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzaoR);
            }
        }
        return zzaoS;
    }

    private static OptionsProvider zzab(Context context) throws IllegalStateException {
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = applicationInfo.metaData;
            String string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzOZ = context.getApplicationContext();
        this.zzaoW = castOptions;
        this.zzaoX = new zzwz(MediaRouter.getInstance((Context)this.zzOZ));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzwr zzwr2 = new zzwr(this.zzOZ, castOptions, this.zzaoX);
        hashMap.put(zzwr2.getCategory(), zzwr2.zzsA());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzac.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzac.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzac.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzsA());
            }
        }
        this.zzaoT = zzwq.zza(this.zzOZ, castOptions, this.zzaoX, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzaoT.zzsk();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzg.class.getSimpleName()});
        }
        this.zzaoV = object3 == null ? null : new zzd((zzj)object3);
        Object var7_10 = null;
        try {
            zzn zzn2 = this.zzaoT.zzsj();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzg.class.getSimpleName()});
        }
        this.zzaoU = var7_12 == null ? null : new SessionManager((zzn)var7_12);
    }

    public CastOptions getCastOptions() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzaoW;
    }

    public SessionManager getSessionManager() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzaoU;
    }

    public MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzaoT.zzsi());
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzg.class.getSimpleName()});
            return null;
        }
    }

    public int getCastState() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzaoU.getCastState();
    }

    public boolean isAppVisible() throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzaoT.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzg.class.getSimpleName()});
            return false;
        }
    }

    public void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzac.zzdn((String)"Must be called from the main thread.");
        zzac.zzw((Object)appVisibilityListener);
        try {
            this.zzaoT.zza(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzaoT.zzb(new com.google.android.gms.cast.framework.zza(appVisibilityListener));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzg.class.getSimpleName()});
        }
    }

    public void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzac.zzdn((String)"Must be called from the main thread.");
        zzac.zzw((Object)castStateListener);
        this.zzaoU.addCastStateListener(castStateListener);
    }

    public void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzaoU.removeCastStateListener(castStateListener);
    }

    public zzd zzsf() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzaoV;
    }

    public void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (!zzs.zzyA()) {
            zzwp.zza(fragmentActivity, bundle);
        }
    }

    public void onActivityResumed(Activity activity) {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            this.zzaoT.zzx(zze.zzA((Object)activity));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityResumed", zzg.class.getSimpleName()});
        }
    }

    public void onActivityPaused(Activity activity) {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            this.zzaoT.zzy(zze.zzA((Object)activity));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onActivityPaused", zzg.class.getSimpleName()});
        }
    }

    public boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (zzs.zzyC()) {
            return false;
        }
        CastSession castSession = this.zzaoU.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                this.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                this.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                castSession.setVolume(d2);
            }
            catch (IOException | IllegalStateException exception) {
                zzaoQ.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public com.google.android.gms.dynamic.zzd zzsg() {
        try {
            return this.zzaoT.zzsl();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzg.class.getSimpleName()});
            return null;
        }
    }

    @TargetApi(value=14)
    private static class zza
    implements Application.ActivityLifecycleCallbacks {
        private Context zzOZ;

        public zza(Context context) {
            this.zzOZ = context.getApplicationContext();
        }

        public void onActivityResumed(Activity activity) {
            CastContext.getSharedInstance(this.zzOZ).onActivityResumed(activity);
        }

        public void onActivityPaused(Activity activity) {
            CastContext.getSharedInstance(this.zzOZ).onActivityPaused(activity);
        }

        public void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    }
}

