/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.RemoteException;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzc;
import com.google.android.gms.cast.framework.zzn;
import com.google.android.gms.cast.framework.zzr;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzyu;

public class SessionManager {
    private static final zzyu zzaoQ = new zzyu("SessionManager");
    private final zzn zzapC;

    public SessionManager(zzn zzn2) {
        this.zzapC = zzn2;
    }

    public Session getCurrentSession() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return (Session)zze.zzE((zzd)this.zzapC.zzsr());
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzn.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        zzac.zzdn((String)"Must be called from the main thread.");
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            this.zzapC.zzb(true, bl);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzn.class.getSimpleName()});
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzac.zzw(sessionManagerListener);
        zzac.zzw(clazz);
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            this.zzapC.zza(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzac.zzw((Object)clazz);
        zzac.zzdn((String)"Must be called from the main thread.");
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.zzapC.zzb(new zzr<T>(sessionManagerListener, clazz));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzn.class.getSimpleName()});
        }
    }

    int getCastState() {
        try {
            return this.zzapC.getCastState();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzn.class.getSimpleName()});
            return 1;
        }
    }

    void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzac.zzw((Object)castStateListener);
        try {
            this.zzapC.zza(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzn.class.getSimpleName()});
        }
    }

    void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.zzapC.zzb(new zzc(castStateListener));
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzn.class.getSimpleName()});
        }
    }

    public zzd zzsg() {
        try {
            return this.zzapC.zzsl();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzn.class.getSimpleName()});
            return null;
        }
    }
}

