/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.app.FragmentActivity;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzxa;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxk;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> zzatk = new zzb();
    private final RemoteMediaClient.Listener zzasr = new zza();
    @DrawableRes
    private int zzatl;
    @ColorRes
    private int zzatm;
    @DrawableRes
    private int zzatn;
    @DrawableRes
    private int zzato;
    @DrawableRes
    private int zzatp;
    @DrawableRes
    private int zzatq;
    @DrawableRes
    private int zzatr;
    @DrawableRes
    private int zzats;
    @DrawableRes
    private int zzatt;
    @DrawableRes
    private int zzatu;
    @DrawableRes
    private int zzatv;
    @DrawableRes
    private int zzatw;
    @DrawableRes
    private int zzatx;
    private int zzaty;
    private TextView zzatz;
    private SeekBar zzasI;
    private ImageView zzatA;
    private ImageView zzatB;
    private zzxf zzatC;
    private int[] zzatD;
    private ImageView[] zzatE = new ImageView[4];
    private View zzatF;
    private ImageView zzatG;
    private TextView zzatH;
    private TextView zzatI;
    private zzxa zzatJ;
    private UIMediaController zzatK;
    private SessionManager zzaoU;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CastContext.getSharedInstance((Context)this).registerLifecycleCallbacksBeforeIceCreamSandwich((FragmentActivity)this, bundle);
        this.zzaoU = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.zzaoU.getCurrentCastSession() == null) {
            this.finish();
        }
        this.zzatK = new UIMediaController((Activity)this);
        this.zzatK.setPostRemoteMediaClientListener(this.zzasr);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        this.zztD();
        this.zztE();
        this.zza(this.findViewById(R.id.expanded_controller_layout), this.zzatK);
        this.zza((Toolbar)this.findViewById(R.id.toolbar));
        this.zztK();
        this.zztJ();
        this.zzatJ = new zzxa(this.getApplicationContext(), new ImageHints(-1, this.zzatG.getWidth(), this.zzatG.getHeight()));
        this.zzatJ.zza(new zzxa.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    if (ExpandedControllerActivity.this.zzatH != null) {
                        ExpandedControllerActivity.this.zzatH.setVisibility(8);
                    }
                    if (ExpandedControllerActivity.this.zzatG != null) {
                        ExpandedControllerActivity.this.zzatG.setVisibility(0);
                        ExpandedControllerActivity.this.zzatG.setImageBitmap(bitmap);
                    }
                }
            }
        });
    }

    protected void onResume() {
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.zzatk, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        this.zztK();
        this.zztL();
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.zzatk, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        this.zzatJ.clear();
        if (this.zzatK != null) {
            this.zzatK.setPostRemoteMediaClientListener(null);
            this.zzatK.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zztI();
        }
    }

    public TextView getStatusTextView() {
        return this.zzatz;
    }

    public SeekBar getSeekBar() {
        return this.zzasI;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzatD[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzatE[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzatK;
    }

    private void zztD() {
        TypedArray typedArray = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless, R.attr.colorControlActivated});
        this.zzatl = typedArray.getResourceId(0, 0);
        this.zzatm = typedArray.getResourceId(1, 0);
        typedArray.recycle();
    }

    private void zztE() {
        TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        this.zzaty = typedArray.getResourceId(R.styleable.CastExpandedController_castButtonColor, 0);
        this.zzatn = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarProgressDrawable, 0);
        this.zzato = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarThumbDrawable, 0);
        this.zzatp = typedArray.getResourceId(R.styleable.CastExpandedController_castPlayButtonDrawable, 0);
        this.zzatq = typedArray.getResourceId(R.styleable.CastExpandedController_castPauseButtonDrawable, 0);
        this.zzatr = typedArray.getResourceId(R.styleable.CastExpandedController_castStopButtonDrawable, 0);
        this.zzats = typedArray.getResourceId(R.styleable.CastExpandedController_castSkipPreviousButtonDrawable, 0);
        this.zzatt = typedArray.getResourceId(R.styleable.CastExpandedController_castSkipNextButtonDrawable, 0);
        this.zzatu = typedArray.getResourceId(R.styleable.CastExpandedController_castRewind30ButtonDrawable, 0);
        this.zzatv = typedArray.getResourceId(R.styleable.CastExpandedController_castForward30ButtonDrawable, 0);
        this.zzatw = typedArray.getResourceId(R.styleable.CastExpandedController_castMuteToggleButtonDrawable, 0);
        this.zzatx = typedArray.getResourceId(R.styleable.CastExpandedController_castClosedCaptionsButtonDrawable, 0);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = this.getResources().obtainTypedArray(n);
            zzac.zzas((typedArray2.length() == 4 ? 1 : 0) != 0);
            this.zzatD = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.zzatD[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
        } else {
            this.zzatD = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    private void zza(View view, UIMediaController uIMediaController) {
        this.zzatA = (ImageView)view.findViewById(R.id.background_image_view);
        this.zzatB = (ImageView)view.findViewById(R.id.blurred_background_image_view);
        View view2 = view.findViewById(R.id.background_place_holder_image_view);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        uIMediaController.bindImageViewToImageOfCurrentItem(this.zzatA, new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels), view2);
        this.zzatz = (TextView)view.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)view.findViewById(R.id.start_text);
        TextView textView2 = (TextView)view.findViewById(R.id.end_text);
        ImageView imageView = (ImageView)view.findViewById(R.id.live_stream_indicator);
        this.zzasI = (SeekBar)view.findViewById(R.id.seek_bar);
        this.zztF();
        this.zztH();
        SeekBar seekBar = (SeekBar)view.findViewById(R.id.live_stream_seek_bar);
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2, (View)imageView);
        uIMediaController.bindSeekBar(this.zzasI);
        uIMediaController.bindViewToUIController((View)seekBar, new zzxk(seekBar, this.zzasI));
        this.zzatE[0] = (ImageView)view.findViewById(R.id.button_0);
        this.zzatE[1] = (ImageView)view.findViewById(R.id.button_1);
        this.zzatE[2] = (ImageView)view.findViewById(R.id.button_2);
        this.zzatE[3] = (ImageView)view.findViewById(R.id.button_3);
        this.zza(view, R.id.button_0, this.zzatD[0], uIMediaController);
        this.zza(view, R.id.button_1, this.zzatD[1], uIMediaController);
        this.zza(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        this.zza(view, R.id.button_2, this.zzatD[2], uIMediaController);
        this.zza(view, R.id.button_3, this.zzatD[3], uIMediaController);
        this.zzatF = this.findViewById(R.id.ad_container);
        this.zzatG = (ImageView)this.zzatF.findViewById(R.id.ad_image_view);
        this.zzatI = (TextView)this.zzatF.findViewById(R.id.ad_label);
        this.zzatH = (TextView)this.zzatF.findViewById(R.id.ad_in_progress_label);
        this.zzatC = this.zza((RelativeLayout)view.findViewById(R.id.seek_bar_controls));
    }

    private void zztF() {
        Drawable drawable2;
        Drawable drawable3 = this.getResources().getDrawable(this.zzatn);
        ColorStateList colorStateList = null;
        if (drawable3 != null) {
            if (this.zzatn == R.drawable.cast_expanded_controller_seekbar_track) {
                colorStateList = this.zztG();
                drawable2 = (LayerDrawable)drawable3;
                Drawable drawable4 = DrawableCompat.wrap((Drawable)drawable2.findDrawableByLayerId(16908301));
                DrawableCompat.setTintList((Drawable)drawable4, (ColorStateList)colorStateList);
                drawable2.setDrawableByLayerId(16908301, drawable4);
                Drawable drawable5 = drawable2.findDrawableByLayerId(0x1020000);
                drawable5.setColorFilter(this.getResources().getColor(R.color.cast_expanded_controller_seek_bar_progress_background_tint_color), PorterDuff.Mode.SRC_IN);
            }
            this.zzasI.setProgressDrawable(drawable3);
        }
        if ((drawable2 = this.getResources().getDrawable(this.zzato)) != null) {
            if (this.zzato == R.drawable.cast_expanded_controller_seekbar_thumb) {
                if (colorStateList == null) {
                    colorStateList = this.zztG();
                }
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
            }
            this.zzasI.setThumb(drawable2);
        }
    }

    private ColorStateList zztG() {
        int n = this.getResources().getColor(this.zzatm);
        TypedValue typedValue = new TypedValue();
        this.getResources().getValue(R.dimen.cast_expanded_controller_seekbar_disabled_alpha, typedValue, true);
        int n2 = Color.argb((int)((int)(typedValue.getFloat() * (float)Color.alpha((int)n))), (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        int[] nArray = new int[]{n, n2};
        int[][] nArrayArray = new int[][]{{16842910}, {-16842910}};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    @TargetApi(value=21)
    private void zztH() {
        if (zzs.zzyI()) {
            this.zzasI.setSplitTrack(false);
        }
    }

    private zzxf zza(RelativeLayout relativeLayout) {
        zzxf zzxf2 = new zzxf((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(0, R.id.end_text);
        layoutParams.addRule(1, R.id.start_text);
        layoutParams.addRule(6, R.id.seek_bar);
        layoutParams.addRule(7, R.id.seek_bar);
        layoutParams.addRule(5, R.id.seek_bar);
        layoutParams.addRule(8, R.id.seek_bar);
        zzxf2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        zzxf2.setPadding(this.zzasI.getPaddingLeft(), this.zzasI.getPaddingTop(), this.zzasI.getPaddingRight(), this.zzasI.getPaddingBottom());
        zzxf2.setContentDescription(this.getResources().getString(R.string.cast_seek_bar));
        zzxf2.setBackgroundColor(0);
        relativeLayout.addView((View)zzxf2);
        return zzxf2;
    }

    private void zza(Toolbar toolbar) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
    }

    @TargetApi(value=19)
    private void zztI() {
        if (!zzs.zzyx()) {
            return;
        }
        int n = this.getWindow().getDecorView().getSystemUiVisibility();
        if (zzs.zzyA()) {
            n ^= 2;
        }
        if (zzs.zzyC()) {
            n ^= 4;
        }
        if (zzs.zzyF()) {
            n ^= 0x1000;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(n);
        if (zzs.zzyE()) {
            this.setImmersive(true);
        }
    }

    private void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                this.zza(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_previous) {
                this.zzb(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_next) {
                this.zzc(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                this.zzd(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_forward_30_seconds) {
                this.zze(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_mute_toggle) {
                this.zzf(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_closed_caption) {
                this.zzg(imageView, uIMediaController);
            }
        }
    }

    private void zza(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatq);
        Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatp);
        Drawable drawable4 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatr);
        imageView.setImageDrawable(drawable3);
        uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable3, drawable2, drawable4, null, false);
    }

    private void zzb(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzats));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
        uIMediaController.bindViewToSkipPrev((View)imageView, 0);
    }

    private void zzc(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatt));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
        uIMediaController.bindViewToSkipNext((View)imageView, 0);
    }

    private void zzd(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatu));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
        uIMediaController.bindViewToRewind((View)imageView, 30000L);
    }

    private void zze(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatv));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
        uIMediaController.bindViewToForward((View)imageView, 30000L);
    }

    private void zzf(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatw));
        uIMediaController.bindImageViewToMuteToggle(imageView);
    }

    private void zzg(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzatl);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzaty, this.zzatx));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }

    private RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.zzaoU.getCurrentCastSession();
        return castSession != null && castSession.isConnected() ? castSession.getRemoteMediaClient() : null;
    }

    private void zztJ() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private void zztK() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.zzaoU.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.zzatz.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.zzatz.setText((CharSequence)"");
    }

    private void zztL() {
        boolean bl;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        MediaInfo mediaInfo = remoteMediaClient == null ? null : remoteMediaClient.getMediaInfo();
        MediaStatus mediaStatus = remoteMediaClient == null ? null : remoteMediaClient.getMediaStatus();
        boolean bl2 = bl = mediaStatus != null && mediaStatus.isPlayingAd();
        if (bl) {
            AdBreakClipInfo adBreakClipInfo;
            String string2;
            Object object;
            if (zzs.zzyD() && this.zzatB.getVisibility() == 8 && (object = this.zzatA.getDrawable()) != null && object instanceof BitmapDrawable && (string2 = ((BitmapDrawable)object).getBitmap()) != null && (adBreakClipInfo = com.google.android.gms.cast.framework.media.widget.zza.zza((Context)this, (Bitmap)string2, 0.25f, 7.5f)) != null) {
                this.zzatB.setImageBitmap((Bitmap)adBreakClipInfo);
                this.zzatB.setVisibility(0);
            }
            object = null;
            string2 = null;
            adBreakClipInfo = mediaStatus.getCurrentAdBreakClip();
            if (adBreakClipInfo != null) {
                object = adBreakClipInfo.getTitle();
                string2 = adBreakClipInfo.getContentUrl();
            }
            this.zzatH.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Uri uri = Uri.parse((String)string2);
                this.zzatJ.zzo(uri);
            } else {
                this.zzatG.setVisibility(8);
            }
            this.zzatI.setText((CharSequence)(TextUtils.isEmpty((CharSequence)object) ? this.getResources().getString(R.string.cast_ad_label) : object));
            this.zzasI.setEnabled(false);
            this.zzatF.setVisibility(0);
        } else {
            this.zzasI.setEnabled(true);
            this.zzatF.setVisibility(8);
            if (zzs.zzyD()) {
                this.zzatB.setVisibility(8);
                this.zzatB.setImageBitmap(null);
            }
        }
        if (mediaInfo != null) {
            this.zzatC.zzcc(this.zzasI.getMax());
            this.zzatC.zzb(mediaInfo.getAdBreaks(), -1);
        }
    }

    private class zza
    implements RemoteMediaClient.Listener {
        private zza() {
        }

        @Override
        public void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = ExpandedControllerActivity.this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                ExpandedControllerActivity.this.finish();
                return;
            }
            ExpandedControllerActivity.this.zztK();
            ExpandedControllerActivity.this.zztL();
        }

        @Override
        public void onMetadataUpdated() {
            ExpandedControllerActivity.this.zztJ();
        }

        @Override
        public void onQueueStatusUpdated() {
        }

        @Override
        public void onPreloadStatusUpdated() {
        }

        @Override
        public void onSendingRemoteMediaRequest() {
            ExpandedControllerActivity.this.zzatz.setText((CharSequence)ExpandedControllerActivity.this.getResources().getString(R.string.cast_expanded_controller_loading));
        }

        @Override
        public void onAdBreakStatusUpdated() {
            ExpandedControllerActivity.this.zztL();
        }
    }

    private class zzb
    implements SessionManagerListener<CastSession> {
        private zzb() {
        }

        @Override
        public void onSessionEnded(CastSession castSession, int n) {
            ExpandedControllerActivity.this.finish();
        }
    }
}

