/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;

public class zzxe
implements RemoteMediaClient.Listener {
    private final Context zzOZ;
    private final CastOptions zzase;
    private final zzwz zzapH;
    private final ComponentName zzasf;
    private final zzxa zzasg;
    private final zzxa zzash;
    private RemoteMediaClient zzapk;
    private CastDevice zzamc;
    private MediaSessionCompat zzasi;
    private MediaSessionCompat.Callback zzasj;
    private boolean zzask;

    public zzxe(Context context, CastOptions castOptions, zzwz zzwz2) {
        this.zzOZ = context;
        this.zzase = castOptions;
        this.zzapH = zzwz2;
        this.zzasf = this.zzase.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzase.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzOZ, this.zzase.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzasg = new zzxa(this.zzOZ);
        this.zzasg.zza(new zzxa.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                bitmap = zzxe.zzd(bitmap);
                zzxe.this.zza(bitmap, 0);
            }
        });
        this.zzash = new zzxa(this.zzOZ);
        this.zzash.zza(new zzxa.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                zzxe.this.zza(bitmap, 3);
            }
        });
    }

    public static Bitmap zzd(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        int n3 = (int)((float)n * 9.0f / 16.0f + 0.5f);
        float f = (n3 - n2) / 2;
        RectF rectF = new RectF(0.0f, f, (float)n, f + (float)n2);
        Bitmap bitmap2 = Bitmap.createBitmap((int)n, (int)n3, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawBitmap(bitmap, null, rectF, null);
        return bitmap2;
    }

    public void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        AudioManager audioManager;
        if (this.zzask || this.zzase == null || this.zzase.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzapk = remoteMediaClient;
        this.zzapk.addListener(this);
        this.zzamc = castDevice;
        if (!zzs.zzyI()) {
            audioManager = (AudioManager)this.zzOZ.getSystemService("audio");
            audioManager.requestAudioFocus(null, 3, 3);
        }
        audioManager = new ComponentName(this.zzOZ, this.zzase.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent((ComponentName)audioManager);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzOZ, (int)0, (Intent)intent, (int)0);
        this.zzasi = new MediaSessionCompat(this.zzOZ, "CastMediaSession", (ComponentName)audioManager, pendingIntent);
        this.zzasi.setFlags(3);
        this.zza(0, null);
        if (this.zzamc != null && !TextUtils.isEmpty((CharSequence)this.zzamc.getFriendlyName())) {
            this.zzasi.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzOZ.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzamc.getFriendlyName()})).build());
        }
        this.zzasj = new MediaSessionCompat.Callback(){

            public boolean onMediaButtonEvent(Intent intent) {
                KeyEvent keyEvent = (KeyEvent)intent.getParcelableExtra("android.intent.extra.KEY_EVENT");
                if (keyEvent != null && (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 126)) {
                    zzxe.this.zzapk.togglePlayback();
                }
                return true;
            }

            public void onPlay() {
                zzxe.this.zzapk.togglePlayback();
            }

            public void onPause() {
                zzxe.this.zzapk.togglePlayback();
            }
        };
        this.zzasi.setCallback(this.zzasj);
        this.zzasi.setActive(true);
        this.zzapH.setMediaSessionCompat(this.zzasi);
        this.zzask = true;
        this.zzto();
    }

    public void zzcb(int n) {
        if (!this.zzask) {
            return;
        }
        this.zzask = false;
        if (this.zzapk != null) {
            this.zzapk.removeListener(this);
        }
        if (!zzs.zzyI()) {
            AudioManager audioManager = (AudioManager)this.zzOZ.getSystemService("audio");
            audioManager.abandonAudioFocus(null);
        }
        this.zzapH.setMediaSessionCompat(null);
        if (this.zzasg != null) {
            this.zzasg.clear();
        }
        if (this.zzash != null) {
            this.zzash.clear();
        }
        if (this.zzasi != null) {
            this.zzasi.setSessionActivity(null);
            this.zzasi.setCallback(null);
            this.zzasi.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzasi.setActive(false);
            this.zzasi.release();
            this.zzasi = null;
        }
        this.zzapk = null;
        this.zzamc = null;
        this.zzasj = null;
        this.zztr();
        if (n == 0) {
            this.zztt();
        }
    }

    public MediaSessionCompat.Token getMediaSessionToken() {
        return this.zzasi == null ? null : this.zzasi.getSessionToken();
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzto();
    }

    @Override
    public void onStatusUpdated() {
        this.zzto();
    }

    @Override
    public void onMetadataUpdated() {
        this.zzto();
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzto();
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzto();
    }

    @Override
    public void onSendingRemoteMediaRequest() {
    }

    private void zzto() {
        int n;
        MediaStatus mediaStatus = this.zzapk.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzapk.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.zzapk.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zztr();
            this.zztt();
        } else {
            this.zztq();
            if (!bl) {
                this.zzts();
            }
        }
    }

    private void zza(int n, MediaInfo mediaInfo) {
        if (n == 0) {
            this.zzasi.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzasi.setMetadata(new MediaMetadataCompat.Builder().build());
        } else {
            this.zzasi.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
            this.zzasi.setSessionActivity(this.zztu());
            this.zzb(mediaInfo);
        }
    }

    private void zzb(MediaInfo mediaInfo) {
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        MediaMetadataCompat.Builder builder = this.zztp().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", mediaInfo.getStreamDuration());
        this.zzasi.setMetadata(builder.build());
        Uri uri = this.zza(mediaMetadata, 0);
        if (uri != null) {
            this.zzasg.zzo(uri);
        } else {
            this.zza((Bitmap)null, 0);
        }
        Uri uri2 = this.zza(mediaMetadata, 3);
        if (uri2 != null) {
            this.zzash.zzo(uri2);
        } else {
            this.zza((Bitmap)null, 3);
        }
    }

    private void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzasi.setMetadata(this.zztp().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
            } else {
                Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bitmap2.eraseColor(0);
                this.zzasi.setMetadata(this.zztp().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            }
        } else if (n == 3) {
            this.zzasi.setMetadata(this.zztp().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage = this.zzase.getCastMediaOptions().getImagePicker() != null ? this.zzase.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null);
        return webImage == null ? null : webImage.getUrl();
    }

    private MediaMetadataCompat.Builder zztp() {
        MediaMetadataCompat mediaMetadataCompat = this.zzasi.getController().getMetadata();
        return mediaMetadataCompat == null ? new MediaMetadataCompat.Builder() : new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private void zztq() {
        if (this.zzase.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        if (this.zzapk == null) {
            return;
        }
        Intent intent = new Intent(this.zzOZ, MediaNotificationService.class);
        intent.setPackage(this.zzOZ.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        intent.putExtra("extra_media_info", (Parcelable)this.zzapk.getMediaInfo());
        intent.putExtra("extra_remote_media_client_player_state", this.zzapk.getPlayerState());
        intent.putExtra("extra_cast_device", (Parcelable)this.zzamc);
        intent.putExtra("extra_media_session_token", (Parcelable)this.getMediaSessionToken());
        MediaStatus mediaStatus = this.zzapk.getMediaStatus();
        if (mediaStatus != null) {
            boolean bl = false;
            boolean bl2 = false;
            switch (mediaStatus.getQueueRepeatMode()) {
                case 1: 
                case 2: 
                case 3: {
                    bl = true;
                    bl2 = true;
                    break;
                }
                default: {
                    Integer n = mediaStatus.getIndexById(mediaStatus.getCurrentItemId());
                    if (n == null) break;
                    if (n > 0) {
                        bl2 = true;
                    }
                    if (n >= mediaStatus.getQueueItemCount() - 1) break;
                    bl = true;
                }
            }
            intent.putExtra("extra_can_skip_next", bl);
            intent.putExtra("extra_can_skip_prev", bl2);
        }
        this.zzOZ.startService(intent);
    }

    private void zztr() {
        if (this.zzase.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzOZ, MediaNotificationService.class);
        intent.setPackage(this.zzOZ.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzOZ.stopService(intent);
    }

    private void zzts() {
        if (!this.zzase.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzOZ, ReconnectionService.class);
        intent.setPackage(this.zzOZ.getPackageName());
        this.zzOZ.startService(intent);
    }

    private void zztt() {
        if (!this.zzase.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzOZ, ReconnectionService.class);
        intent.setPackage(this.zzOZ.getPackageName());
        this.zzOZ.stopService(intent);
    }

    private PendingIntent zztu() {
        if (this.zzasf == null) {
            return null;
        }
        Intent intent = new Intent();
        intent.setComponent(this.zzasf);
        return PendingIntent.getActivity((Context)this.zzOZ, (int)0, (Intent)intent, (int)0x8000000);
    }
}

