/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.app.FragmentActivity;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxk;
import com.google.android.gms.internal.zzxp;

public abstract class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> zzauo = new zzb();
    private final RemoteMediaClient.Listener zzatv = new zza();
    @DrawableRes
    private int zzaup;
    @ColorRes
    private int zzauq;
    @DrawableRes
    private int zzaur;
    @DrawableRes
    private int zzaus;
    @DrawableRes
    private int zzaut;
    @DrawableRes
    private int zzauu;
    @DrawableRes
    private int zzauv;
    @DrawableRes
    private int zzauw;
    @DrawableRes
    private int zzaux;
    @DrawableRes
    private int zzauy;
    @DrawableRes
    private int zzauz;
    @DrawableRes
    private int zzauA;
    @DrawableRes
    private int zzauB;
    private int zzauC;
    private TextView zzauD;
    private SeekBar zzatM;
    private ImageView zzauE;
    private ImageView zzauF;
    private zzxk zzauG;
    private int[] zzauH;
    private ImageView[] zzauI = new ImageView[4];
    private View zzauJ;
    private ImageView zzauK;
    private TextView zzauL;
    private TextView zzauM;
    private zzxf zzauN;
    private UIMediaController zzauO;
    private SessionManager zzapY;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        CastContext.getSharedInstance((Context)this).registerLifecycleCallbacksBeforeIceCreamSandwich((FragmentActivity)this, bundle);
        this.zzapY = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.zzapY.getCurrentCastSession() == null) {
            this.finish();
        }
        this.zzauO = new UIMediaController((Activity)this);
        this.zzauO.setPostRemoteMediaClientListener(this.zzatv);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        this.zzuc();
        this.zzud();
        this.zza(this.findViewById(R.id.expanded_controller_layout), this.zzauO);
        this.zza((Toolbar)this.findViewById(R.id.toolbar));
        this.zzuj();
        this.zzui();
        this.zzauN = new zzxf(this.getApplicationContext(), new ImageHints(-1, this.zzauK.getWidth(), this.zzauK.getHeight()));
        this.zzauN.zza(new zzxf.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    if (ExpandedControllerActivity.this.zzauL != null) {
                        ExpandedControllerActivity.this.zzauL.setVisibility(8);
                    }
                    if (ExpandedControllerActivity.this.zzauK != null) {
                        ExpandedControllerActivity.this.zzauK.setVisibility(0);
                        ExpandedControllerActivity.this.zzauK.setImageBitmap(bitmap);
                    }
                }
            }
        });
    }

    protected void onResume() {
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.zzauo, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        this.zzuj();
        this.zzuk();
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.zzauo, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        this.zzauN.clear();
        if (this.zzauO != null) {
            this.zzauO.setPostRemoteMediaClientListener(null);
            this.zzauO.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzuh();
        }
    }

    public TextView getStatusTextView() {
        return this.zzauD;
    }

    public SeekBar getSeekBar() {
        return this.zzatM;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzauH[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzauI[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzauO;
    }

    private void zzuc() {
        TypedArray typedArray = this.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless, R.attr.colorControlActivated});
        this.zzaup = typedArray.getResourceId(0, 0);
        this.zzauq = typedArray.getResourceId(1, 0);
        typedArray.recycle();
    }

    private void zzud() {
        TypedArray typedArray = this.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        this.zzauC = typedArray.getResourceId(R.styleable.CastExpandedController_castButtonColor, 0);
        this.zzaur = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarProgressDrawable, 0);
        this.zzaus = typedArray.getResourceId(R.styleable.CastExpandedController_castSeekBarThumbDrawable, 0);
        this.zzaut = typedArray.getResourceId(R.styleable.CastExpandedController_castPlayButtonDrawable, 0);
        this.zzauu = typedArray.getResourceId(R.styleable.CastExpandedController_castPauseButtonDrawable, 0);
        this.zzauv = typedArray.getResourceId(R.styleable.CastExpandedController_castStopButtonDrawable, 0);
        this.zzauw = typedArray.getResourceId(R.styleable.CastExpandedController_castSkipPreviousButtonDrawable, 0);
        this.zzaux = typedArray.getResourceId(R.styleable.CastExpandedController_castSkipNextButtonDrawable, 0);
        this.zzauy = typedArray.getResourceId(R.styleable.CastExpandedController_castRewind30ButtonDrawable, 0);
        this.zzauz = typedArray.getResourceId(R.styleable.CastExpandedController_castForward30ButtonDrawable, 0);
        this.zzauA = typedArray.getResourceId(R.styleable.CastExpandedController_castMuteToggleButtonDrawable, 0);
        this.zzauB = typedArray.getResourceId(R.styleable.CastExpandedController_castClosedCaptionsButtonDrawable, 0);
        int n = typedArray.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = this.getResources().obtainTypedArray(n);
            zzac.zzax((typedArray2.length() == 4 ? 1 : 0) != 0);
            this.zzauH = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.zzauH[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
        } else {
            this.zzauH = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    private void zza(View view, UIMediaController uIMediaController) {
        this.zzauE = (ImageView)view.findViewById(R.id.background_image_view);
        this.zzauF = (ImageView)view.findViewById(R.id.blurred_background_image_view);
        View view2 = view.findViewById(R.id.background_place_holder_image_view);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        uIMediaController.bindImageViewToImageOfCurrentItem(this.zzauE, new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels), view2);
        this.zzauD = (TextView)view.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)view.findViewById(R.id.start_text);
        TextView textView2 = (TextView)view.findViewById(R.id.end_text);
        ImageView imageView = (ImageView)view.findViewById(R.id.live_stream_indicator);
        this.zzatM = (SeekBar)view.findViewById(R.id.seek_bar);
        this.zzue();
        this.zzug();
        SeekBar seekBar = (SeekBar)view.findViewById(R.id.live_stream_seek_bar);
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2, (View)imageView);
        uIMediaController.bindSeekBar(this.zzatM);
        uIMediaController.bindViewToUIController((View)seekBar, new zzxp(seekBar, this.zzatM));
        this.zzauI[0] = (ImageView)view.findViewById(R.id.button_0);
        this.zzauI[1] = (ImageView)view.findViewById(R.id.button_1);
        this.zzauI[2] = (ImageView)view.findViewById(R.id.button_2);
        this.zzauI[3] = (ImageView)view.findViewById(R.id.button_3);
        this.zza(view, R.id.button_0, this.zzauH[0], uIMediaController);
        this.zza(view, R.id.button_1, this.zzauH[1], uIMediaController);
        this.zza(view, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        this.zza(view, R.id.button_2, this.zzauH[2], uIMediaController);
        this.zza(view, R.id.button_3, this.zzauH[3], uIMediaController);
        this.zzauJ = this.findViewById(R.id.ad_container);
        this.zzauK = (ImageView)this.zzauJ.findViewById(R.id.ad_image_view);
        this.zzauM = (TextView)this.zzauJ.findViewById(R.id.ad_label);
        this.zzauL = (TextView)this.zzauJ.findViewById(R.id.ad_in_progress_label);
        this.zzauG = this.zza((RelativeLayout)view.findViewById(R.id.seek_bar_controls));
    }

    private void zzue() {
        Drawable drawable2;
        Drawable drawable3 = this.getResources().getDrawable(this.zzaur);
        ColorStateList colorStateList = null;
        if (drawable3 != null) {
            if (this.zzaur == R.drawable.cast_expanded_controller_seekbar_track) {
                colorStateList = this.zzuf();
                drawable2 = (LayerDrawable)drawable3;
                Drawable drawable4 = DrawableCompat.wrap((Drawable)drawable2.findDrawableByLayerId(16908301));
                DrawableCompat.setTintList((Drawable)drawable4, (ColorStateList)colorStateList);
                drawable2.setDrawableByLayerId(16908301, drawable4);
                Drawable drawable5 = drawable2.findDrawableByLayerId(0x1020000);
                drawable5.setColorFilter(this.getResources().getColor(R.color.cast_expanded_controller_seek_bar_progress_background_tint_color), PorterDuff.Mode.SRC_IN);
            }
            this.zzatM.setProgressDrawable(drawable3);
        }
        if ((drawable2 = this.getResources().getDrawable(this.zzaus)) != null) {
            if (this.zzaus == R.drawable.cast_expanded_controller_seekbar_thumb) {
                if (colorStateList == null) {
                    colorStateList = this.zzuf();
                }
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
            }
            this.zzatM.setThumb(drawable2);
        }
    }

    private ColorStateList zzuf() {
        int n = this.getResources().getColor(this.zzauq);
        TypedValue typedValue = new TypedValue();
        this.getResources().getValue(R.dimen.cast_expanded_controller_seekbar_disabled_alpha, typedValue, true);
        int n2 = Color.argb((int)((int)(typedValue.getFloat() * (float)Color.alpha((int)n))), (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        int[] nArray = new int[]{n, n2};
        int[][] nArrayArray = new int[][]{{16842910}, {-16842910}};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    @TargetApi(value=21)
    private void zzug() {
        if (zzt.zzzo()) {
            this.zzatM.setSplitTrack(false);
        }
    }

    private zzxk zza(RelativeLayout relativeLayout) {
        zzxk zzxk2 = new zzxk((Context)this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(0, R.id.end_text);
        layoutParams.addRule(1, R.id.start_text);
        layoutParams.addRule(6, R.id.seek_bar);
        layoutParams.addRule(7, R.id.seek_bar);
        layoutParams.addRule(5, R.id.seek_bar);
        layoutParams.addRule(8, R.id.seek_bar);
        zzxk2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        zzxk2.setPadding(this.zzatM.getPaddingLeft(), this.zzatM.getPaddingTop(), this.zzatM.getPaddingRight(), this.zzatM.getPaddingBottom());
        zzxk2.setContentDescription(this.getResources().getString(R.string.cast_seek_bar));
        zzxk2.setBackgroundColor(0);
        relativeLayout.addView((View)zzxk2);
        return zzxk2;
    }

    private void zza(Toolbar toolbar) {
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
    }

    @TargetApi(value=19)
    private void zzuh() {
        zzt.zzze();
        int n = this.getWindow().getDecorView().getSystemUiVisibility();
        zzt.zzzg();
        n ^= 2;
        if (zzt.zzzi()) {
            n ^= 4;
        }
        if (zzt.zzzl()) {
            n ^= 0x1000;
        }
        this.getWindow().getDecorView().setSystemUiVisibility(n);
        if (zzt.zzzk()) {
            this.setImmersive(true);
        }
    }

    private void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                this.zza(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_previous) {
                this.zzb(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_skip_next) {
                this.zzc(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                this.zzd(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_forward_30_seconds) {
                this.zze(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_mute_toggle) {
                this.zzf(imageView, uIMediaController);
            } else if (n2 == R.id.cast_button_type_closed_caption) {
                this.zzg(imageView, uIMediaController);
            }
        }
    }

    private void zza(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauu);
        Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzaut);
        Drawable drawable4 = com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauv);
        imageView.setImageDrawable(drawable3);
        uIMediaController.bindImageViewToPlayPauseToggle(imageView, drawable3, drawable2, drawable4, null, false);
    }

    private void zzb(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauw));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
        uIMediaController.bindViewToSkipPrev((View)imageView, 0);
    }

    private void zzc(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzaux));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
        uIMediaController.bindViewToSkipNext((View)imageView, 0);
    }

    private void zzd(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauy));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
        uIMediaController.bindViewToRewind((View)imageView, 30000L);
    }

    private void zze(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauz));
        imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
        uIMediaController.bindViewToForward((View)imageView, 30000L);
    }

    private void zzf(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauA));
        uIMediaController.bindImageViewToMuteToggle(imageView);
    }

    private void zzg(ImageView imageView, UIMediaController uIMediaController) {
        imageView.setBackgroundResource(this.zzaup);
        imageView.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zza.zzb((Context)this, this.zzauC, this.zzauB));
        uIMediaController.bindViewToClosedCaption((View)imageView);
    }

    private RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.zzapY.getCurrentCastSession();
        return castSession != null && castSession.isConnected() ? castSession.getRemoteMediaClient() : null;
    }

    private void zzui() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private void zzuj() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.zzapY.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.zzauD.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.zzauD.setText((CharSequence)"");
    }

    private void zzuk() {
        boolean bl;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        MediaInfo mediaInfo = remoteMediaClient == null ? null : remoteMediaClient.getMediaInfo();
        MediaStatus mediaStatus = remoteMediaClient == null ? null : remoteMediaClient.getMediaStatus();
        boolean bl2 = bl = mediaStatus != null && mediaStatus.isPlayingAd();
        if (bl) {
            AdBreakClipInfo adBreakClipInfo;
            String string2;
            Object object;
            if (zzt.zzzj() && this.zzauF.getVisibility() == 8 && (object = this.zzauE.getDrawable()) != null && object instanceof BitmapDrawable && (string2 = ((BitmapDrawable)object).getBitmap()) != null && (adBreakClipInfo = com.google.android.gms.cast.framework.media.widget.zza.zza((Context)this, (Bitmap)string2, 0.25f, 7.5f)) != null) {
                this.zzauF.setImageBitmap((Bitmap)adBreakClipInfo);
                this.zzauF.setVisibility(0);
            }
            object = null;
            string2 = null;
            adBreakClipInfo = mediaStatus.getCurrentAdBreakClip();
            if (adBreakClipInfo != null) {
                object = adBreakClipInfo.getTitle();
                string2 = adBreakClipInfo.getContentUrl();
            }
            this.zzauL.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Uri uri = Uri.parse((String)string2);
                this.zzauN.zzo(uri);
            } else {
                this.zzauK.setVisibility(8);
            }
            this.zzauM.setText((CharSequence)(TextUtils.isEmpty((CharSequence)object) ? this.getResources().getString(R.string.cast_ad_label) : object));
            this.zzatM.setEnabled(false);
            this.zzauJ.setVisibility(0);
        } else {
            this.zzatM.setEnabled(true);
            this.zzauJ.setVisibility(8);
            if (zzt.zzzj()) {
                this.zzauF.setVisibility(8);
                this.zzauF.setImageBitmap(null);
            }
        }
        if (mediaInfo != null) {
            this.zzauG.zzcf(this.zzatM.getMax());
            this.zzauG.zzb(mediaInfo.getAdBreaks(), -1);
        }
    }

    private class zza
    implements RemoteMediaClient.Listener {
        private zza() {
        }

        @Override
        public void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = ExpandedControllerActivity.this.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                ExpandedControllerActivity.this.finish();
                return;
            }
            ExpandedControllerActivity.this.zzuj();
            ExpandedControllerActivity.this.zzuk();
        }

        @Override
        public void onMetadataUpdated() {
            ExpandedControllerActivity.this.zzui();
        }

        @Override
        public void onQueueStatusUpdated() {
        }

        @Override
        public void onPreloadStatusUpdated() {
        }

        @Override
        public void onSendingRemoteMediaRequest() {
            ExpandedControllerActivity.this.zzauD.setText((CharSequence)ExpandedControllerActivity.this.getResources().getString(R.string.cast_expanded_controller_loading));
        }

        @Override
        public void onAdBreakStatusUpdated() {
            ExpandedControllerActivity.this.zzuk();
        }
    }

    private class zzb
    implements SessionManagerListener<CastSession> {
        private zzb() {
        }

        @Override
        public void onSessionEnded(CastSession castSession, int n) {
            ExpandedControllerActivity.this.finish();
        }
    }
}

