/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzxf;

public class zzxm
extends UIController {
    private final ImageView zzatC;
    private final ImageHints zzasZ;
    private final Bitmap zzatD;
    private final ImagePicker zzarP;
    private final zzxf zzatE;

    public zzxm(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzatC = imageView;
        this.zzasZ = imageHints;
        this.zzatD = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzarP = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzatE = new zzxf(context.getApplicationContext());
    }

    @Override
    public void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzatE.zza(new zzxf.zza(){

            @Override
            public void zzc(Bitmap bitmap) {
                if (bitmap != null) {
                    zzxm.this.zzatC.setImageBitmap(bitmap);
                }
            }
        });
        this.zzatC.setImageBitmap(this.zzatD);
        this.zztW();
    }

    @Override
    public void onSessionEnded() {
        this.zzatE.clear();
        this.zzatC.setImageBitmap(this.zzatD);
        super.onSessionEnded();
    }

    @Override
    public void onMediaStatusUpdated() {
        this.zztW();
    }

    private void zztW() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzatC.setImageBitmap(this.zzatD);
            return;
        }
        Uri uri = this.zza(remoteMediaClient.getPreloadedItem());
        if (uri == null) {
            this.zzatC.setImageBitmap(this.zzatD);
        } else {
            this.zzatE.zzo(uri);
        }
    }

    private Uri zza(MediaQueueItem mediaQueueItem) {
        WebImage webImage;
        if (mediaQueueItem == null) {
            return null;
        }
        MediaInfo mediaInfo = mediaQueueItem.getMedia();
        if (mediaInfo == null) {
            return null;
        }
        if (this.zzarP != null && (webImage = this.zzarP.onPickImage(mediaInfo.getMetadata(), this.zzasZ)) != null && webImage.getUrl() != null) {
            return webImage.getUrl();
        }
        return MediaUtils.getImageUri(mediaInfo, 0);
    }
}

