/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zza;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzyz;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzyz zzapV = new zzyz("MiniControllerFragment");
    private boolean zzauQ;
    private int zzauR;
    private int zzauS;
    private int zzauT;
    private int zzauU;
    private int zzauC;
    private int[] zzauH;
    private ImageView[] zzauI = new ImageView[3];
    private int zzauV;
    @DrawableRes
    private int zzaut;
    @DrawableRes
    private int zzauu;
    @DrawableRes
    private int zzauv;
    @DrawableRes
    private int zzauW;
    @DrawableRes
    private int zzauX;
    @DrawableRes
    private int zzauY;
    @DrawableRes
    private int zzauw;
    @DrawableRes
    private int zzaux;
    @DrawableRes
    private int zzauy;
    @DrawableRes
    private int zzauz;
    @DrawableRes
    private int zzauA;
    @DrawableRes
    private int zzauB;
    private UIMediaController zzauO;

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        this.zza(context, attributeSet);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzauO = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzauO.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzauT != 0) {
            relativeLayout.setBackgroundResource(this.zzauT);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzauR != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzauR);
        }
        TextView textView2 = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzauS != 0) {
            textView2.setTextAppearance((Context)this.getActivity(), this.zzauS);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzauU != 0) {
            LayerDrawable layerDrawable = (LayerDrawable)progressBar.getProgressDrawable();
            layerDrawable.setColorFilter(this.zzauU, PorterDuff.Mode.SRC_IN);
        }
        this.zzauO.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzauO.bindTextViewToMetadataOfCurrentItem(textView2, "com.google.android.gms.cast.metadata.SUBTITLE");
        this.zzauO.bindProgressBar(progressBar);
        this.zzauO.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzauQ) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzauO.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzauI[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzauI[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzauI[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzauO != null) {
            this.zzauO.dispose();
            this.zzauO = null;
        }
        super.onDestroy();
    }

    private void zza(Context context, AttributeSet attributeSet) {
        if (this.zzauH != null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
        this.zzauQ = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
        this.zzauR = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
        this.zzauS = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
        this.zzauT = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
        this.zzauU = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
        this.zzauC = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
        this.zzaut = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
        this.zzauu = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
        this.zzauv = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
        this.zzauW = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
        this.zzauX = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
        this.zzauY = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
        this.zzauw = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
        this.zzaux = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
        this.zzauy = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
        this.zzauz = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
        this.zzauA = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
        this.zzauB = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
        int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
        if (n != 0) {
            TypedArray typedArray2 = context.getResources().obtainTypedArray(n);
            zzac.zzaw((typedArray2.length() == 3 ? 1 : 0) != 0);
            this.zzauH = new int[typedArray2.length()];
            for (int i = 0; i < typedArray2.length(); ++i) {
                this.zzauH[i] = typedArray2.getResourceId(i, 0);
            }
            typedArray2.recycle();
            if (this.zzauQ) {
                this.zzauH[0] = R.id.cast_button_type_empty;
            }
            this.zzauV = 0;
            for (int n2 : this.zzauH) {
                if (n2 == R.id.cast_button_type_empty) continue;
                ++this.zzauV;
            }
        } else {
            zzapV.zzf("Unable to read attribute castControlButtons.", new Object[0]);
            this.zzauH = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray.recycle();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzauH[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzauI[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzauO;
    }

    private void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzauH[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
        } else if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzaut;
                int n5 = this.zzauu;
                int n6 = this.zzauv;
                if (this.zzauV == 1) {
                    n4 = this.zzauW;
                    n5 = this.zzauX;
                    n6 = this.zzauY;
                }
                Drawable drawable2 = zza.zza(this.getContext(), this.zzauC, n4);
                Drawable drawable3 = zza.zza(this.getContext(), this.zzauC, n5);
                Drawable drawable4 = zza.zza(this.getContext(), this.zzauC, n6);
                imageView.setImageDrawable(drawable3);
                ProgressBar progressBar = this.zzcg(n);
                relativeLayout.addView((View)progressBar);
                this.zzauO.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar, true);
            } else if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzauw));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzauO.bindViewToSkipPrev((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzaux));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzauO.bindViewToSkipNext((View)imageView, 0);
            } else if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzauy));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzauO.bindViewToRewind((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzauz));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzauO.bindViewToForward((View)imageView, 30000L);
            } else if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzauA));
                this.zzauO.bindImageViewToMuteToggle(imageView);
            } else if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zza.zza(this.getContext(), this.zzauC, this.zzauB));
                this.zzauO.bindViewToClosedCaption((View)imageView);
            }
        }
    }

    private ProgressBar zzcg(int n) {
        ProgressBar progressBar = new ProgressBar(this.getContext());
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(8, n);
        layoutParams.addRule(6, n);
        layoutParams.addRule(5, n);
        layoutParams.addRule(7, n);
        layoutParams.addRule(15);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        progressBar.setVisibility(8);
        Drawable drawable2 = progressBar.getIndeterminateDrawable();
        if (this.zzauU != 0 && drawable2 != null) {
            drawable2.setColorFilter(this.zzauU, PorterDuff.Mode.SRC_IN);
        }
        return progressBar;
    }
}

