/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzk;
import com.google.android.gms.cast.framework.zzq;
import com.google.android.gms.cast.framework.zzw;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzavv;
import com.google.android.gms.internal.zzavw;
import com.google.android.gms.internal.zzawn;
import com.google.android.gms.internal.zzbaa;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzbaa zzarM = new zzbaa("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzarN;
    private final Context zzarO;
    private final zzk zzarP;
    private final SessionManager zzarQ;
    private final zze zzarR;
    private final CastOptions zzarS;
    private zzawn zzarT;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (zzarN == null) {
            OptionsProvider optionsProvider = CastContext.zzak(context.getApplicationContext());
            zzarN = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzarN;
    }

    private static OptionsProvider zzak(Context context) throws IllegalStateException {
        try {
            String string = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY);
            if (string == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).newInstance();
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NullPointerException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzarO = context.getApplicationContext();
        this.zzarS = castOptions;
        this.zzarT = new zzawn(MediaRouter.getInstance((Context)this.zzarO));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzavw zzavw2 = new zzavw(this.zzarO, castOptions, this.zzarT);
        hashMap.put(zzavw2.getCategory(), zzavw2.zznF());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbr.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzbr.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbr.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zznF());
            }
        }
        this.zzarP = zzavv.zza(this.zzarO, castOptions, this.zzarT, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzarP.zznr();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzk.class.getSimpleName()});
        }
        this.zzarR = object3 == null ? null : new zze((zzq)object3);
        Object var7_10 = null;
        try {
            zzw zzw2 = this.zzarP.zznq();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzk.class.getSimpleName()});
        }
        this.zzarQ = var7_12 == null ? null : new SessionManager((zzw)var7_12);
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzarS;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzarQ;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzarP.zznp());
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzk.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzarQ.getCastState();
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        try {
            return this.zzarP.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzk.class.getSimpleName()});
            return false;
        }
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        zzbr.zzu((Object)appVisibilityListener);
        try {
            this.zzarP.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzk.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzarP.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzk.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        zzbr.zzu((Object)castStateListener);
        this.zzarQ.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzarQ.removeCastStateListener(castStateListener);
    }

    public final zze zznm() {
        zzbr.zzcz((String)"Must be called from the main thread.");
        return this.zzarR;
    }

    @Deprecated
    public final void registerLifecycleCallbacksBeforeIceCreamSandwich(@NonNull FragmentActivity fragmentActivity, Bundle bundle) {
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbr.zzcz((String)"Must be called from the main thread.");
        if (zzs.zzrY()) {
            return false;
        }
        CastSession castSession = this.zzarQ.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzarM.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zznn() {
        try {
            return this.zzarP.zzns();
        }
        catch (RemoteException remoteException) {
            zzarM.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzk.class.getSimpleName()});
            return null;
        }
    }
}

