/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzawn;
import com.google.android.gms.internal.zzawo;
import com.google.android.gms.internal.zzaxa;
import com.google.android.gms.internal.zzaxb;
import com.google.android.gms.internal.zzaxc;

public final class zzawz
implements RemoteMediaClient.Listener {
    private final Context zzarO;
    private final CastOptions zzava;
    private final zzawn zzasD;
    private final ComponentName zzavb;
    private final zzawo zzavc;
    private final zzawo zzavd;
    private RemoteMediaClient zzasg;
    private CastDevice zzaoZ;
    private MediaSessionCompat zzave;
    private MediaSessionCompat.Callback zzavf;
    private boolean mIsAttached;

    public zzawz(Context context, CastOptions castOptions, zzawn zzawn2) {
        this.zzarO = context;
        this.zzava = castOptions;
        this.zzasD = zzawn2;
        this.zzavb = this.zzava.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzava.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzarO, this.zzava.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzavc = new zzawo(this.zzarO);
        this.zzavc.zza(new zzaxa(this));
        this.zzavd = new zzawo(this.zzarO);
        this.zzavd.zza(new zzaxb(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mIsAttached || this.zzava == null || this.zzava.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzasg = remoteMediaClient;
        this.zzasg.addListener(this);
        this.zzaoZ = castDevice;
        if (!zzs.zzsd()) {
            ((AudioManager)this.zzarO.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzarO, this.zzava.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzarO, (int)0, (Intent)intent, (int)0);
        this.zzave = new MediaSessionCompat(this.zzarO, "CastMediaSession", componentName, pendingIntent);
        this.zzave.setFlags(3);
        this.zza(0, null);
        if (this.zzaoZ != null && !TextUtils.isEmpty((CharSequence)this.zzaoZ.getFriendlyName())) {
            this.zzave.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzarO.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzaoZ.getFriendlyName()})).build());
        }
        this.zzavf = new zzaxc(this);
        this.zzave.setCallback(this.zzavf);
        this.zzave.setActive(true);
        this.zzasD.setMediaSessionCompat(this.zzave);
        this.mIsAttached = true;
        this.zzoc();
    }

    public final void zzab(int n) {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        if (this.zzasg != null) {
            this.zzasg.removeListener(this);
        }
        if (!zzs.zzsd()) {
            ((AudioManager)this.zzarO.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzasD.setMediaSessionCompat(null);
        if (this.zzavc != null) {
            this.zzavc.clear();
        }
        if (this.zzavd != null) {
            this.zzavd.clear();
        }
        if (this.zzave != null) {
            this.zzave.setSessionActivity(null);
            this.zzave.setCallback(null);
            this.zzave.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzave.setActive(false);
            this.zzave.release();
            this.zzave = null;
        }
        this.zzasg = null;
        this.zzaoZ = null;
        this.zzavf = null;
        this.zzoe();
        if (n == 0) {
            this.zzof();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzoc();
    }

    @Override
    public final void onStatusUpdated() {
        this.zzoc();
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzoc();
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzoc();
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzoc();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    private final void zzoc() {
        Intent intent;
        int n;
        MediaStatus mediaStatus = this.zzasg.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzasg.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl2 = this.zzasg.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl3 = bl = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl2) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzoe();
            this.zzof();
            return;
        }
        zzawz zzawz2 = this;
        if (zzawz2.zzava.getCastMediaOptions().getNotificationOptions() != null && zzawz2.zzasg != null) {
            intent = new Intent(zzawz2.zzarO, MediaNotificationService.class);
            intent.setPackage(zzawz2.zzarO.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzawz2.zzasg.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzawz2.zzasg.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzawz2.zzaoZ);
            zzawz zzawz3 = zzawz2;
            intent.putExtra("extra_media_session_token", zzawz3.zzave == null ? null : zzawz3.zzave.getSessionToken());
            MediaStatus mediaStatus2 = zzawz2.zzasg.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl4 = false;
                boolean bl5 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl4 = true;
                        bl5 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl5 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl4 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl4);
                intent.putExtra("extra_can_skip_prev", bl5);
            }
            zzawz2.zzarO.startService(intent);
        }
        if (!bl) {
            zzawz2 = this;
            if (zzawz2.zzava.getEnableReconnectionService()) {
                intent = new Intent(zzawz2.zzarO, ReconnectionService.class);
                intent.setPackage(zzawz2.zzarO.getPackageName());
                zzawz2.zzarO.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzave.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzave.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        this.zzave.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(512L).build());
        zzawz zzawz2 = this;
        if (zzawz2.zzavb == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzawz2.zzavb);
            pendingIntent = PendingIntent.getActivity((Context)zzawz2.zzarO, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzave.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzawz2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzawz2.zzod().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzawz2.zzave.setMetadata(builder.build());
        Uri uri = zzawz2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzawz2.zzavc.zzm(uri);
        } else {
            zzawz2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzawz2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzawz2.zzavd.zzm(uri2);
            return;
        }
        zzawz2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzave.setMetadata(this.zzod().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzave.setMetadata(this.zzod().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzave.setMetadata(this.zzod().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzava.getCastMediaOptions().getImagePicker() != null ? this.zzava.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzod() {
        MediaMetadataCompat mediaMetadataCompat = this.zzave.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzoe() {
        if (this.zzava.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzarO, MediaNotificationService.class);
        intent.setPackage(this.zzarO.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzarO.stopService(intent);
    }

    private final void zzof() {
        if (!this.zzava.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzarO, ReconnectionService.class);
        intent.setPackage(this.zzarO.getPackageName());
        this.zzarO.stopService(intent);
    }

    static /* synthetic */ void zza(zzawz zzawz2, Bitmap bitmap, int n) {
        zzawz2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzawz zzawz2) {
        return zzawz2.zzasg;
    }
}

