/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawo;
import com.google.android.gms.internal.zzaxj;

public final class zzaxi
extends UIController {
    private final ImageView zzavt;
    private final ImageHints zzauR;
    private final Bitmap zzavx;
    private final View zzavy;
    private final ImagePicker zzatJ;
    private final zzawo zzavv;

    public zzaxi(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzavt = imageView;
        this.zzauR = imageHints;
        this.zzavx = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzavy = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzatJ = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzavv = new zzawo(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzavv.zza(new zzaxj(this));
        this.zzoj();
        this.zzoi();
    }

    @Override
    public final void onSessionEnded() {
        this.zzavv.clear();
        this.zzoj();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzoi();
    }

    private final void zzoi() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzoj();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzaxi zzaxi2 = this;
        if ((mediaInfo == null ? null : (uri = zzaxi2.zzatJ != null && (webImage = zzaxi2.zzatJ.onPickImage(mediaInfo.getMetadata(), zzaxi2.zzauR)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzoj();
            return;
        }
        this.zzavv.zzm(uri);
    }

    private final void zzoj() {
        if (this.zzavy != null) {
            this.zzavy.setVisibility(0);
            this.zzavt.setVisibility(4);
        }
        if (this.zzavx != null) {
            this.zzavt.setImageBitmap(this.zzavx);
        }
    }

    static /* synthetic */ View zza(zzaxi zzaxi2) {
        return zzaxi2.zzavy;
    }

    static /* synthetic */ ImageView zzb(zzaxi zzaxi2) {
        return zzaxi2.zzavt;
    }
}

