/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.safeparcel.zzd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zza {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzeon;
    private final List<String> zzeoo;
    private final boolean zzeop;
    private final LaunchOptions zzekq;
    private final boolean zzeoq;
    private final CastMediaOptions zzeor;
    private final boolean zzeos;
    private final double zzeot;

    CastOptions(String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzeon = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n = list == null ? 0 : list.size();
        this.zzeoo = new ArrayList<String>(n);
        if (n > 0) {
            this.zzeoo.addAll(list);
        }
        this.zzeop = bl;
        this.zzekq = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzeoq = bl2;
        this.zzeor = castMediaOptions;
        this.zzeos = bl3;
        this.zzeot = d;
    }

    public String getReceiverApplicationId() {
        return this.zzeon;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzeoo);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzeop;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzekq;
    }

    public boolean getResumeSavedSession() {
        return this.zzeoq;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzeor;
    }

    public boolean getEnableReconnectionService() {
        return this.zzeos;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzeot;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzd.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzd.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzd.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzd.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzd.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzeon;
        private List<String> zzeoo = new ArrayList<String>();
        private boolean zzeop;
        private LaunchOptions zzekq = new LaunchOptions();
        private boolean zzeoq = true;
        private CastMediaOptions zzeor = new CastMediaOptions.Builder().build();
        private boolean zzeos = true;
        private double zzeot = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string) {
            this.zzeon = string;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzeoo = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzeop = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzekq = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzeoq = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzeor = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzeos = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzeot = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzeon, this.zzeoo, this.zzeop, this.zzekq, this.zzeoq, this.zzeor, this.zzeos, this.zzeot);
        }
    }
}

