/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzaww;

public final class zzawv
extends UIController {
    private final ImageView zzevt;
    private final ImageHints zzeus;
    private final Bitmap zzevu;
    private final ImagePicker zzesd;
    private final zzawd zzevv;

    public zzawv(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzevt = imageView;
        this.zzeus = imageHints;
        this.zzevu = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesd = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzevv = new zzawd(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevv.zza(new zzaww(this));
        this.zzevt.setImageBitmap(this.zzevu);
        this.zzado();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevv.clear();
        this.zzevt.setImageBitmap(this.zzevu);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzado();
    }

    private final void zzado() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevt.setImageBitmap(this.zzevu);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzawv zzawv2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzawv2.zzesd != null && (webImage = zzawv2.zzesd.onPickImage(mediaInfo.getMetadata(), zzawv2.zzeus)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzevt.setImageBitmap(this.zzevu);
            return;
        }
        this.zzevv.zzm(uri);
    }

    static /* synthetic */ ImageView zza(zzawv zzawv2) {
        return zzawv2.zzevt;
    }
}

