/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zzad;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzavk;
import com.google.android.gms.internal.zzavl;
import com.google.android.gms.internal.zzawc;
import com.google.android.gms.internal.zzazp;
import com.google.android.gms.internal.zzbdv;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;

public final class CastContext {
    private static final zzazp zzejb = new zzazp("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzeoe;
    private final Context zzeof;
    private final zzj zzeog;
    private final SessionManager zzeoh;
    private final zze zzeoi;
    private final zzad zzeoj;
    private final MediaNotificationManager zzeok;
    private final CastOptions zzeol;
    private zzawc zzeom;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (zzeoe == null) {
            OptionsProvider optionsProvider = CastContext.zzbn(context.getApplicationContext());
            zzeoe = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzeoe;
    }

    private static OptionsProvider zzbn(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbdv.zzcs((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zzejb.zzc("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        void var7_12;
        this.zzeof = context.getApplicationContext();
        this.zzeol = castOptions;
        this.zzeom = new zzawc(MediaRouter.getInstance((Context)this.zzeof));
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        zzavl zzavl2 = new zzavl(this.zzeof, castOptions, this.zzeom);
        hashMap.put(zzavl2.getCategory(), zzavl2.zzack());
        if (list != null) {
            for (SessionProvider object2 : list) {
                zzbp.zzb((Object)object2, (Object)"Additional SessionProvider must not be null.");
                String string = zzbp.zzh((String)object2.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbp.zzb((!hashMap.containsKey(string) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string));
                hashMap.put(string, object2.zzack());
            }
        }
        this.zzeog = zzavk.zza(this.zzeof, castOptions, this.zzeom, hashMap);
        Object object3 = null;
        try {
            object3 = this.zzeog.zzaby();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzeoi = object3 == null ? null : new zze((zzp)object3);
        Object var7_10 = null;
        try {
            zzv zzv2 = this.zzeog.zzabx();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzeoh = var7_12 == null ? null : new SessionManager((zzv)var7_12);
        this.zzeok = new MediaNotificationManager(this.zzeoh);
        this.zzeoj = this.zzeoh == null ? null : new zzad(this.zzeol, this.zzeoh);
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzeol;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzeoh;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzeog.zzabw());
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzeoh.getCastState();
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        try {
            return this.zzeog.isAppVisible();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzeok;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        zzbp.zzu((Object)appVisibilityListener);
        try {
            this.zzeog.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzeog.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        zzbp.zzu((Object)castStateListener);
        this.zzeoh.addCastStateListener(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zzeoh.removeCastStateListener(castStateListener);
    }

    public final zze zzabs() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        return this.zzeoi;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (com.google.android.gms.common.util.zzp.zzale()) {
            return false;
        }
        CastSession castSession = this.zzeoh.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zzejb.zzc("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    public final IObjectWrapper zzabt() {
        try {
            return this.zzeog.zzabz();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

