/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.RemoteException;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.zzaf;
import com.google.android.gms.cast.framework.zzd;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzazp;

public class SessionManager {
    private static final zzazp zzejb = new zzazp("SessionManager");
    private final zzv zzeps;

    public SessionManager(zzv zzv2) {
        this.zzeps = zzv2;
    }

    public Session getCurrentSession() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        try {
            return (Session)zzn.zzab((IObjectWrapper)this.zzeps.zzacb());
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedCurrentSession", zzv.class.getSimpleName()});
            return null;
        }
    }

    public CastSession getCurrentCastSession() {
        zzbp.zzfx((String)"Must be called from the main thread.");
        Session session = this.getCurrentSession();
        if (session != null && session instanceof CastSession) {
            return (CastSession)session;
        }
        return null;
    }

    public void endCurrentSession(boolean bl) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        try {
            this.zzeps.zzb(true, bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"endCurrentSession", zzv.class.getSimpleName()});
            return;
        }
    }

    public void addSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) throws NullPointerException {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.addSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void addSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class<T> clazz) throws NullPointerException {
        zzbp.zzu(sessionManagerListener);
        zzbp.zzu(clazz);
        zzbp.zzfx((String)"Must be called from the main thread.");
        try {
            this.zzeps.zza(new zzaf<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addSessionManagerListener", zzv.class.getSimpleName()});
            return;
        }
    }

    public void removeSessionManagerListener(SessionManagerListener<Session> sessionManagerListener) {
        zzbp.zzfx((String)"Must be called from the main thread.");
        this.removeSessionManagerListener(sessionManagerListener, Session.class);
    }

    public <T extends Session> void removeSessionManagerListener(SessionManagerListener<T> sessionManagerListener, Class clazz) {
        zzbp.zzu((Object)clazz);
        zzbp.zzfx((String)"Must be called from the main thread.");
        if (sessionManagerListener == null) {
            return;
        }
        try {
            this.zzeps.zzb(new zzaf<T>(sessionManagerListener, clazz));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeSessionManagerListener", zzv.class.getSimpleName()});
            return;
        }
    }

    final int getCastState() {
        try {
            return this.zzeps.getCastState();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzv.class.getSimpleName()});
            return 1;
        }
    }

    final void addCastStateListener(CastStateListener castStateListener) throws NullPointerException {
        zzbp.zzu((Object)castStateListener);
        try {
            this.zzeps.zza(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addCastStateListener", zzv.class.getSimpleName()});
            return;
        }
    }

    final void removeCastStateListener(CastStateListener castStateListener) {
        if (castStateListener == null) {
            return;
        }
        try {
            this.zzeps.zzb(new zzd(castStateListener));
            return;
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"removeCastStateListener", zzv.class.getSimpleName()});
            return;
        }
    }

    public final IObjectWrapper zzabt() {
        try {
            return this.zzeps.zzabz();
        }
        catch (RemoteException remoteException) {
            zzejb.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzv.class.getSimpleName()});
            return null;
        }
    }
}

