/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.InnerZoneDrawable;
import com.google.android.gms.cast.framework.internal.featurehighlight.OuterHighlightDrawable;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzf;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzg;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzh;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzi;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzj;
import com.google.android.gms.internal.zzdew;
import com.google.android.gms.internal.zzdff;
import com.google.android.gms.internal.zzdfm;

public final class zza
extends ViewGroup {
    private final int[] zzeqn = new int[2];
    private final Rect zzeqo = new Rect();
    private final Rect zzeqp = new Rect();
    private final OuterHighlightDrawable zzeqq;
    private final InnerZoneDrawable zzeqr;
    private zzi zzeqs;
    private View targetView;
    @Nullable
    private View zzeqt;
    @Nullable
    private Animator zzequ;
    private final zzj zzeqv;
    private final GestureDetectorCompat zzeqw;
    @Nullable
    private GestureDetectorCompat zzeqx;
    private zzh zzeqy;
    private boolean zzeqz;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.zzeqr = new InnerZoneDrawable(context);
        this.zzeqr.setCallback((Drawable.Callback)this);
        this.zzeqq = new OuterHighlightDrawable(context);
        this.zzeqq.setCallback((Drawable.Callback)this);
        this.zzeqv = new zzj(this);
        zzb zzb2 = new zzb(this);
        this.zzeqw = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)zzb2);
        this.zzeqw.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public final void zza(zzi zzi2) {
        this.zzeqs = (zzi)zzdfm.zzu((Object)zzi2);
        this.addView(zzi2.asView(), 0);
    }

    public final void zza(View view, @Nullable View view2, boolean bl, zzh zzh2) {
        this.targetView = (View)zzdfm.zzu((Object)view);
        this.zzeqt = null;
        this.zzeqy = (zzh)zzdfm.zzu((Object)zzh2);
        zzc zzc2 = new zzc(this, view, true, zzh2);
        this.zzeqx = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)zzc2);
        this.zzeqx.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            View view = this.targetView;
            int[] nArray = this.zzeqn;
            zza zza2 = this;
            zza2.getLocationInWindow(nArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            view.getLocationInWindow(nArray);
            nArray[0] = nArray[0] - n5;
            nArray[1] = nArray[1] - n6;
        }
        this.zzeqo.set(this.zzeqn[0], this.zzeqn[1], this.zzeqn[0] + this.targetView.getWidth(), this.zzeqn[1] + this.targetView.getHeight());
        this.zzeqp.set(n, n2, n3, n4);
        this.zzeqq.setBounds(this.zzeqp);
        this.zzeqr.setBounds(this.zzeqp);
        this.zzeqv.zza(this.zzeqo, this.zzeqp);
    }

    protected final void onDraw(Canvas canvas) {
        canvas.save();
        this.zzeqq.draw(canvas);
        this.zzeqr.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.zzeqq.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.zzeqo.left, (float)this.zzeqo.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public final ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected final ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected final ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected final boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    protected final boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.zzeqq || drawable == this.zzeqr || drawable == null;
    }

    public final void zzd(@Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new zzd(this, null));
    }

    public final void zzacr() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzeqs.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdff.zzbjg());
        float f = zza2.zzeqo.exactCenterX() - zza2.zzeqq.getCenterX();
        float f2 = zza2.zzeqo.exactCenterY() - zza2.zzeqq.getCenterY();
        Animator animator = zza2.zzeqq.zze(f, f2);
        InnerZoneDrawable innerZoneDrawable = zza2.zzeqr;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, 255});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)innerZoneDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdff.zzbjg());
        Animator animator2 = objectAnimator2.setDuration(350L);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zze(zza2));
        this.zza((Animator)animatorSet);
    }

    public final void zze(@Nullable Runnable runnable) {
        float f;
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzeqs.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdff.zzbjh());
        float f2 = zza2.zzeqo.exactCenterX() - zza2.zzeqq.getCenterX();
        float f3 = f = zza2.zzeqo.exactCenterY() - zza2.zzeqq.getCenterY();
        float f4 = f2;
        OuterHighlightDrawable outerHighlightDrawable = zza2.zzeqq;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, f4});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f, f3});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)outerHighlightDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder3, propertyValuesHolder4, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdff.zzbjh());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zzeqr.zzacw();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzg(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zzf(@Nullable Runnable runnable) {
        Runnable runnable2 = runnable;
        zza zza2 = this;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)zza2.zzeqs.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzdff.zzbjh());
        OuterHighlightDrawable outerHighlightDrawable = zza2.zzeqq;
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.125f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)outerHighlightDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator2.setInterpolator((TimeInterpolator)zzdff.zzbjh());
        Animator animator = objectAnimator2.setDuration(200L);
        Animator animator2 = zza2.zzeqr.zzacw();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new zzf(zza2, runnable2));
        this.zza((Animator)animatorSet);
    }

    public final void zzbf(@ColorInt int n) {
        this.zzeqq.setColor(n);
    }

    final View zzacs() {
        return this.zzeqs.asView();
    }

    final OuterHighlightDrawable zzact() {
        return this.zzeqq;
    }

    final InnerZoneDrawable zzacu() {
        return this.zzeqr;
    }

    private final void zza(Animator animator) {
        if (this.zzequ != null) {
            this.zzequ.cancel();
        }
        this.zzequ = animator;
        this.zzequ.start();
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.zzeqz = this.zzeqo.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.zzeqz) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.zzeqx != null) {
                this.zzeqx.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.zzeqw.onTouchEvent(motionEvent);
        }
        return true;
    }

    private final boolean zzc(float f, float f2) {
        return this.zzeqp.contains(Math.round(f), Math.round(f2));
    }

    private final Animator zzacv() {
        InnerZoneDrawable innerZoneDrawable = this.zzeqr;
        AnimatorSet animatorSet = new AnimatorSet();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)innerZoneDrawable), (String)"scale", (float[])new float[]{1.0f, 1.1f}).setDuration(500L);
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)((Object)innerZoneDrawable), (String)"scale", (float[])new float[]{1.1f, 1.0f}).setDuration(500L);
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{1.1f, 2.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)innerZoneDrawable), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2}).setDuration(500L);
        animatorSet.play((Animator)objectAnimator);
        animatorSet.play((Animator)objectAnimator2).with((Animator)objectAnimator3).after((Animator)objectAnimator);
        animatorSet.setInterpolator((TimeInterpolator)zzdff.zzbji());
        animatorSet.setStartDelay(500L);
        zzdew.zza((Animator)animatorSet, -1, null);
        return animatorSet;
    }

    static /* synthetic */ boolean zza(zza zza2, float f, float f2) {
        return zza2.zzc(f, f2);
    }

    static /* synthetic */ OuterHighlightDrawable zza(zza zza2) {
        return zza2.zzeqq;
    }

    static /* synthetic */ zzh zzb(zza zza2) {
        return zza2.zzeqy;
    }

    static /* synthetic */ Animator zza(zza zza2, Animator animator) {
        zza2.zzequ = animator;
        return zza2.zzequ;
    }

    static /* synthetic */ Animator zzc(zza zza2) {
        return zza2.zzacv();
    }

    static /* synthetic */ Animator zzd(zza zza2) {
        return zza2.zzequ;
    }
}

