/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.annotation.TargetApi;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzp;
import java.util.Locale;

public class MediaUtils {
    public static String getImageUrl(MediaInfo mediaInfo, int n) {
        Uri uri = MediaUtils.getImageUri(mediaInfo, n);
        if (uri == null) {
            return null;
        }
        return uri.toString();
    }

    public static Uri getImageUri(MediaInfo mediaInfo, int n) {
        if (mediaInfo == null) {
            return null;
        }
        MediaMetadata mediaMetadata = mediaInfo.getMetadata();
        if (mediaMetadata != null && mediaMetadata.getImages() != null && mediaMetadata.getImages().size() > n) {
            return ((WebImage)mediaMetadata.getImages().get(n)).getUrl();
        }
        return null;
    }

    @TargetApi(value=21)
    public static Locale getTrackLanguage(@NonNull MediaTrack mediaTrack) {
        if (mediaTrack.getLanguage() != null) {
            if (zzp.zzalk()) {
                return Locale.forLanguageTag(mediaTrack.getLanguage());
            }
            String[] stringArray = mediaTrack.getLanguage().split("-");
            if (stringArray.length == 1) {
                return new Locale(stringArray[0]);
            }
            return new Locale(stringArray[0], stringArray[1]);
        }
        return null;
    }

    private MediaUtils() {
    }
}

