/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzayu;
import com.google.android.gms.internal.zzaze;
import com.google.android.gms.internal.zzazy;
import com.google.android.gms.internal.zzazz;
import com.google.android.gms.internal.zzbab;
import com.google.android.gms.internal.zzbac;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object mLock;
    private final Handler mHandler;
    private final zzazy zzemk;
    private final zza zzety;
    private final Cast.CastApi zzeox;
    private GoogleApiClient zzetz;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzeua = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzeub = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzeuc;
    public static final String NAMESPACE = zzazy.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzazy zzazy2, @NonNull Cast.CastApi castApi) {
        this.mLock = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzety = new zza();
        this.zzeox = castApi;
        this.zzemk = (zzazy)zzbp.zzu((Object)zzazy2);
        this.zzemk.zza((zzazz)new zzn(this));
        this.zzemk.zza((zzbab)this.zzety);
    }

    public final void zzc(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzetz == googleApiClient) {
            return;
        }
        if (this.zzetz != null) {
            this.zzemk.zzaee();
            this.zzeox.removeMessageReceivedCallbacks(this.zzetz, this.getNamespace());
            this.zzety.zzb(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzetz = googleApiClient;
        if (this.zzetz != null) {
            this.zzety.zzb(this.zzetz);
        }
    }

    public final void zzadd() throws IOException {
        if (this.zzetz != null) {
            this.zzeox.setMessageReceivedCallbacks(this.zzetz, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzy(this, this.zzetz, mediaInfo, bl, l, lArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzae(this, this.zzetz, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzaf(this, this.zzetz, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzag(this, this.zzetz, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzah(this, this.zzetz, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzai(this, this.zzetz, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzaj(this, this.zzetz, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzak(this, this.zzetz));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzo(this, this.zzetz, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzp(this, this.zzetz, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzq(this, this.zzetz, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzr(this, this.zzetz, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzs(this, this.zzetz, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzt(this, this.zzetz, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzu(this, this.zzetz, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzv(this, this.zzetz, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzw(this, this.zzetz, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzx(this, this.zzetz, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzz(this, this.zzetz, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzaa(this, this.zzetz, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzab(this, this.zzetz, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzac(this, this.zzetz, n, n2, jSONObject));
    }

    public final PendingResult<MediaChannelResult> zzfd(@NonNull String string2) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzade();
        return this.zza(new zzad(this, this.zzetz, true, string2));
    }

    private final int zzbb(int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            return this.zzemk.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            return this.zzemk.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            return this.zzemk.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            return this.zzemk.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.mLock;
        synchronized (object) {
            zzbp.zzfy((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzeua.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzeub.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzeub.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzeua.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzeua.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zzadi()) {
                this.zzeub.remove(zzd2.zzadh());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzeuc = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzemk.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzemk.zzff(string3);
    }

    private final void zzade() throws IllegalStateException {
        if (this.zzetz == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzetz.zze((zzm)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.setResult((MediaChannelResult)zzb2.zzb(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zzadf() {
        for (zzd zzd2 : this.zzeub.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzeuj);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zzadf();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzeuc;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.mLock;
    }

    static /* synthetic */ zzazy zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzemk;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zzbb(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zzd {
        private final Set<ProgressListener> zzeuj = new HashSet<ProgressListener>();
        private final long zzeuk;
        private final Runnable zzeul;
        private boolean zzeum;

        public zzd(long l) {
            this.zzeuk = l;
            this.zzeul = new zzao(this, RemoteMediaClient.this);
        }

        public final long zzadh() {
            return this.zzeuk;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzeuj.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzeuj.remove(progressListener);
        }

        public final boolean zzadi() {
            return !this.zzeuj.isEmpty();
        }

        public final void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzeul);
            this.zzeum = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzeul, this.zzeuk);
        }

        public final void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzeul);
            this.zzeum = false;
        }

        public final boolean isStarted() {
            return this.zzeum;
        }

        static /* synthetic */ long zzb(zzd zzd2) {
            return zzd2.zzeuk;
        }
    }

    abstract class zzb
    extends zzayu<MediaChannelResult> {
        zzbac zzenr;
        private final boolean zzeug;
        private /* synthetic */ RemoteMediaClient zzeud;

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient) {
            this(remoteMediaClient, googleApiClient, false);
        }

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient, boolean bl) {
            this.zzeud = remoteMediaClient;
            super(googleApiClient);
            this.zzeug = bl;
            this.zzenr = new zzam(this, remoteMediaClient);
        }

        abstract void zzb(zzaze var1);

        protected final /* synthetic */ void zza(Api.zzb zzb2) throws RemoteException {
            zzaze zzaze2 = (zzaze)zzb2;
            zzb zzb3 = this;
            if (!zzb3.zzeug) {
                Iterator iterator = zzb3.zzeud.mListeners.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onSendingRemoteMediaRequest();
                }
            }
            zzb3.zzb(zzaze2);
        }

        public final /* synthetic */ Result zzb(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzan(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status mStatus;
        private final JSONObject zzeho;

        zzc(Status status, JSONObject jSONObject) {
            this.mStatus = status;
            this.zzeho = jSONObject;
        }

        public final Status getStatus() {
            return this.mStatus;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzeho;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzbab {
        private GoogleApiClient zzenn;
        private long zzeno = 0L;

        public final void zzb(GoogleApiClient googleApiClient) {
            this.zzenn = googleApiClient;
        }

        public final long zzabr() {
            return ++this.zzeno;
        }

        public final void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzenn == null) {
                throw new IOException("No GoogleApiClient available");
            }
            RemoteMediaClient.this.zzeox.sendMessage(this.zzenn, string2, string3).setResultCallback((ResultCallback)new zzal(this, l));
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

