/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.uicontroller;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.cast.framework.media.uicontroller.zza;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzawu;
import com.google.android.gms.internal.zzaww;
import com.google.android.gms.internal.zzawy;
import com.google.android.gms.internal.zzaxa;
import com.google.android.gms.internal.zzaxe;
import com.google.android.gms.internal.zzaxf;
import com.google.android.gms.internal.zzaxg;
import com.google.android.gms.internal.zzaxh;
import com.google.android.gms.internal.zzaxk;
import com.google.android.gms.internal.zzaxm;
import com.google.android.gms.internal.zzaxn;
import com.google.android.gms.internal.zzaxp;
import com.google.android.gms.internal.zzaxr;
import com.google.android.gms.internal.zzaxt;
import com.google.android.gms.internal.zzaxv;
import com.google.android.gms.internal.zzaxw;
import com.google.android.gms.internal.zzaxx;
import com.google.android.gms.internal.zzaxy;
import com.google.android.gms.internal.zzaxz;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIMediaController
implements SessionManagerListener<CastSession>,
RemoteMediaClient.Listener {
    private final Activity mActivity;
    private final SessionManager zzeoi;
    private final Map<View, List<UIController>> zzevp = new HashMap<View, List<UIController>>();
    private final Set<zzaxx> zzevq = new HashSet<zzaxx>();
    private RemoteMediaClient.Listener zzevr;
    private RemoteMediaClient zzepb;

    public UIMediaController(Activity activity) {
        this.mActivity = activity;
        this.zzeoi = CastContext.getSharedInstance((Context)activity).getSessionManager();
        this.zzeoi.addSessionManagerListener(this, CastSession.class);
        this.zza(this.zzeoi.getCurrentCastSession());
    }

    public boolean isActive() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepb != null;
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        return this.zzepb;
    }

    public void setPostRemoteMediaClientListener(RemoteMediaClient.Listener listener) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzevr = listener;
    }

    public void dispose() {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zzadn();
        this.zzevp.clear();
        this.zzeoi.removeSessionManagerListener(this, CastSession.class);
        this.zzevr = null;
    }

    public void bindImageViewToPlayPauseToggle(@NonNull ImageView imageView, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxk(imageView, (Context)this.mActivity, drawable2, drawable3, drawable4, view, bl));
    }

    public void bindViewToSkipNext(View view, int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxr(view, n));
    }

    public void bindViewToSkipPrev(View view, int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxt(view, n));
    }

    public void bindViewToForward(View view, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxp(view, l));
    }

    public void bindViewToRewind(View view, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.bindViewToForward(view, -l);
    }

    public void bindViewToLoadingIndicator(View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxe(view));
    }

    public void bindProgressBar(ProgressBar progressBar) {
        this.bindProgressBar(progressBar, 1000L);
    }

    public void bindProgressBar(ProgressBar progressBar, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)progressBar, new zzaxm(progressBar, l));
    }

    public void bindSeekBar(SeekBar seekBar) {
        this.bindSeekBar(seekBar, 1000L);
    }

    public void bindSeekBar(SeekBar seekBar, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        zza zza2 = new zza(this);
        this.zza((View)seekBar, new zzaxn(seekBar, l, zza2));
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl) {
        this.bindTextViewToStreamPosition(textView, bl, 1000L);
    }

    public void bindTextViewToStreamPosition(TextView textView, boolean bl, long l) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        zzaxx zzaxx2 = new zzaxx(textView, l, this.mActivity.getString(R.string.cast_invalid_stream_position_text));
        if (bl) {
            this.zzevq.add(zzaxx2);
        }
        this.zza((View)textView, zzaxx2);
    }

    public void bindTextViewToStreamDuration(TextView textView) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxw(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), null));
    }

    public void bindTextViewToStreamDuration(TextView textView, View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxw(textView, this.mActivity.getString(R.string.cast_invalid_stream_duration_text), view));
    }

    public void bindViewToLaunchExpandedController(View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxa(view, this.mActivity));
    }

    public void bindViewToClosedCaption(View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzawu(view, this.mActivity));
    }

    public void bindImageViewToMuteToggle(ImageView imageView) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaxh(imageView, (Context)this.mActivity));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, String string2) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfCurrentItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfCurrentItem(TextView textView, List<String> list) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxg(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawy(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2, null));
    }

    @Deprecated
    public void bindImageViewToImageOfCurrentItem(ImageView imageView, int n, View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawy(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), 0, view));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawy(imageView, (Context)this.mActivity, imageHints, n, null));
    }

    public void bindImageViewToImageOfCurrentItem(ImageView imageView, @NonNull ImageHints imageHints, View view) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzawy(imageView, (Context)this.mActivity, imageHints, 0, view));
    }

    public void bindViewVisibilityToMediaSession(View view, int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxz(view, n));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, String string2) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.bindTextViewToMetadataOfPreloadedItem(textView, Collections.singletonList(string2));
    }

    public void bindTextViewToMetadataOfPreloadedItem(TextView textView, List<String> list) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxf(textView, list));
    }

    @Deprecated
    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, int n, @DrawableRes int n2) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaww(imageView, (Context)this.mActivity, new ImageHints(n, 0, 0), n2));
    }

    public void bindImageViewToImageOfPreloadedItem(ImageView imageView, @NonNull ImageHints imageHints, @DrawableRes int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)imageView, new zzaww(imageView, (Context)this.mActivity, imageHints, n));
    }

    public void bindViewVisibilityToPreloadingEvent(View view, int n) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, new zzaxy(view, n));
    }

    public void bindViewToUIController(View view, UIController uIController) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza(view, uIController);
    }

    public void bindTextViewToSmartSubtitle(TextView textView) {
        zzbp.zzfy((String)"Must be called from the main thread.");
        this.zza((View)textView, new zzaxv(textView));
    }

    @Override
    public void onSessionStarting(CastSession castSession) {
    }

    @Override
    public void onSessionStarted(CastSession castSession, String string2) {
        this.zza(castSession);
    }

    @Override
    public void onSessionResuming(CastSession castSession, String string2) {
    }

    @Override
    public void onSessionResumed(CastSession castSession, boolean bl) {
        this.zza(castSession);
    }

    @Override
    public void onSessionStartFailed(CastSession castSession, int n) {
        this.zzadn();
    }

    @Override
    public void onSessionEnding(CastSession castSession) {
    }

    @Override
    public void onSessionEnded(CastSession castSession, int n) {
        this.zzadn();
    }

    @Override
    public void onSessionResumeFailed(CastSession castSession, int n) {
        this.zzadn();
    }

    @Override
    public void onSessionSuspended(CastSession castSession, int n) {
    }

    @Override
    public void onStatusUpdated() {
        this.zzado();
        if (this.zzevr != null) {
            this.zzevr.onStatusUpdated();
        }
    }

    @Override
    public void onMetadataUpdated() {
        this.zzado();
        if (this.zzevr != null) {
            this.zzevr.onMetadataUpdated();
        }
    }

    @Override
    public void onQueueStatusUpdated() {
        this.zzado();
        if (this.zzevr != null) {
            this.zzevr.onQueueStatusUpdated();
        }
    }

    @Override
    public void onPreloadStatusUpdated() {
        this.zzado();
        if (this.zzevr != null) {
            this.zzevr.onPreloadStatusUpdated();
        }
    }

    @Override
    public void onAdBreakStatusUpdated() {
        this.zzado();
        if (this.zzevr != null) {
            this.zzevr.onAdBreakStatusUpdated();
        }
    }

    @Override
    public void onSendingRemoteMediaRequest() {
        Iterator<List<UIController>> iterator = this.zzevp.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSendingRemoteMediaRequest();
            }
        }
        if (this.zzevr != null) {
            this.zzevr.onSendingRemoteMediaRequest();
        }
    }

    private final void zza(Session session) {
        if (this.isActive() || !(session instanceof CastSession) || !session.isConnected()) {
            return;
        }
        CastSession castSession = (CastSession)session;
        this.zzepb = castSession.getRemoteMediaClient();
        if (this.zzepb != null) {
            this.zzepb.addListener(this);
            Iterator<List<UIController>> iterator = this.zzevp.values().iterator();
            while (iterator.hasNext()) {
                Iterator<UIController> iterator2 = iterator.next().iterator();
                while (iterator2.hasNext()) {
                    iterator2.next().onSessionConnected(castSession);
                }
            }
            this.zzado();
        }
    }

    private final void zzadn() {
        if (!this.isActive()) {
            return;
        }
        Iterator<List<UIController>> iterator = this.zzevp.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onSessionEnded();
            }
        }
        this.zzepb.removeListener(this);
        this.zzepb = null;
    }

    private final void zza(View view, UIController uIController) {
        List<UIController> list = this.zzevp.get(view);
        if (list == null) {
            list = new ArrayList<UIController>();
            this.zzevp.put(view, list);
        }
        list.add(uIController);
        if (this.isActive()) {
            uIController.onSessionConnected(this.zzeoi.getCurrentCastSession());
            this.zzado();
        }
    }

    private final void zzado() {
        Iterator<List<UIController>> iterator = this.zzevp.values().iterator();
        while (iterator.hasNext()) {
            Iterator<UIController> iterator2 = iterator.next().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().onMediaStatusUpdated();
            }
        }
    }

    static /* synthetic */ Set zza(UIMediaController uIMediaController) {
        return uIMediaController.zzevq;
    }
}

