/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzazx;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzazx zzejc = new zzazx("MiniControllerFragment");
    private boolean zzeyn;
    private int zzeyo;
    private int zzeyp;
    private TextView zzeyq;
    private int zzeyr;
    private int zzeys;
    private int zzexy;
    private int[] zzeyd;
    private ImageView[] zzeye = new ImageView[3];
    private int zzeyt;
    @DrawableRes
    private int zzexp;
    @DrawableRes
    private int zzexq;
    @DrawableRes
    private int zzexr;
    @DrawableRes
    private int zzeyu;
    @DrawableRes
    private int zzeyv;
    @DrawableRes
    private int zzeyw;
    @DrawableRes
    private int zzexs;
    @DrawableRes
    private int zzext;
    @DrawableRes
    private int zzexu;
    @DrawableRes
    private int zzexv;
    @DrawableRes
    private int zzexw;
    @DrawableRes
    private int zzexx;
    private UIMediaController zzeyk;

    public MiniControllerFragment() {
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        MiniControllerFragment miniControllerFragment = this;
        if (miniControllerFragment.zzeyd == null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attributeSet2, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            miniControllerFragment.zzeyn = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            miniControllerFragment.zzeyo = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            miniControllerFragment.zzeyp = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            miniControllerFragment.zzeyr = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            miniControllerFragment.zzeys = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            miniControllerFragment.zzexy = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            miniControllerFragment.zzexp = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzexq = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzexr = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzeyu = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzeyv = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzeyw = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzexs = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            miniControllerFragment.zzext = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            miniControllerFragment.zzexu = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            miniControllerFragment.zzexv = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            miniControllerFragment.zzexw = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            miniControllerFragment.zzexx = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = context2.getResources().obtainTypedArray(n);
                zzbp.zzbh((typedArray2.length() == 3 ? 1 : 0) != 0);
                miniControllerFragment.zzeyd = new int[typedArray2.length()];
                for (int i = 0; i < typedArray2.length(); ++i) {
                    miniControllerFragment.zzeyd[i] = typedArray2.getResourceId(i, 0);
                }
                typedArray2.recycle();
                if (miniControllerFragment.zzeyn) {
                    miniControllerFragment.zzeyd[0] = R.id.cast_button_type_empty;
                }
                miniControllerFragment.zzeyt = 0;
                int[] nArray = miniControllerFragment.zzeyd;
                int n2 = miniControllerFragment.zzeyd.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == R.id.cast_button_type_empty) continue;
                    ++miniControllerFragment.zzeyt;
                }
            } else {
                zzejc.zzf("Unable to read attribute castControlButtons.", new Object[0]);
                miniControllerFragment.zzeyd = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzeyk = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzeyk.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzeyr != 0) {
            relativeLayout.setBackgroundResource(this.zzeyr);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzeyo != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzeyo);
        }
        this.zzeyq = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzeyp != 0) {
            this.zzeyq.setTextAppearance((Context)this.getActivity(), this.zzeyp);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzeys != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzeys, PorterDuff.Mode.SRC_IN);
        }
        this.zzeyk.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzeyk.bindTextViewToSmartSubtitle(this.zzeyq);
        this.zzeyk.bindProgressBar(progressBar);
        this.zzeyk.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzeyn) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzeyk.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzeye[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzeye[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzeye[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzeyk != null) {
            this.zzeyk.dispose();
            this.zzeyk = null;
        }
        super.onDestroy();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzeyd[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzeye[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzeyk;
    }

    private final void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzeyd[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzexp;
                int n5 = this.zzexq;
                int n6 = this.zzexr;
                if (this.zzeyt == 1) {
                    n4 = this.zzeyu;
                    n5 = this.zzeyv;
                    n6 = this.zzeyw;
                }
                Drawable drawable2 = zzb.zza(this.getContext(), this.zzexy, n4);
                Drawable drawable3 = zzb.zza(this.getContext(), this.zzexy, n5);
                Drawable drawable4 = zzb.zza(this.getContext(), this.zzexy, n6);
                imageView.setImageDrawable(drawable3);
                int n7 = n;
                MiniControllerFragment miniControllerFragment = this;
                ProgressBar progressBar = new ProgressBar(miniControllerFragment.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(8, n7);
                layoutParams.addRule(6, n7);
                layoutParams.addRule(5, n7);
                layoutParams.addRule(7, n7);
                layoutParams.addRule(15);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                progressBar.setVisibility(8);
                Drawable drawable5 = progressBar.getIndeterminateDrawable();
                if (miniControllerFragment.zzeys != 0 && drawable5 != null) {
                    drawable5.setColorFilter(miniControllerFragment.zzeys, PorterDuff.Mode.SRC_IN);
                }
                ProgressBar progressBar2 = progressBar;
                relativeLayout.addView((View)progressBar2);
                this.zzeyk.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar2, true);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzexs));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzeyk.bindViewToSkipPrev((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzext));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzeyk.bindViewToSkipNext((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzexu));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzeyk.bindViewToRewind((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzexv));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzeyk.bindViewToForward((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzexw));
                this.zzeyk.bindImageViewToMuteToggle(imageView);
                return;
            }
            if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzexy, this.zzexx));
                this.zzeyk.bindViewToClosedCaption((View)imageView);
            }
        }
    }
}

