/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawx;

public final class zzaww
extends UIController {
    private final ImageView zzevx;
    private final ImageHints zzeuw;
    private final Bitmap zzevy;
    private final ImagePicker zzesf;
    private final zzawe zzevz;

    public zzaww(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzevx = imageView;
        this.zzeuw = imageHints;
        this.zzevy = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzesf = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzevz = new zzawe(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevz.zza(new zzawx(this));
        this.zzevx.setImageBitmap(this.zzevy);
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevz.clear();
        this.zzevx.setImageBitmap(this.zzevy);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    private final void zzadp() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevx.setImageBitmap(this.zzevy);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzaww zzaww2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzaww2.zzesf != null && (webImage = zzaww2.zzesf.onPickImage(mediaInfo.getMetadata(), zzaww2.zzeuw)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzevx.setImageBitmap(this.zzevy);
            return;
        }
        this.zzevz.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzaww zzaww2) {
        return zzaww2.zzevx;
    }
}

