/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzaxl;

public final class zzaxk
extends UIController {
    private final ImageView zzevx;
    private final View zzewm;
    private final boolean zzewn;
    private final Drawable zzewo;
    private final String zzewp;
    private final Drawable zzewq;
    private final String zzewr;
    private final Drawable zzews;
    private final String zzewt;
    private final View.OnClickListener zzevv;

    public zzaxk(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzevx = imageView;
        this.zzewo = drawable2;
        this.zzewq = drawable3;
        this.zzews = drawable4 != null ? drawable4 : drawable3;
        this.zzewp = context.getString(R.string.cast_play);
        this.zzewr = context.getString(R.string.cast_pause);
        this.zzewt = context.getString(R.string.cast_stop);
        this.zzewm = view;
        this.zzewn = bl;
        this.zzevv = new zzaxl(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevx.setOnClickListener(this.zzevv);
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevx.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzaz(true);
    }

    private final void zzadp() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevx.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzewo, this.zzewp);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzews, this.zzewt);
                return;
            }
            this.zza(this.zzewq, this.zzewr);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzaz(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzaz(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzevx.setImageDrawable(drawable2);
        this.zzevx.setContentDescription((CharSequence)string2);
        this.zzevx.setVisibility(0);
        this.zzevx.setEnabled(true);
        if (this.zzewm != null) {
            this.zzewm.setVisibility(8);
        }
    }

    private final void zzaz(boolean bl) {
        if (this.zzewm != null) {
            this.zzewm.setVisibility(0);
        }
        this.zzevx.setVisibility(this.zzewn ? 4 : 0);
        this.zzevx.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzaxk zzaxk2) {
        return zzaxk2.getRemoteMediaClient();
    }
}

