/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbck {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzeop;
    private final List<String> zzeoq;
    private final boolean zzeor;
    private final LaunchOptions zzeks;
    private final boolean zzeos;
    private final CastMediaOptions zzeot;
    private final boolean zzeou;
    private final double zzeov;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzeop = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzeoq = new ArrayList<String>(n);
        if (n > 0) {
            this.zzeoq.addAll(list);
        }
        this.zzeor = bl;
        this.zzeks = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzeos = bl2;
        this.zzeot = castMediaOptions;
        this.zzeou = bl3;
        this.zzeov = d;
    }

    public String getReceiverApplicationId() {
        return this.zzeop;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzeoq);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzeor;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzeks;
    }

    public boolean getResumeSavedSession() {
        return this.zzeos;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzeot;
    }

    public boolean getEnableReconnectionService() {
        return this.zzeou;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzeov;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbcn.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbcn.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbcn.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbcn.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzeop;
        private List<String> zzeoq = new ArrayList<String>();
        private boolean zzeor;
        private LaunchOptions zzeks = new LaunchOptions();
        private boolean zzeos = true;
        private CastMediaOptions zzeot = new CastMediaOptions.Builder().build();
        private boolean zzeou = true;
        private double zzeov = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzeop = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzeoq = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzeor = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzeks = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzeos = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzeot = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzeou = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzeov = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzeop, this.zzeoq, this.zzeor, this.zzeks, this.zzeos, this.zzeot, this.zzeou, this.zzeov);
        }
    }
}

