/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Parcelable;
import android.support.v4.media.MediaMetadataCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.ReconnectionService;
import com.google.android.gms.cast.framework.media.MediaNotificationService;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzawd;
import com.google.android.gms.internal.zzawe;
import com.google.android.gms.internal.zzawq;
import com.google.android.gms.internal.zzawr;
import com.google.android.gms.internal.zzaws;

public final class zzawp
implements RemoteMediaClient.Listener {
    private final Context zzeoh;
    private final CastOptions zzevg;
    private final zzawd zzeqa;
    private final ComponentName zzevh;
    private final zzawe zzevi;
    private final zzawe zzevj;
    private RemoteMediaClient zzepc;
    private CastDevice zzeij;
    private MediaSessionCompat zzevk;
    private MediaSessionCompat.Callback zzevl;
    private boolean mIsAttached;

    public zzawp(Context context, CastOptions castOptions, zzawd zzawd2) {
        this.zzeoh = context;
        this.zzevg = castOptions;
        this.zzeqa = zzawd2;
        this.zzevh = this.zzevg.getCastMediaOptions() != null && !TextUtils.isEmpty((CharSequence)this.zzevg.getCastMediaOptions().getExpandedControllerActivityClassName()) ? new ComponentName(this.zzeoh, this.zzevg.getCastMediaOptions().getExpandedControllerActivityClassName()) : null;
        this.zzevi = new zzawe(this.zzeoh);
        this.zzevi.zza(new zzawq(this));
        this.zzevj = new zzawe(this.zzeoh);
        this.zzevj.zza(new zzawr(this));
    }

    public final void zza(RemoteMediaClient remoteMediaClient, CastDevice castDevice) {
        if (this.mIsAttached || this.zzevg == null || this.zzevg.getCastMediaOptions() == null || remoteMediaClient == null || castDevice == null) {
            return;
        }
        this.zzepc = remoteMediaClient;
        this.zzepc.addListener(this);
        this.zzeij = castDevice;
        if (!zzq.zzalj()) {
            ((AudioManager)this.zzeoh.getSystemService("audio")).requestAudioFocus(null, 3, 3);
        }
        ComponentName componentName = new ComponentName(this.zzeoh, this.zzevg.getCastMediaOptions().getMediaIntentReceiverClassName());
        Intent intent = new Intent("android.intent.action.MEDIA_BUTTON");
        intent.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.zzeoh, (int)0, (Intent)intent, (int)0);
        this.zzevk = new MediaSessionCompat(this.zzeoh, "CastMediaSession", componentName, pendingIntent);
        this.zzevk.setFlags(3);
        this.zza(0, null);
        if (this.zzeij != null && !TextUtils.isEmpty((CharSequence)this.zzeij.getFriendlyName())) {
            this.zzevk.setMetadata(new MediaMetadataCompat.Builder().putString("android.media.metadata.ALBUM_ARTIST", this.zzeoh.getResources().getString(R.string.cast_casting_to_device, new Object[]{this.zzeij.getFriendlyName()})).build());
        }
        this.zzevl = new zzaws(this);
        this.zzevk.setCallback(this.zzevl);
        this.zzevk.setActive(true);
        this.zzeqa.setMediaSessionCompat(this.zzevk);
        this.mIsAttached = true;
        this.zzax(false);
    }

    public final void zzbg(int n) {
        if (!this.mIsAttached) {
            return;
        }
        this.mIsAttached = false;
        if (this.zzepc != null) {
            this.zzepc.removeListener(this);
        }
        if (!zzq.zzalj()) {
            ((AudioManager)this.zzeoh.getSystemService("audio")).abandonAudioFocus(null);
        }
        this.zzeqa.setMediaSessionCompat(null);
        if (this.zzevi != null) {
            this.zzevi.clear();
        }
        if (this.zzevj != null) {
            this.zzevj.clear();
        }
        if (this.zzevk != null) {
            this.zzevk.setSessionActivity(null);
            this.zzevk.setCallback(null);
            this.zzevk.setMetadata(new MediaMetadataCompat.Builder().build());
            this.zza(0, null);
            this.zzevk.setActive(false);
            this.zzevk.release();
            this.zzevk = null;
        }
        this.zzepc = null;
        this.zzeij = null;
        this.zzevl = null;
        this.zzadl();
        if (n == 0) {
            this.zzadm();
        }
    }

    @Override
    public final void onQueueStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onMetadataUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onPreloadStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onAdBreakStatusUpdated() {
        this.zzax(false);
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
    }

    public final void zzax(boolean bl) {
        int n;
        if (this.zzepc == null) {
            return;
        }
        MediaStatus mediaStatus = this.zzepc.getMediaStatus();
        MediaInfo mediaInfo = mediaStatus == null ? null : mediaStatus.getMediaInfo();
        MediaMetadata mediaMetadata = mediaInfo == null ? null : mediaInfo.getMetadata();
        boolean bl2 = false;
        if (mediaStatus == null || mediaInfo == null || mediaMetadata == null) {
            n = 0;
        } else {
            switch (this.zzepc.getPlayerState()) {
                case 4: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: {
                    int n2 = mediaStatus.getIdleReason();
                    boolean bl3 = this.zzepc.isLiveStream() && n2 == 2;
                    int n3 = mediaStatus.getLoadingItemId();
                    boolean bl4 = bl2 = n3 != 0 && (n2 == 1 || n2 == 3);
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    MediaQueueItem mediaQueueItem = mediaStatus.getQueueItemById(n3);
                    if (mediaQueueItem != null) {
                        mediaInfo = mediaQueueItem.getMedia();
                        n = 6;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        this.zza(n, mediaInfo);
        if (n == 0) {
            this.zzadl();
            this.zzadm();
            return;
        }
        boolean bl5 = bl;
        zzawp zzawp2 = this;
        if (zzawp2.zzevg.getCastMediaOptions().getNotificationOptions() != null && zzawp2.zzepc != null) {
            Intent intent = new Intent(zzawp2.zzeoh, MediaNotificationService.class);
            intent.putExtra("extra_media_notification_force_update", bl5);
            intent.setPackage(zzawp2.zzeoh.getPackageName());
            intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
            intent.putExtra("extra_media_info", (Parcelable)zzawp2.zzepc.getMediaInfo());
            intent.putExtra("extra_remote_media_client_player_state", zzawp2.zzepc.getPlayerState());
            intent.putExtra("extra_cast_device", (Parcelable)zzawp2.zzeij);
            zzawp zzawp3 = zzawp2;
            intent.putExtra("extra_media_session_token", zzawp3.zzevk == null ? null : zzawp3.zzevk.getSessionToken());
            MediaStatus mediaStatus2 = zzawp2.zzepc.getMediaStatus();
            if (mediaStatus2 != null) {
                boolean bl6 = false;
                boolean bl7 = false;
                switch (mediaStatus2.getQueueRepeatMode()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl6 = true;
                        bl7 = true;
                        break;
                    }
                    default: {
                        Integer n4 = mediaStatus2.getIndexById(mediaStatus2.getCurrentItemId());
                        if (n4 == null) break;
                        if (n4 > 0) {
                            bl7 = true;
                        }
                        if (n4 >= mediaStatus2.getQueueItemCount() - 1) break;
                        bl6 = true;
                    }
                }
                intent.putExtra("extra_can_skip_next", bl6);
                intent.putExtra("extra_can_skip_prev", bl7);
            }
            zzawp2.zzeoh.startService(intent);
        }
        if (!bl2) {
            zzawp2 = this;
            if (zzawp2.zzevg.getEnableReconnectionService()) {
                Intent intent = new Intent(zzawp2.zzeoh, ReconnectionService.class);
                intent.setPackage(zzawp2.zzeoh.getPackageName());
                zzawp2.zzeoh.startService(intent);
            }
        }
    }

    private final void zza(int n, MediaInfo mediaInfo) {
        Intent intent;
        PendingIntent pendingIntent;
        if (n == 0) {
            this.zzevk.setPlaybackState(new PlaybackStateCompat.Builder().setState(0, 0L, 1.0f).build());
            this.zzevk.setMetadata(new MediaMetadataCompat.Builder().build());
            return;
        }
        long l = mediaInfo.getStreamType() == 2 ? 5L : 512L;
        this.zzevk.setPlaybackState(new PlaybackStateCompat.Builder().setState(n, 0L, 1.0f).setActions(l).build());
        zzawp zzawp2 = this;
        if (zzawp2.zzevh == null) {
            pendingIntent = null;
        } else {
            intent = new Intent();
            intent.setComponent(zzawp2.zzevh);
            pendingIntent = PendingIntent.getActivity((Context)zzawp2.zzeoh, (int)0, (Intent)intent, (int)0x8000000);
        }
        this.zzevk.setSessionActivity(pendingIntent);
        intent = mediaInfo;
        zzawp2 = this;
        MediaMetadata mediaMetadata = intent.getMetadata();
        MediaMetadataCompat.Builder builder = zzawp2.zzadk().putString("android.media.metadata.TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_TITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE")).putString("android.media.metadata.DISPLAY_SUBTITLE", mediaMetadata.getString("com.google.android.gms.cast.metadata.SUBTITLE")).putLong("android.media.metadata.DURATION", intent.getStreamDuration());
        zzawp2.zzevk.setMetadata(builder.build());
        Uri uri = zzawp2.zza(mediaMetadata, 0);
        if (uri != null) {
            zzawp2.zzevi.zzl(uri);
        } else {
            zzawp2.zza((Bitmap)null, 0);
        }
        Uri uri2 = zzawp2.zza(mediaMetadata, 3);
        if (uri2 != null) {
            zzawp2.zzevj.zzl(uri2);
            return;
        }
        zzawp2.zza((Bitmap)null, 3);
    }

    private final void zza(Bitmap bitmap, int n) {
        if (n == 0) {
            if (bitmap != null) {
                this.zzevk.setMetadata(this.zzadk().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap).build());
                return;
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap2.eraseColor(0);
            this.zzevk.setMetadata(this.zzadk().putBitmap("android.media.metadata.DISPLAY_ICON", bitmap2).build());
            return;
        }
        if (n == 3) {
            this.zzevk.setMetadata(this.zzadk().putBitmap("android.media.metadata.ALBUM_ART", bitmap).build());
        }
    }

    private final Uri zza(MediaMetadata mediaMetadata, int n) {
        WebImage webImage;
        if ((this.zzevg.getCastMediaOptions().getImagePicker() != null ? this.zzevg.getCastMediaOptions().getImagePicker().onPickImage(mediaMetadata, n) : (webImage = mediaMetadata.hasImages() ? (WebImage)mediaMetadata.getImages().get(0) : null)) == null) {
            return null;
        }
        return webImage.getUrl();
    }

    private final MediaMetadataCompat.Builder zzadk() {
        MediaMetadataCompat mediaMetadataCompat = this.zzevk.getController().getMetadata();
        if (mediaMetadataCompat == null) {
            return new MediaMetadataCompat.Builder();
        }
        return new MediaMetadataCompat.Builder(mediaMetadataCompat);
    }

    private final void zzadl() {
        if (this.zzevg.getCastMediaOptions().getNotificationOptions() == null) {
            return;
        }
        Intent intent = new Intent(this.zzeoh, MediaNotificationService.class);
        intent.setPackage(this.zzeoh.getPackageName());
        intent.setAction("com.google.android.gms.cast.framework.action.UPDATE_NOTIFICATION");
        this.zzeoh.stopService(intent);
    }

    private final void zzadm() {
        if (!this.zzevg.getEnableReconnectionService()) {
            return;
        }
        Intent intent = new Intent(this.zzeoh, ReconnectionService.class);
        intent.setPackage(this.zzeoh.getPackageName());
        this.zzeoh.stopService(intent);
    }

    static /* synthetic */ void zza(zzawp zzawp2, Bitmap bitmap, int n) {
        zzawp2.zza(bitmap, n);
    }

    static /* synthetic */ RemoteMediaClient zza(zzawp zzawp2) {
        return zzawp2.zzepc;
    }
}

