/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.internal.zzaxl;

public final class zzaxk
extends UIController {
    private final ImageView zzevy;
    private final View zzewn;
    private final boolean zzewo;
    private final Drawable zzewp;
    private final String zzewq;
    private final Drawable zzewr;
    private final String zzews;
    private final Drawable zzewt;
    private final String zzewu;
    private final View.OnClickListener zzevw;

    public zzaxk(@NonNull ImageView imageView, Context context, @NonNull Drawable drawable2, @NonNull Drawable drawable3, Drawable drawable4, View view, boolean bl) {
        this.zzevy = imageView;
        this.zzewp = drawable2;
        this.zzewr = drawable3;
        this.zzewt = drawable4 != null ? drawable4 : drawable3;
        this.zzewq = context.getString(R.string.cast_play);
        this.zzews = context.getString(R.string.cast_pause);
        this.zzewu = context.getString(R.string.cast_stop);
        this.zzewn = view;
        this.zzewo = bl;
        this.zzevw = new zzaxl(this);
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzevy.setOnClickListener(this.zzevw);
        this.zzadp();
    }

    @Override
    public final void onSessionEnded() {
        this.zzevy.setOnClickListener(null);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzadp();
    }

    @Override
    public final void onSendingRemoteMediaRequest() {
        this.zzaz(true);
    }

    private final void zzadp() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzevy.setEnabled(false);
            return;
        }
        if (remoteMediaClient.isPaused()) {
            this.zza(this.zzewp, this.zzewq);
            return;
        }
        if (remoteMediaClient.isPlaying()) {
            if (remoteMediaClient.isLiveStream()) {
                this.zza(this.zzewt, this.zzewu);
                return;
            }
            this.zza(this.zzewr, this.zzews);
            return;
        }
        if (remoteMediaClient.isBuffering()) {
            this.zzaz(false);
            return;
        }
        if (remoteMediaClient.isLoadingNextItem()) {
            this.zzaz(true);
        }
    }

    private final void zza(Drawable drawable2, String string2) {
        this.zzevy.setImageDrawable(drawable2);
        this.zzevy.setContentDescription((CharSequence)string2);
        this.zzevy.setVisibility(0);
        this.zzevy.setEnabled(true);
        if (this.zzewn != null) {
            this.zzewn.setVisibility(8);
        }
    }

    private final void zzaz(boolean bl) {
        if (this.zzewn != null) {
            this.zzewn.setVisibility(0);
        }
        this.zzevy.setVisibility(this.zzewo ? 4 : 0);
        this.zzevy.setEnabled(!bl);
    }

    static /* synthetic */ RemoteMediaClient zza(zzaxk zzaxk2) {
        return zzaxk2.getRemoteMediaClient();
    }
}

