/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbej {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final String zzeqz;
    private final List<String> zzera;
    private final boolean zzerb;
    private final LaunchOptions zzenb;
    private final boolean zzerc;
    private final CastMediaOptions zzerd;
    private final boolean zzere;
    private final double zzerf;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zzeqz = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzera = new ArrayList<String>(n);
        if (n > 0) {
            this.zzera.addAll(list);
        }
        this.zzerb = bl;
        this.zzenb = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzerc = bl2;
        this.zzerd = castMediaOptions;
        this.zzere = bl3;
        this.zzerf = d;
    }

    public String getReceiverApplicationId() {
        return this.zzeqz;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzera);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzerb;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzenb;
    }

    public boolean getResumeSavedSession() {
        return this.zzerc;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzerd;
    }

    public boolean getEnableReconnectionService() {
        return this.zzere;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzerf;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbem.zze((Parcel)parcel2);
        zzbem.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbem.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbem.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbem.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbem.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbem.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbem.zzai((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zzeqz;
        private List<String> zzera = new ArrayList<String>();
        private boolean zzerb;
        private LaunchOptions zzenb = new LaunchOptions();
        private boolean zzerc = true;
        private CastMediaOptions zzerd = new CastMediaOptions.Builder().build();
        private boolean zzere = true;
        private double zzerf = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zzeqz = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzera = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzerb = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzenb = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zzerc = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzerd = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzere = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzerf = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zzeqz, this.zzera, this.zzerb, this.zzenb, this.zzerc, this.zzerd, this.zzere, this.zzerf);
        }
    }
}

