/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzh;
import com.google.android.gms.internal.zzaxj;
import com.google.android.gms.internal.zzaxl;
import com.google.android.gms.internal.zzayn;
import com.google.android.gms.internal.zzbbv;
import com.google.android.gms.internal.zzbbw;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbbv zzelm = new zzbbv("CastSession");
    private final Context zzeqr;
    private final Set<Cast.Listener> zzerg = new HashSet<Cast.Listener>();
    private final zzl zzerh;
    private final CastOptions zzeqx;
    private final Cast.CastApi zzeri;
    private final zzaxl zzerj;
    private final zzayn zzerk;
    private GoogleApiClient zzerl;
    private RemoteMediaClient zzerm;
    private CastDevice zzern;
    private Cast.ApplicationConnectionResult zzero;

    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzaxl zzaxl2, zzayn zzayn2) {
        super(context, string2, string3);
        this.zzeqr = context.getApplicationContext();
        this.zzeqx = castOptions;
        this.zzeri = castApi;
        this.zzerj = zzaxl2;
        this.zzerk = zzayn2;
        this.zzerh = zzaxj.zza(context, castOptions, this.zzacp(), new zzb(this, null));
    }

    @Override
    protected void onStarting(Bundle bundle) {
        this.zzern = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void onResuming(Bundle bundle) {
        this.zzern = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void start(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zzf(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzerh.zzb(bl, 0);
        }
        catch (RemoteException remoteException) {
            zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        return this.zzerm;
    }

    public CastDevice getCastDevice() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        return this.zzern;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            this.zzeri.requestStatus(this.zzerl);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.getActiveInputState(this.zzerl);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.getStandbyState(this.zzerl);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.getApplicationMetadata(this.zzerl);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.getApplicationStatus(this.zzerl);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            this.zzeri.setVolume(this.zzerl, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.getVolume(this.zzerl);
        }
        return 0.0;
    }

    public final zzayn zzacj() {
        return this.zzerk;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            this.zzeri.setMute(this.zzerl, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.isMute(this.zzerl);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        return this.zzero;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            this.zzeri.setMessageReceivedCallbacks(this.zzerl, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            this.zzeri.removeMessageReceivedCallbacks(this.zzerl, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerl != null) {
            return this.zzeri.sendMessage(this.zzerl, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzerg.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzerg.remove(listener);
        }
    }

    private final void zzf(Bundle bundle) {
        zzd zzd2;
        this.zzern = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzern == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzerl != null) {
            this.zzerl.disconnect();
            this.zzerl = null;
        }
        zzelm.zzb("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzern});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zzeqx;
        CastDevice castDevice = this.zzern;
        Context context = this.zzeqr;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzerl = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zze(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzerl.connect();
    }

    private final void zzbf(int n) {
        this.zzerk.zzbi(n);
        if (this.zzerl != null) {
            this.zzerl.disconnect();
            this.zzerl = null;
        }
        this.zzern = null;
        if (this.zzerm != null) {
            this.zzerm.zzc(null);
            this.zzerm = null;
        }
        this.zzero = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbq.zzfz((String)"Must be called from the main thread.");
        if (this.zzerm == null) {
            return 0L;
        }
        return this.zzerm.getStreamDuration() - this.zzerm.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zzerq;

        private zzb(CastSession castSession) {
            this.zzerq = castSession;
        }

        @Override
        public final void zzq(String string2, String string3) {
            if (this.zzerq.zzerl != null) {
                this.zzerq.zzeri.joinApplication(this.zzerq.zzerl, string2, string3).setResultCallback((ResultCallback)new zza(this.zzerq, "joinApplication"));
            }
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            if (this.zzerq.zzerl != null) {
                this.zzerq.zzeri.launchApplication(this.zzerq.zzerl, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zzerq, "launchApplication"));
            }
        }

        @Override
        public final void zzfa(String string2) {
            if (this.zzerq.zzerl != null) {
                this.zzerq.zzeri.stopApplication(this.zzerq.zzerl, string2);
            }
        }

        @Override
        public final void zzbf(int n) {
            this.zzerq.zzbf(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zzerp;
        private /* synthetic */ CastSession zzerq;

        zza(CastSession castSession, String string2) {
            this.zzerq = castSession;
            this.zzerp = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzerq.zzero = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zzelm.zzb("%s() -> success result", new Object[]{zza2.zzerp});
                    zza2.zzerq.zzerm = new RemoteMediaClient(new zzbbw(null, zzh.zzalu()), zza2.zzerq.zzeri);
                    try {
                        zza2.zzerq.zzerm.zzc(zza2.zzerq.zzerl);
                        zza2.zzerq.zzerm.zzadr();
                        zza2.zzerq.zzerm.requestStatus();
                        zza2.zzerq.zzerk.zza(zza2.zzerq.zzerm, zza2.zzerq.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zzelm.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzerq.zzerm = null;
                    }
                    zza2.zzerq.zzerh.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zzelm.zzb("%s() -> failure result", new Object[]{zza2.zzerp});
                zza2.zzerq.zzerh.zzbg(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zzerq;

        private zzc(CastSession castSession) {
            this.zzerq = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zzerq.zzbf(n);
            this.zzerq.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zzerq.zzerg).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zzerq;

        private zzd(CastSession castSession) {
            this.zzerq = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zzerq.zzerm != null) {
                    try {
                        this.zzerq.zzerm.zzadr();
                        this.zzerq.zzerm.requestStatus();
                    }
                    catch (IOException iOException) {
                        zzelm.zza((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zzerq.zzerm = null;
                    }
                }
                this.zzerq.zzerh.onConnected(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zzerq.zzerh.onConnectionSuspended(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zzerq.zzerh.onConnectionFailed(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zzelm.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

