/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdlp;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzesu = new Paint();
    private final Paint zzetu = new Paint();
    private final Rect zzesz = new Rect();
    private final int zzetv;
    private final int zzetw;
    private float zzesv;
    private float zzetx = 1.0f;
    private float centerX;
    private float centerY;
    private float zzety;
    private float zzetz;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzetv = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzetw = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzesu.setAntiAlias(true);
        this.zzesu.setStyle(Paint.Style.FILL);
        this.zzetu.setAntiAlias(true);
        this.zzetu.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzesu.setColor(-1);
        innerZoneDrawable.zzetu.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzetz > 0.0f) {
            float f = this.zzesv * this.zzety;
            this.zzetu.setAlpha((int)((float)this.zzetw * this.zzetz));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzetu);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzesv * this.zzetx, this.zzesu);
    }

    public void setAlpha(int n) {
        this.zzesu.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzesu.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzetx = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzety = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzetz = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzesz.set(rect);
        this.centerX = this.zzesz.exactCenterX();
        this.centerY = this.zzesz.exactCenterY();
        this.zzesv = Math.max((float)this.zzetv, Math.max((float)this.zzesz.width() / 2.0f, (float)this.zzesz.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzadk() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdlp.zzbkd());
        return objectAnimator.setDuration(200L);
    }
}

