/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzdlp;
import com.google.android.gms.internal.zzdlr;

class OuterHighlightDrawable
extends Drawable {
    private final int zzeug;
    private final int zzeuh;
    private final int zzeui;
    private final Rect zzesz = new Rect();
    private final Rect zzeua = new Rect();
    private final Paint zzesu = new Paint();
    private float zzesv;
    private float zzetx = 1.0f;
    private float centerX;
    private float centerY;
    private float zzeuj = 0.0f;
    private float zzeuk = 0.0f;
    private int zzeul = 244;

    public OuterHighlightDrawable(Context context) {
        if (zzq.zzamb()) {
            Context context2 = context;
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843827, typedValue, true);
            this.setColor(ColorUtils.setAlphaComponent((int)typedValue.data, (int)244));
        } else {
            this.setColor(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzesu.setAntiAlias(true);
        this.zzesu.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zzeug = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzeuh = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzeui = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX + this.zzeuj, this.centerY + this.zzeuk, this.zzesv * this.zzetx, this.zzesu);
    }

    public void setAlpha(int n) {
        this.zzesu.setAlpha(n);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.zzesu.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzesu.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @ColorInt
    public final int getColor() {
        return this.zzesu.getColor();
    }

    public final void setColor(@ColorInt int n) {
        this.zzesu.setColor(n);
        this.zzeul = this.zzesu.getAlpha();
        this.invalidateSelf();
    }

    public final void zzb(Rect rect, Rect rect2) {
        this.zzesz.set(rect);
        this.zzeua.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zzeug) {
            this.centerX = f;
            this.centerY = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.centerX = bl ? rect2.exactCenterX() + (float)this.zzeuh : rect2.exactCenterX() - (float)this.zzeuh;
            this.centerY = rect2.exactCenterY();
        }
        this.zzesv = (float)this.zzeui + Math.max(OuterHighlightDrawable.zza(this.centerX, this.centerY, rect), OuterHighlightDrawable.zza(this.centerX, this.centerY, rect2));
        this.invalidateSelf();
    }

    @Keep
    public void setScale(float f) {
        this.zzetx = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationX(float f) {
        this.zzeuj = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationY(float f) {
        this.zzeuk = f;
        this.invalidateSelf();
    }

    public final float getCenterX() {
        return this.centerX;
    }

    public final float getCenterY() {
        return this.centerY;
    }

    public final boolean zzd(float f, float f2) {
        return zzdlr.zza(f, f2, this.centerX, this.centerY) < this.zzesv;
    }

    private static float zza(float f, float f2, Rect rect) {
        float f3;
        float f4 = rect.bottom;
        float f5 = rect.right;
        float f6 = rect.top;
        float f7 = rect.left;
        float f8 = f2;
        float f9 = f;
        float f10 = zzdlr.zza(f9, f8, f7, f4);
        float f11 = zzdlr.zza(f9, f8, f5, f4);
        float f12 = zzdlr.zza(f9, f8, f5, f6);
        float f13 = zzdlr.zza(f9, f8, f7, f6);
        return (float)Math.ceil(f3 > f12 && f13 > f11 && f13 > f10 ? f13 : (f12 > f11 && f12 > f10 ? f12 : (f11 > f10 ? f11 : f10)));
    }

    public final Animator zze(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzeul});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdlp.zzbkc());
        return objectAnimator.setDuration(350L);
    }
}

