/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.appcompat.R;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.AdBreakClipInfo;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionManagerListener;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayr;
import com.google.android.gms.internal.zzaza;

public class ExpandedControllerActivity
extends AppCompatActivity
implements ControlButtonsContainer {
    private final SessionManagerListener<CastSession> zzezz = new zzb(this, null);
    private final RemoteMediaClient.Listener zzeyg = new zza(this, null);
    @DrawableRes
    private int zzfaa;
    @ColorRes
    private int zzfab;
    @DrawableRes
    private int zzfac;
    @DrawableRes
    private int zzfad;
    @DrawableRes
    private int zzfae;
    @DrawableRes
    private int zzfaf;
    @DrawableRes
    private int zzfag;
    @DrawableRes
    private int zzfah;
    @DrawableRes
    private int zzfai;
    @DrawableRes
    private int zzfaj;
    @DrawableRes
    private int zzfak;
    @DrawableRes
    private int zzfal;
    @DrawableRes
    private int zzfam;
    private int zzfan;
    private TextView zzfao;
    private SeekBar zzeyw;
    private ImageView zzfap;
    private ImageView zzfaq;
    private zzayr zzfar;
    private int[] zzfas;
    private ImageView[] zzfat = new ImageView[4];
    private View zzfau;
    private ImageView zzfav;
    private TextView zzfaw;
    private TextView zzfax;
    private zzayc zzfay;
    private UIMediaController zzfaz;
    private SessionManager zzeqt;
    private boolean zzfba;

    public ExpandedControllerActivity() {
    }

    protected void onCreate(Bundle bundle) {
        Drawable drawable2;
        TypedArray typedArray;
        super.onCreate(bundle);
        this.zzeqt = CastContext.getSharedInstance((Context)this).getSessionManager();
        if (this.zzeqt.getCurrentCastSession() == null) {
            this.finish();
        }
        this.zzfaz = new UIMediaController((Activity)this);
        this.zzfaz.setPostRemoteMediaClientListener(this.zzeyg);
        this.setContentView(R.layout.cast_expanded_controller_activity);
        ExpandedControllerActivity expandedControllerActivity = this;
        TypedArray typedArray2 = expandedControllerActivity.obtainStyledAttributes(new int[]{R.attr.selectableItemBackgroundBorderless, R.attr.colorControlActivated});
        expandedControllerActivity.zzfaa = typedArray2.getResourceId(0, 0);
        expandedControllerActivity.zzfab = typedArray2.getResourceId(1, 0);
        typedArray2.recycle();
        expandedControllerActivity = this;
        typedArray2 = expandedControllerActivity.obtainStyledAttributes(null, R.styleable.CastExpandedController, R.attr.castExpandedControllerStyle, R.style.CastExpandedController);
        expandedControllerActivity.zzfan = typedArray2.getResourceId(R.styleable.CastExpandedController_castButtonColor, 0);
        expandedControllerActivity.zzfac = typedArray2.getResourceId(R.styleable.CastExpandedController_castSeekBarProgressDrawable, 0);
        expandedControllerActivity.zzfad = typedArray2.getResourceId(R.styleable.CastExpandedController_castSeekBarThumbDrawable, 0);
        expandedControllerActivity.zzfae = typedArray2.getResourceId(R.styleable.CastExpandedController_castPlayButtonDrawable, 0);
        expandedControllerActivity.zzfaf = typedArray2.getResourceId(R.styleable.CastExpandedController_castPauseButtonDrawable, 0);
        expandedControllerActivity.zzfag = typedArray2.getResourceId(R.styleable.CastExpandedController_castStopButtonDrawable, 0);
        expandedControllerActivity.zzfah = typedArray2.getResourceId(R.styleable.CastExpandedController_castSkipPreviousButtonDrawable, 0);
        expandedControllerActivity.zzfai = typedArray2.getResourceId(R.styleable.CastExpandedController_castSkipNextButtonDrawable, 0);
        expandedControllerActivity.zzfaj = typedArray2.getResourceId(R.styleable.CastExpandedController_castRewind30ButtonDrawable, 0);
        expandedControllerActivity.zzfak = typedArray2.getResourceId(R.styleable.CastExpandedController_castForward30ButtonDrawable, 0);
        expandedControllerActivity.zzfal = typedArray2.getResourceId(R.styleable.CastExpandedController_castMuteToggleButtonDrawable, 0);
        expandedControllerActivity.zzfam = typedArray2.getResourceId(R.styleable.CastExpandedController_castClosedCaptionsButtonDrawable, 0);
        int n = typedArray2.getResourceId(R.styleable.CastExpandedController_castControlButtons, 0);
        if (n != 0) {
            typedArray = expandedControllerActivity.getResources().obtainTypedArray(n);
            zzbq.checkArgument((typedArray.length() == 4 ? 1 : 0) != 0);
            expandedControllerActivity.zzfas = new int[typedArray.length()];
            for (int i = 0; i < typedArray.length(); ++i) {
                expandedControllerActivity.zzfas[i] = typedArray.getResourceId(i, 0);
            }
            typedArray.recycle();
        } else {
            expandedControllerActivity.zzfas = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
        }
        typedArray2.recycle();
        UIMediaController uIMediaController = this.zzfaz;
        typedArray2 = this.findViewById(R.id.expanded_controller_layout);
        expandedControllerActivity = this;
        this.zzfap = (ImageView)typedArray2.findViewById(R.id.background_image_view);
        expandedControllerActivity.zzfaq = (ImageView)typedArray2.findViewById(R.id.blurred_background_image_view);
        typedArray = typedArray2.findViewById(R.id.background_place_holder_image_view);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        expandedControllerActivity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        uIMediaController.bindImageViewToImageOfCurrentItem(expandedControllerActivity.zzfap, new ImageHints(4, displayMetrics.widthPixels, displayMetrics.heightPixels), (View)typedArray);
        expandedControllerActivity.zzfao = (TextView)typedArray2.findViewById(R.id.status_text);
        ProgressBar progressBar = (ProgressBar)typedArray2.findViewById(R.id.loading_indicator);
        uIMediaController.bindViewToLoadingIndicator((View)progressBar);
        TextView textView = (TextView)typedArray2.findViewById(R.id.start_text);
        TextView textView2 = (TextView)typedArray2.findViewById(R.id.end_text);
        ImageView imageView = (ImageView)typedArray2.findViewById(R.id.live_stream_indicator);
        expandedControllerActivity.zzeyw = (SeekBar)typedArray2.findViewById(R.id.seek_bar);
        ExpandedControllerActivity expandedControllerActivity2 = expandedControllerActivity;
        Drawable drawable3 = expandedControllerActivity2.getResources().getDrawable(expandedControllerActivity2.zzfac);
        Object object = null;
        if (drawable3 != null) {
            if (expandedControllerActivity2.zzfac == R.drawable.cast_expanded_controller_seekbar_track) {
                object = expandedControllerActivity2.zzaej();
                drawable2 = (LayerDrawable)drawable3;
                Drawable drawable4 = DrawableCompat.wrap((Drawable)drawable2.findDrawableByLayerId(16908301));
                DrawableCompat.setTintList((Drawable)drawable4, (ColorStateList)object);
                drawable2.setDrawableByLayerId(16908301, drawable4);
                drawable2.findDrawableByLayerId(0x1020000).setColorFilter(expandedControllerActivity2.getResources().getColor(R.color.cast_expanded_controller_seek_bar_progress_background_tint_color), PorterDuff.Mode.SRC_IN);
            }
            expandedControllerActivity2.zzeyw.setProgressDrawable(drawable3);
        }
        if ((drawable2 = expandedControllerActivity2.getResources().getDrawable(expandedControllerActivity2.zzfad)) != null) {
            if (expandedControllerActivity2.zzfad == R.drawable.cast_expanded_controller_seekbar_thumb) {
                if (object == null) {
                    object = expandedControllerActivity2.zzaej();
                }
                drawable2 = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)object);
            }
            expandedControllerActivity2.zzeyw.setThumb(drawable2);
        }
        expandedControllerActivity2 = expandedControllerActivity;
        if (zzq.zzamb()) {
            expandedControllerActivity2.zzeyw.setSplitTrack(false);
        }
        SeekBar seekBar = (SeekBar)typedArray2.findViewById(R.id.live_stream_seek_bar);
        uIMediaController.bindTextViewToStreamPosition(textView, true);
        uIMediaController.bindTextViewToStreamDuration(textView2, (View)imageView);
        uIMediaController.bindSeekBar(expandedControllerActivity.zzeyw);
        uIMediaController.bindViewToUIController((View)seekBar, new zzaza(seekBar, expandedControllerActivity.zzeyw));
        expandedControllerActivity.zzfat[0] = (ImageView)typedArray2.findViewById(R.id.button_0);
        expandedControllerActivity.zzfat[1] = (ImageView)typedArray2.findViewById(R.id.button_1);
        expandedControllerActivity.zzfat[2] = (ImageView)typedArray2.findViewById(R.id.button_2);
        expandedControllerActivity.zzfat[3] = (ImageView)typedArray2.findViewById(R.id.button_3);
        expandedControllerActivity.zza((View)typedArray2, R.id.button_0, expandedControllerActivity.zzfas[0], uIMediaController);
        expandedControllerActivity.zza((View)typedArray2, R.id.button_1, expandedControllerActivity.zzfas[1], uIMediaController);
        expandedControllerActivity.zza((View)typedArray2, R.id.button_play_pause_toggle, R.id.cast_button_type_play_pause_toggle, uIMediaController);
        expandedControllerActivity.zza((View)typedArray2, R.id.button_2, expandedControllerActivity.zzfas[2], uIMediaController);
        expandedControllerActivity.zza((View)typedArray2, R.id.button_3, expandedControllerActivity.zzfas[3], uIMediaController);
        expandedControllerActivity.zzfau = expandedControllerActivity.findViewById(R.id.ad_container);
        expandedControllerActivity.zzfav = (ImageView)expandedControllerActivity.zzfau.findViewById(R.id.ad_image_view);
        expandedControllerActivity.zzfax = (TextView)expandedControllerActivity.zzfau.findViewById(R.id.ad_label);
        expandedControllerActivity.zzfaw = (TextView)expandedControllerActivity.zzfau.findViewById(R.id.ad_in_progress_label);
        drawable3 = (RelativeLayout)typedArray2.findViewById(R.id.seek_bar_controls);
        expandedControllerActivity2 = expandedControllerActivity;
        object = new zzayr((Context)expandedControllerActivity2);
        drawable2 = new RelativeLayout.LayoutParams(-1, -2);
        drawable2.addRule(0, R.id.end_text);
        drawable2.addRule(1, R.id.start_text);
        drawable2.addRule(6, R.id.seek_bar);
        drawable2.addRule(7, R.id.seek_bar);
        drawable2.addRule(5, R.id.seek_bar);
        drawable2.addRule(8, R.id.seek_bar);
        object.setLayoutParams((ViewGroup.LayoutParams)drawable2);
        if (zzq.zzalx()) {
            object.setPaddingRelative(expandedControllerActivity2.zzeyw.getPaddingStart(), expandedControllerActivity2.zzeyw.getPaddingTop(), expandedControllerActivity2.zzeyw.getPaddingEnd(), expandedControllerActivity2.zzeyw.getPaddingBottom());
        } else {
            object.setPadding(expandedControllerActivity2.zzeyw.getPaddingLeft(), expandedControllerActivity2.zzeyw.getPaddingTop(), expandedControllerActivity2.zzeyw.getPaddingRight(), expandedControllerActivity2.zzeyw.getPaddingBottom());
        }
        object.setContentDescription((CharSequence)expandedControllerActivity2.getResources().getString(R.string.cast_seek_bar));
        object.setBackgroundColor(0);
        drawable3.addView((View)object);
        expandedControllerActivity.zzfar = object;
        typedArray2 = (Toolbar)this.findViewById(R.id.toolbar);
        expandedControllerActivity = this;
        expandedControllerActivity.setSupportActionBar((Toolbar)typedArray2);
        if (expandedControllerActivity.getSupportActionBar() != null) {
            expandedControllerActivity.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            expandedControllerActivity.getSupportActionBar().setHomeAsUpIndicator(R.drawable.quantum_ic_keyboard_arrow_down_white_36);
        }
        this.zzael();
        this.zzaek();
        this.zzfay = new zzayc(this.getApplicationContext(), new ImageHints(-1, this.zzfav.getWidth(), this.zzfav.getHeight()));
        this.zzfay.zza(new com.google.android.gms.cast.framework.media.widget.zza(this));
    }

    protected void onResume() {
        RemoteMediaClient remoteMediaClient;
        CastContext.getSharedInstance((Context)this).getSessionManager().addSessionManagerListener(this.zzezz, CastSession.class);
        CastSession castSession = CastContext.getSharedInstance((Context)this).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected() && !castSession.isConnecting()) {
            this.finish();
        }
        this.zzfba = (remoteMediaClient = this.getRemoteMediaClient()) == null || !remoteMediaClient.hasMediaSession();
        this.zzael();
        this.zzaem();
        super.onResume();
    }

    protected void onPause() {
        CastContext.getSharedInstance((Context)this).getSessionManager().removeSessionManagerListener(this.zzezz, CastSession.class);
        super.onPause();
    }

    protected void onDestroy() {
        this.zzfay.clear();
        if (this.zzfaz != null) {
            this.zzfaz.setPostRemoteMediaClientListener(null);
            this.zzfaz.dispose();
        }
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == 16908332) {
            this.finish();
        }
        return true;
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            ExpandedControllerActivity expandedControllerActivity = this;
            int n = expandedControllerActivity.getWindow().getDecorView().getSystemUiVisibility() ^ 2;
            if (zzq.zzalw()) {
                n ^= 4;
            }
            if (zzq.zzalz()) {
                n ^= 0x1000;
            }
            expandedControllerActivity.getWindow().getDecorView().setSystemUiVisibility(n);
            if (zzq.zzaly()) {
                expandedControllerActivity.setImmersive(true);
            }
        }
    }

    public TextView getStatusTextView() {
        return this.zzfao;
    }

    public SeekBar getSeekBar() {
        return this.zzeyw;
    }

    @Override
    public final int getButtonSlotCount() {
        return 4;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzfas[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzfat[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzfaz;
    }

    private final ColorStateList zzaej() {
        int n = this.getResources().getColor(this.zzfab);
        TypedValue typedValue = new TypedValue();
        this.getResources().getValue(R.dimen.cast_expanded_controller_seekbar_disabled_alpha, typedValue, true);
        int n2 = Color.argb((int)((int)(typedValue.getFloat() * (float)Color.alpha((int)n))), (int)Color.red((int)n), (int)Color.green((int)n), (int)Color.blue((int)n));
        int[] nArray = new int[]{n, n2};
        int[][] nArrayArray = new int[][]{{16842910}, {-16842910}};
        return new ColorStateList((int[][])nArrayArray, nArray);
    }

    private final void zza(View view, int n, int n2, UIMediaController uIMediaController) {
        ImageView imageView = (ImageView)view.findViewById(n);
        if (n2 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n2 != R.id.cast_button_type_custom) {
            if (n2 == R.id.cast_button_type_play_pause_toggle) {
                UIMediaController uIMediaController2 = uIMediaController;
                ImageView imageView2 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView2.setBackgroundResource(expandedControllerActivity.zzfaa);
                Drawable drawable2 = com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfaf);
                Drawable drawable3 = com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfae);
                Drawable drawable4 = com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfag);
                imageView2.setImageDrawable(drawable3);
                uIMediaController2.bindImageViewToPlayPauseToggle(imageView2, drawable3, drawable2, drawable4, null, false);
                return;
            }
            if (n2 == R.id.cast_button_type_skip_previous) {
                UIMediaController uIMediaController3 = uIMediaController;
                ImageView imageView3 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView3.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView3.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfah));
                imageView3.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_skip_prev));
                uIMediaController3.bindViewToSkipPrev((View)imageView3, 0);
                return;
            }
            if (n2 == R.id.cast_button_type_skip_next) {
                UIMediaController uIMediaController4 = uIMediaController;
                ImageView imageView4 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView4.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView4.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfai));
                imageView4.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_skip_next));
                uIMediaController4.bindViewToSkipNext((View)imageView4, 0);
                return;
            }
            if (n2 == R.id.cast_button_type_rewind_30_seconds) {
                UIMediaController uIMediaController5 = uIMediaController;
                ImageView imageView5 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView5.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView5.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfaj));
                imageView5.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_rewind_30));
                uIMediaController5.bindViewToRewind((View)imageView5, 30000L);
                return;
            }
            if (n2 == R.id.cast_button_type_forward_30_seconds) {
                UIMediaController uIMediaController6 = uIMediaController;
                ImageView imageView6 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView6.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView6.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfak));
                imageView6.setContentDescription((CharSequence)expandedControllerActivity.getResources().getString(R.string.cast_forward_30));
                uIMediaController6.bindViewToForward((View)imageView6, 30000L);
                return;
            }
            if (n2 == R.id.cast_button_type_mute_toggle) {
                UIMediaController uIMediaController7 = uIMediaController;
                ImageView imageView7 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView7.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView7.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfal));
                uIMediaController7.bindImageViewToMuteToggle(imageView7);
                return;
            }
            if (n2 == R.id.cast_button_type_closed_caption) {
                UIMediaController uIMediaController8 = uIMediaController;
                ImageView imageView8 = imageView;
                ExpandedControllerActivity expandedControllerActivity = this;
                imageView8.setBackgroundResource(expandedControllerActivity.zzfaa);
                imageView8.setImageDrawable(com.google.android.gms.cast.framework.media.widget.zzb.zzb((Context)expandedControllerActivity, expandedControllerActivity.zzfan, expandedControllerActivity.zzfam));
                uIMediaController8.bindViewToClosedCaption((View)imageView8);
            }
        }
    }

    private final RemoteMediaClient getRemoteMediaClient() {
        CastSession castSession = this.zzeqt.getCurrentCastSession();
        if (castSession != null && castSession.isConnected()) {
            return castSession.getRemoteMediaClient();
        }
        return null;
    }

    private final void zzaek() {
        ActionBar actionBar;
        MediaMetadata mediaMetadata;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient != null && remoteMediaClient.hasMediaSession() && (mediaInfo = remoteMediaClient.getMediaInfo()) != null && (mediaMetadata = mediaInfo.getMetadata()) != null && (actionBar = this.getSupportActionBar()) != null) {
            actionBar.setTitle((CharSequence)mediaMetadata.getString("com.google.android.gms.cast.metadata.TITLE"));
        }
    }

    private final void zzael() {
        String string2;
        CastDevice castDevice;
        CastSession castSession = this.zzeqt.getCurrentCastSession();
        if (castSession != null && (castDevice = castSession.getCastDevice()) != null && !TextUtils.isEmpty((CharSequence)(string2 = castDevice.getFriendlyName()))) {
            this.zzfao.setText((CharSequence)this.getResources().getString(R.string.cast_casting_to_device, new Object[]{string2}));
            return;
        }
        this.zzfao.setText((CharSequence)"");
    }

    private final void zzaem() {
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        MediaInfo mediaInfo = remoteMediaClient == null ? null : remoteMediaClient.getMediaInfo();
        MediaStatus mediaStatus = remoteMediaClient == null ? null : remoteMediaClient.getMediaStatus();
        if (mediaStatus != null && mediaStatus.isPlayingAd()) {
            AdBreakClipInfo adBreakClipInfo;
            String string2;
            Object object;
            if (zzq.zzalx() && this.zzfaq.getVisibility() == 8 && (object = this.zzfap.getDrawable()) != null && object instanceof BitmapDrawable && (string2 = ((BitmapDrawable)object).getBitmap()) != null && (adBreakClipInfo = com.google.android.gms.cast.framework.media.widget.zzb.zza((Context)this, (Bitmap)string2, 0.25f, 7.5f)) != null) {
                this.zzfaq.setImageBitmap((Bitmap)adBreakClipInfo);
                this.zzfaq.setVisibility(0);
            }
            object = null;
            string2 = null;
            adBreakClipInfo = mediaStatus.getCurrentAdBreakClip();
            if (adBreakClipInfo != null) {
                object = adBreakClipInfo.getTitle();
                string2 = adBreakClipInfo.getContentUrl();
            }
            this.zzfaw.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Uri uri = Uri.parse((String)string2);
                this.zzfay.zzl(uri);
            } else {
                this.zzfav.setVisibility(8);
            }
            this.zzfax.setText((CharSequence)(TextUtils.isEmpty((CharSequence)object) ? this.getResources().getString(R.string.cast_ad_label) : object));
            this.zzeyw.setEnabled(false);
            this.zzfau.setVisibility(0);
        } else {
            this.zzeyw.setEnabled(true);
            this.zzfau.setVisibility(8);
            if (zzq.zzalx()) {
                this.zzfaq.setVisibility(8);
                this.zzfaq.setImageBitmap(null);
            }
        }
        if (mediaInfo != null) {
            this.zzfar.zzbj(this.zzeyw.getMax());
            this.zzfar.zzb(mediaInfo.getAdBreaks(), -1);
        }
    }

    static /* synthetic */ TextView zza(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzfaw;
    }

    static /* synthetic */ ImageView zzb(ExpandedControllerActivity expandedControllerActivity) {
        return expandedControllerActivity.zzfav;
    }

    static /* synthetic */ boolean zza(ExpandedControllerActivity expandedControllerActivity, boolean bl) {
        expandedControllerActivity.zzfba = false;
        return false;
    }

    final class zza
    implements RemoteMediaClient.Listener {
        private /* synthetic */ ExpandedControllerActivity zzfbb;

        private zza(ExpandedControllerActivity expandedControllerActivity) {
            this.zzfbb = expandedControllerActivity;
        }

        @Override
        public final void onStatusUpdated() {
            RemoteMediaClient remoteMediaClient = this.zzfbb.getRemoteMediaClient();
            if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
                if (!this.zzfbb.zzfba) {
                    this.zzfbb.finish();
                }
                return;
            }
            ExpandedControllerActivity.zza(this.zzfbb, false);
            this.zzfbb.zzael();
            this.zzfbb.zzaem();
        }

        @Override
        public final void onMetadataUpdated() {
            this.zzfbb.zzaek();
        }

        @Override
        public final void onQueueStatusUpdated() {
        }

        @Override
        public final void onPreloadStatusUpdated() {
        }

        @Override
        public final void onSendingRemoteMediaRequest() {
            this.zzfbb.zzfao.setText((CharSequence)this.zzfbb.getResources().getString(R.string.cast_expanded_controller_loading));
        }

        @Override
        public final void onAdBreakStatusUpdated() {
            this.zzfbb.zzaem();
        }

        /* synthetic */ zza(ExpandedControllerActivity expandedControllerActivity, com.google.android.gms.cast.framework.media.widget.zza zza2) {
            this(expandedControllerActivity);
        }
    }

    final class zzb
    implements SessionManagerListener<CastSession> {
        private /* synthetic */ ExpandedControllerActivity zzfbb;

        private zzb(ExpandedControllerActivity expandedControllerActivity) {
            this.zzfbb = expandedControllerActivity;
        }

        @Override
        public final /* synthetic */ void onSessionEnded(Session session, int n) {
            this.zzfbb.finish();
        }

        /* synthetic */ zzb(ExpandedControllerActivity expandedControllerActivity, com.google.android.gms.cast.framework.media.widget.zza zza2) {
            this(expandedControllerActivity);
        }
    }
}

