/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayv;

public final class zzayu
extends UIController {
    private final ImageView zzeym;
    private final ImageHints zzexk;
    private final Bitmap zzeyn;
    private final ImagePicker zzeuq;
    private final zzayc zzeyo;

    public zzayu(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzeym = imageView;
        this.zzexk = imageHints;
        this.zzeyn = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzeuq = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzeyo = new zzayc(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeyo.zza(new zzayv(this));
        this.zzeym.setImageBitmap(this.zzeyn);
        this.zzaee();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeyo.clear();
        this.zzeym.setImageBitmap(this.zzeyn);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaee();
    }

    private final void zzaee() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzeym.setImageBitmap(this.zzeyn);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzayu zzayu2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzayu2.zzeuq != null && (webImage = zzayu2.zzeuq.onPickImage(mediaInfo.getMetadata(), zzayu2.zzexk)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzeym.setImageBitmap(this.zzeyn);
            return;
        }
        this.zzeyo.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzayu zzayu2) {
        return zzayu2.zzeym;
    }
}

