/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzayc;
import com.google.android.gms.internal.zzayx;

public final class zzayw
extends UIController {
    private final ImageView zzeym;
    private final ImageHints zzexk;
    private final Bitmap zzeyq;
    private final View zzeyr;
    private final ImagePicker zzeuq;
    private final zzayc zzeyo;

    public zzayw(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n, View view) {
        this.zzeym = imageView;
        this.zzexk = imageHints;
        this.zzeyq = n != 0 ? BitmapFactory.decodeResource((Resources)context.getResources(), (int)n) : null;
        this.zzeyr = view;
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzeuq = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzeyo = new zzayc(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzeyo.zza(new zzayx(this));
        this.zzaef();
        this.zzaee();
    }

    @Override
    public final void onSessionEnded() {
        this.zzeyo.clear();
        this.zzaef();
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaee();
    }

    private final void zzaee() {
        WebImage webImage;
        Uri uri;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzaef();
            return;
        }
        MediaInfo mediaInfo = remoteMediaClient.getMediaInfo();
        zzayw zzayw2 = this;
        if ((mediaInfo == null ? null : (uri = zzayw2.zzeuq != null && (webImage = zzayw2.zzeuq.onPickImage(mediaInfo.getMetadata(), zzayw2.zzexk)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0))) == null) {
            this.zzaef();
            return;
        }
        this.zzeyo.zzl(uri);
    }

    private final void zzaef() {
        if (this.zzeyr != null) {
            this.zzeyr.setVisibility(0);
            this.zzeym.setVisibility(4);
        }
        if (this.zzeyq != null) {
            this.zzeym.setImageBitmap(this.zzeyq);
        }
    }

    static /* synthetic */ View zza(zzayw zzayw2) {
        return zzayw2.zzeyr;
    }

    static /* synthetic */ ImageView zzb(zzayw zzayw2) {
        return zzayw2.zzeym;
    }
}

