/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.Keep;
import com.google.android.gms.R;
import com.google.android.gms.internal.zzdmr;

class InnerZoneDrawable
extends Drawable {
    private final Paint zzevx = new Paint();
    private final Paint zzewx = new Paint();
    private final Rect zzewc = new Rect();
    private final int zzewy;
    private final int zzewz;
    private float zzevy;
    private float zzexa = 1.0f;
    private float centerX;
    private float centerY;
    private float zzexb;
    private float zzexc;

    public InnerZoneDrawable(Context context) {
        Resources resources = context.getResources();
        this.zzewy = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_inner_radius);
        this.zzewz = resources.getInteger(R.integer.cast_libraries_material_featurehighlight_pulse_base_alpha);
        this.zzevx.setAntiAlias(true);
        this.zzevx.setStyle(Paint.Style.FILL);
        this.zzewx.setAntiAlias(true);
        this.zzewx.setStyle(Paint.Style.FILL);
        InnerZoneDrawable innerZoneDrawable = this;
        innerZoneDrawable.zzevx.setColor(-1);
        innerZoneDrawable.zzewx.setColor(-1);
        innerZoneDrawable.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (this.zzexc > 0.0f) {
            float f = this.zzevy * this.zzexb;
            this.zzewx.setAlpha((int)((float)this.zzewz * this.zzexc));
            canvas.drawCircle(this.centerX, this.centerY, f, this.zzewx);
        }
        canvas.drawCircle(this.centerX, this.centerY, this.zzevy * this.zzexa, this.zzevx);
    }

    public void setAlpha(int n) {
        this.zzevx.setAlpha(n);
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzevx.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @Keep
    public void setScale(float f) {
        this.zzexa = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseScale(float f) {
        this.zzexb = f;
        this.invalidateSelf();
    }

    @Keep
    public void setPulseAlpha(float f) {
        this.zzexc = f;
        this.invalidateSelf();
    }

    public final void zzc(Rect rect) {
        this.zzewc.set(rect);
        this.centerX = this.zzewc.exactCenterX();
        this.centerY = this.zzewc.exactCenterY();
        this.zzevy = Math.max((float)this.zzewy, Math.max((float)this.zzewc.width() / 2.0f, (float)this.zzewc.height() / 2.0f));
        this.invalidateSelf();
    }

    public final Animator zzadx() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"pulseScale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"pulseAlpha", (float[])new float[]{0.0f});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdmr.zzbkq());
        return objectAnimator.setDuration(200L);
    }
}

