/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.uicontroller.UIMediaController;
import com.google.android.gms.cast.framework.media.widget.ControlButtonsContainer;
import com.google.android.gms.cast.framework.media.widget.zzb;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbcy;

public class MiniControllerFragment
extends Fragment
implements ControlButtonsContainer {
    private static final zzbcy zzeom = new zzbcy("MiniControllerFragment");
    private boolean zzfdu;
    private int zzfdv;
    private int zzfdw;
    private TextView zzfdx;
    private int zzfdy;
    private int zzfdz;
    private int zzfdf;
    private int[] zzfdk;
    private ImageView[] zzfdl = new ImageView[3];
    private int zzfea;
    @DrawableRes
    private int zzfcw;
    @DrawableRes
    private int zzfcx;
    @DrawableRes
    private int zzfcy;
    @DrawableRes
    private int zzfeb;
    @DrawableRes
    private int zzfec;
    @DrawableRes
    private int zzfed;
    @DrawableRes
    private int zzfcz;
    @DrawableRes
    private int zzfda;
    @DrawableRes
    private int zzfdb;
    @DrawableRes
    private int zzfdc;
    @DrawableRes
    private int zzfdd;
    @DrawableRes
    private int zzfde;
    private UIMediaController zzfdr;

    public MiniControllerFragment() {
    }

    public void onInflate(Context context, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(context, attributeSet, bundle);
        AttributeSet attributeSet2 = attributeSet;
        Context context2 = context;
        MiniControllerFragment miniControllerFragment = this;
        if (miniControllerFragment.zzfdk == null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attributeSet2, R.styleable.CastMiniController, R.attr.castMiniControllerStyle, R.style.CastMiniController);
            miniControllerFragment.zzfdu = typedArray.getBoolean(R.styleable.CastMiniController_castShowImageThumbnail, true);
            miniControllerFragment.zzfdv = typedArray.getResourceId(R.styleable.CastMiniController_castTitleTextAppearance, 0);
            miniControllerFragment.zzfdw = typedArray.getResourceId(R.styleable.CastMiniController_castSubtitleTextAppearance, 0);
            miniControllerFragment.zzfdy = typedArray.getResourceId(R.styleable.CastMiniController_castBackground, 0);
            miniControllerFragment.zzfdz = typedArray.getColor(R.styleable.CastMiniController_castProgressBarColor, 0);
            miniControllerFragment.zzfdf = typedArray.getResourceId(R.styleable.CastMiniController_castButtonColor, 0);
            miniControllerFragment.zzfcw = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzfcx = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzfcy = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzfeb = typedArray.getResourceId(R.styleable.CastMiniController_castPlayButtonDrawable, 0);
            miniControllerFragment.zzfec = typedArray.getResourceId(R.styleable.CastMiniController_castPauseButtonDrawable, 0);
            miniControllerFragment.zzfed = typedArray.getResourceId(R.styleable.CastMiniController_castStopButtonDrawable, 0);
            miniControllerFragment.zzfcz = typedArray.getResourceId(R.styleable.CastMiniController_castSkipPreviousButtonDrawable, 0);
            miniControllerFragment.zzfda = typedArray.getResourceId(R.styleable.CastMiniController_castSkipNextButtonDrawable, 0);
            miniControllerFragment.zzfdb = typedArray.getResourceId(R.styleable.CastMiniController_castRewind30ButtonDrawable, 0);
            miniControllerFragment.zzfdc = typedArray.getResourceId(R.styleable.CastMiniController_castForward30ButtonDrawable, 0);
            miniControllerFragment.zzfdd = typedArray.getResourceId(R.styleable.CastMiniController_castMuteToggleButtonDrawable, 0);
            miniControllerFragment.zzfde = typedArray.getResourceId(R.styleable.CastMiniController_castClosedCaptionsButtonDrawable, 0);
            int n = typedArray.getResourceId(R.styleable.CastMiniController_castControlButtons, 0);
            if (n != 0) {
                TypedArray typedArray2 = context2.getResources().obtainTypedArray(n);
                zzbq.checkArgument((typedArray2.length() == 3 ? 1 : 0) != 0);
                miniControllerFragment.zzfdk = new int[typedArray2.length()];
                for (int i = 0; i < typedArray2.length(); ++i) {
                    miniControllerFragment.zzfdk[i] = typedArray2.getResourceId(i, 0);
                }
                typedArray2.recycle();
                if (miniControllerFragment.zzfdu) {
                    miniControllerFragment.zzfdk[0] = R.id.cast_button_type_empty;
                }
                miniControllerFragment.zzfea = 0;
                int[] nArray = miniControllerFragment.zzfdk;
                int n2 = miniControllerFragment.zzfdk.length;
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == R.id.cast_button_type_empty) continue;
                    ++miniControllerFragment.zzfea;
                }
            } else {
                zzeom.zzf("Unable to read attribute castControlButtons.", new Object[0]);
                miniControllerFragment.zzfdk = new int[]{R.id.cast_button_type_empty, R.id.cast_button_type_empty, R.id.cast_button_type_empty};
            }
            typedArray.recycle();
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.zzfdr = new UIMediaController((Activity)this.getActivity());
        View view = layoutInflater.inflate(R.layout.cast_mini_controller, viewGroup);
        view.setVisibility(8);
        this.zzfdr.bindViewVisibilityToMediaSession(view, 8);
        RelativeLayout relativeLayout = (RelativeLayout)view.findViewById(R.id.container_current);
        if (this.zzfdy != 0) {
            relativeLayout.setBackgroundResource(this.zzfdy);
        }
        ImageView imageView = (ImageView)view.findViewById(R.id.icon_view);
        TextView textView = (TextView)view.findViewById(R.id.title_view);
        if (this.zzfdv != 0) {
            textView.setTextAppearance((Context)this.getActivity(), this.zzfdv);
        }
        this.zzfdx = (TextView)view.findViewById(R.id.subtitle_view);
        if (this.zzfdw != 0) {
            this.zzfdx.setTextAppearance((Context)this.getActivity(), this.zzfdw);
        }
        ProgressBar progressBar = (ProgressBar)view.findViewById(R.id.progressBar);
        if (this.zzfdz != 0) {
            ((LayerDrawable)progressBar.getProgressDrawable()).setColorFilter(this.zzfdz, PorterDuff.Mode.SRC_IN);
        }
        this.zzfdr.bindTextViewToMetadataOfCurrentItem(textView, "com.google.android.gms.cast.metadata.TITLE");
        this.zzfdr.bindTextViewToSmartSubtitle(this.zzfdx);
        this.zzfdr.bindProgressBar(progressBar);
        this.zzfdr.bindViewToLaunchExpandedController((View)relativeLayout);
        if (this.zzfdu) {
            int n = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_width);
            int n2 = this.getResources().getDimensionPixelSize(R.dimen.cast_mini_controller_icon_height);
            this.zzfdr.bindImageViewToImageOfCurrentItem(imageView, new ImageHints(2, n, n2), R.drawable.cast_album_art_placeholder);
        } else {
            imageView.setVisibility(8);
        }
        this.zzfdl[0] = (ImageView)relativeLayout.findViewById(R.id.button_0);
        this.zzfdl[1] = (ImageView)relativeLayout.findViewById(R.id.button_1);
        this.zzfdl[2] = (ImageView)relativeLayout.findViewById(R.id.button_2);
        this.zza(relativeLayout, R.id.button_0, 0);
        this.zza(relativeLayout, R.id.button_1, 1);
        this.zza(relativeLayout, R.id.button_2, 2);
        return view;
    }

    public void onDestroy() {
        if (this.zzfdr != null) {
            this.zzfdr.dispose();
            this.zzfdr = null;
        }
        super.onDestroy();
    }

    @Override
    public final int getButtonSlotCount() {
        return 3;
    }

    @Override
    public final int getButtonTypeAt(int n) throws IndexOutOfBoundsException {
        return this.zzfdk[n];
    }

    @Override
    public final ImageView getButtonImageViewAt(int n) throws IndexOutOfBoundsException {
        return this.zzfdl[n];
    }

    @Override
    public UIMediaController getUIMediaController() {
        return this.zzfdr;
    }

    private final void zza(RelativeLayout relativeLayout, int n, int n2) {
        ImageView imageView = (ImageView)relativeLayout.findViewById(n);
        int n3 = this.zzfdk[n2];
        if (n3 == R.id.cast_button_type_empty) {
            imageView.setVisibility(4);
            return;
        }
        if (n3 != R.id.cast_button_type_custom) {
            if (n3 == R.id.cast_button_type_play_pause_toggle) {
                int n4 = this.zzfcw;
                int n5 = this.zzfcx;
                int n6 = this.zzfcy;
                if (this.zzfea == 1) {
                    n4 = this.zzfeb;
                    n5 = this.zzfec;
                    n6 = this.zzfed;
                }
                Drawable drawable2 = zzb.zza(this.getContext(), this.zzfdf, n4);
                Drawable drawable3 = zzb.zza(this.getContext(), this.zzfdf, n5);
                Drawable drawable4 = zzb.zza(this.getContext(), this.zzfdf, n6);
                imageView.setImageDrawable(drawable3);
                int n7 = n;
                MiniControllerFragment miniControllerFragment = this;
                ProgressBar progressBar = new ProgressBar(miniControllerFragment.getContext());
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(8, n7);
                layoutParams.addRule(6, n7);
                layoutParams.addRule(5, n7);
                layoutParams.addRule(7, n7);
                layoutParams.addRule(15);
                progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                progressBar.setVisibility(8);
                Drawable drawable5 = progressBar.getIndeterminateDrawable();
                if (miniControllerFragment.zzfdz != 0 && drawable5 != null) {
                    drawable5.setColorFilter(miniControllerFragment.zzfdz, PorterDuff.Mode.SRC_IN);
                }
                ProgressBar progressBar2 = progressBar;
                relativeLayout.addView((View)progressBar2);
                this.zzfdr.bindImageViewToPlayPauseToggle(imageView, drawable2, drawable3, drawable4, (View)progressBar2, true);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_previous) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfcz));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_prev));
                this.zzfdr.bindViewToSkipPrev((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_skip_next) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfda));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_skip_next));
                this.zzfdr.bindViewToSkipNext((View)imageView, 0);
                return;
            }
            if (n3 == R.id.cast_button_type_rewind_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfdb));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_rewind_30));
                this.zzfdr.bindViewToRewind((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_forward_30_seconds) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfdc));
                imageView.setContentDescription((CharSequence)this.getResources().getString(R.string.cast_forward_30));
                this.zzfdr.bindViewToForward((View)imageView, 30000L);
                return;
            }
            if (n3 == R.id.cast_button_type_mute_toggle) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfdd));
                this.zzfdr.bindImageViewToMuteToggle(imageView);
                return;
            }
            if (n3 == R.id.cast_button_type_closed_caption) {
                imageView.setImageDrawable(zzb.zza(this.getContext(), this.zzfdf, this.zzfde));
                this.zzfdr.bindViewToClosedCaption((View)imageView);
            }
        }
    }
}

