/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.IntroductoryOverlay;
import com.google.android.gms.internal.zzazd;
import com.google.android.gms.internal.zzazi;
import com.google.android.gms.internal.zzazk;

public final class zzazh
extends RelativeLayout
implements IntroductoryOverlay {
    private final boolean zzevo;
    private Activity mActivity;
    private int zzevt;
    private boolean zzevq;
    private IntroductoryOverlay.OnOverlayDismissedListener zzeuz;
    private final zzazk zzevu;

    public zzazh(IntroductoryOverlay.Builder builder) {
        this(builder, null, R.attr.castIntroOverlayStyle);
    }

    private zzazh(IntroductoryOverlay.Builder builder, AttributeSet attributeSet, int n) {
        super((Context)builder.getActivity(), null, n);
        TypedArray typedArray;
        Object object;
        this.mActivity = builder.getActivity();
        this.zzevo = builder.zzadi();
        this.zzeuz = builder.zzadg();
        TypedArray typedArray2 = this.mActivity.getTheme().obtainStyledAttributes(null, R.styleable.CastIntroOverlay, n, R.style.CastIntroOverlay);
        if (builder.zzadf() != null) {
            Rect rect = new Rect();
            builder.zzadf().getGlobalVisibleRect(rect);
            this.zzevu = new zzazk(null);
            this.zzevu.x = rect.centerX();
            this.zzevu.y = rect.centerY();
            object = new PorterDuffXfermode(PorterDuff.Mode.MULTIPLY);
            typedArray = new Paint();
            typedArray.setColor(-1);
            typedArray.setAlpha(0);
            typedArray.setXfermode((Xfermode)object);
            typedArray.setAntiAlias(true);
            this.zzevu.zzevx = typedArray;
            this.zzevu.zzevy = builder.zzadl();
            if (this.zzevu.zzevy == 0.0f) {
                this.zzevu.zzevy = typedArray2.getDimension(R.styleable.CastIntroOverlay_castFocusRadius, 0.0f);
            }
        } else {
            this.zzevu = null;
        }
        LayoutInflater.from((Context)this.mActivity).inflate(R.layout.cast_intro_overlay, (ViewGroup)this);
        this.zzevt = builder.zzadh();
        if (this.zzevt == 0) {
            this.zzevt = typedArray2.getColor(R.styleable.CastIntroOverlay_castBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        }
        TextView textView = (TextView)this.findViewById(R.id.textTitle);
        if (!TextUtils.isEmpty((CharSequence)builder.zzadj())) {
            textView.setText((CharSequence)builder.zzadj());
            int n2 = typedArray2.getResourceId(R.styleable.CastIntroOverlay_castTitleTextAppearance, 0);
            if (n2 != 0) {
                textView.setTextAppearance((Context)this.mActivity, n2);
            }
        }
        typedArray = typedArray2;
        object = builder.zzadk();
        zzazh zzazh2 = this;
        Object object2 = object;
        if (TextUtils.isEmpty((CharSequence)object)) {
            object2 = typedArray.getString(R.styleable.CastIntroOverlay_castButtonText);
        }
        int n3 = typedArray.getColor(R.styleable.CastIntroOverlay_castButtonBackgroundColor, Color.argb((int)0, (int)0, (int)0, (int)0));
        Button button = (Button)zzazh2.findViewById(R.id.button);
        button.setText((CharSequence)object2);
        button.getBackground().setColorFilter(n3, PorterDuff.Mode.MULTIPLY);
        int n4 = typedArray.getResourceId(R.styleable.CastIntroOverlay_castButtonTextAppearance, 0);
        if (n4 != 0) {
            button.setTextAppearance((Context)zzazh2.mActivity, n4);
        }
        button.setOnClickListener((View.OnClickListener)new zzazi(zzazh2));
        typedArray2.recycle();
        this.setFitsSystemWindows(true);
    }

    @Override
    public final void show() {
        if (this.mActivity == null) {
            return;
        }
        if (zzazd.zzby((Context)this.mActivity)) {
            return;
        }
        if (this.zzevo && IntroductoryOverlay.zza.zzbw((Context)this.mActivity)) {
            this.mActivity = null;
            this.zzeuz = null;
            return;
        }
        if (!this.zzevq) {
            this.zzevq = true;
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).addView((View)this);
        }
    }

    @Override
    public final void remove() {
        if (this.mActivity != null) {
            ((ViewGroup)this.mActivity.getWindow().getDecorView()).removeView((View)this);
            this.mActivity = null;
        }
        this.zzeuz = null;
    }

    protected final void dispatchDraw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        canvas2.drawColor(this.zzevt);
        if (this.zzevu != null) {
            canvas2.drawCircle((float)this.zzevu.x, (float)this.zzevu.y, this.zzevu.zzevy, this.zzevu.zzevx);
        }
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        bitmap.recycle();
        super.dispatchDraw(canvas);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        return true;
    }

    protected final void onDetachedFromWindow() {
        if (this.mActivity != null) {
            this.mActivity = null;
        }
        super.onDetachedFromWindow();
    }

    private final void zzadr() {
        IntroductoryOverlay.zza.zzbv((Context)this.mActivity);
        if (this.zzeuz != null) {
            this.zzeuz.onOverlayDismissed();
            this.zzeuz = null;
        }
        this.remove();
    }

    static /* synthetic */ void zza(zzazh zzazh2) {
        zzazh2.zzadr();
    }
}

