/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.media.ImageHints;
import com.google.android.gms.cast.framework.media.ImagePicker;
import com.google.android.gms.cast.framework.media.MediaUtils;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.uicontroller.UIController;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.internal.zzazn;
import com.google.android.gms.internal.zzbaf;

public final class zzbae
extends UIController {
    private final ImageView zzfbo;
    private final ImageHints zzfao;
    private final Bitmap zzfbp;
    private final ImagePicker zzext;
    private final zzazn zzfbq;

    public zzbae(ImageView imageView, Context context, @NonNull ImageHints imageHints, int n) {
        this.zzfbo = imageView;
        this.zzfao = imageHints;
        this.zzfbp = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
        CastMediaOptions castMediaOptions = CastContext.getSharedInstance(context).getCastOptions().getCastMediaOptions();
        this.zzext = castMediaOptions != null ? castMediaOptions.getImagePicker() : null;
        this.zzfbq = new zzazn(context.getApplicationContext());
    }

    @Override
    public final void onSessionConnected(CastSession castSession) {
        super.onSessionConnected(castSession);
        this.zzfbq.zza(new zzbaf(this));
        this.zzfbo.setImageBitmap(this.zzfbp);
        this.zzaer();
    }

    @Override
    public final void onSessionEnded() {
        this.zzfbq.clear();
        this.zzfbo.setImageBitmap(this.zzfbp);
        super.onSessionEnded();
    }

    @Override
    public final void onMediaStatusUpdated() {
        this.zzaer();
    }

    private final void zzaer() {
        WebImage webImage;
        Uri uri;
        MediaInfo mediaInfo;
        RemoteMediaClient remoteMediaClient = this.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            this.zzfbo.setImageBitmap(this.zzfbp);
            return;
        }
        MediaQueueItem mediaQueueItem = remoteMediaClient.getPreloadedItem();
        zzbae zzbae2 = this;
        if ((mediaQueueItem == null ? null : ((mediaInfo = mediaQueueItem.getMedia()) == null ? null : (uri = zzbae2.zzext != null && (webImage = zzbae2.zzext.onPickImage(mediaInfo.getMetadata(), zzbae2.zzfao)) != null && webImage.getUrl() != null ? webImage.getUrl() : MediaUtils.getImageUri(mediaInfo, 0)))) == null) {
            this.zzfbo.setImageBitmap(this.zzfbp);
            return;
        }
        this.zzfbq.zzl(uri);
    }

    static /* synthetic */ ImageView zza(zzbae zzbae2) {
        return zzbae2.zzfbo;
    }
}

