/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.AppVisibilityListener;
import com.google.android.gms.cast.framework.CastButtonFactory;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.CastStateListener;
import com.google.android.gms.cast.framework.MediaNotificationManager;
import com.google.android.gms.cast.framework.OptionsProvider;
import com.google.android.gms.cast.framework.PrecacheManager;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.SessionProvider;
import com.google.android.gms.cast.framework.zza;
import com.google.android.gms.cast.framework.zze;
import com.google.android.gms.cast.framework.zzj;
import com.google.android.gms.cast.framework.zzp;
import com.google.android.gms.cast.framework.zzv;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbaf;
import com.google.android.gms.internal.zzbaw;
import com.google.android.gms.internal.zzbdj;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbih;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CastContext {
    private static final zzbei zza = new zzbei("CastContext");
    public static final String OPTIONS_PROVIDER_CLASS_NAME_KEY = "com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME";
    private static CastContext zzb;
    private final Context zzc;
    private final zzj zzd;
    private final SessionManager zze;
    private final zze zzf;
    private final PrecacheManager zzg;
    private final MediaNotificationManager zzh;
    private final CastOptions zzi;
    private zzbaw zzj;
    private zzbaf zzk;
    private final List<SessionProvider> zzl;

    public static CastContext getSharedInstance(@NonNull Context context) throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (zzb == null) {
            OptionsProvider optionsProvider = CastContext.zzb(context.getApplicationContext());
            zzb = new CastContext(context, optionsProvider.getCastOptions(context.getApplicationContext()), optionsProvider.getAdditionalSessionProviders(context.getApplicationContext()));
        }
        return zzb;
    }

    @Hide
    @Nullable
    public static CastContext zza(@NonNull Context context) throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        try {
            return CastContext.getSharedInstance(context);
        }
        catch (RuntimeException runtimeException) {
            zza.zzd("Failed to load module from Google Play services. Cast will not work properly. Might due to outdated Google Play services. Ignoring this failure silently.", new Object[]{runtimeException});
            return null;
        }
    }

    private static OptionsProvider zzb(Context context) throws IllegalStateException {
        try {
            String string;
            Bundle bundle = zzbih.zza((Context)context).zza((String)context.getPackageName(), (int)128).metaData;
            if (bundle == null) {
                zza.zzd("Bundle is null", new Object[0]);
            }
            if ((string = bundle.getString(OPTIONS_PROVIDER_CLASS_NAME_KEY)) == null) {
                throw new IllegalStateException("The fully qualified name of the implementation of OptionsProvider must be provided as a metadata in the AndroidManifest.xml with key com.google.android.gms.cast.framework.OPTIONS_PROVIDER_CLASS_NAME.");
            }
            return (OptionsProvider)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (PackageManager.NameNotFoundException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException throwable) {
            throw new IllegalStateException("Failed to initialize CastContext.", throwable);
        }
    }

    private CastContext(Context context, CastOptions castOptions, List<SessionProvider> list) {
        PrecacheManager precacheManager;
        this.zzc = context.getApplicationContext();
        this.zzi = castOptions;
        this.zzj = new zzbaw(MediaRouter.getInstance((Context)this.zzc));
        this.zzl = list;
        this.zzd();
        Map<String, IBinder> map = this.zzc();
        this.zzd = zzbae.zza(this.zzc, castOptions, this.zzj, map);
        zzp zzp2 = null;
        try {
            zzp2 = this.zzd.zzd();
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getDiscoveryManagerImpl", zzj.class.getSimpleName()});
        }
        this.zzf = zzp2 == null ? null : new zze(zzp2);
        zzv zzv2 = null;
        try {
            zzv2 = this.zzd.zzc();
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionManagerImpl", zzj.class.getSimpleName()});
        }
        this.zze = zzv2 == null ? null : new SessionManager(zzv2, this.zzc);
        this.zzh = new MediaNotificationManager(this.zze);
        if (this.zze == null) {
            precacheManager = null;
        } else {
            Context context2 = this.zzc;
            PrecacheManager precacheManager2 = new PrecacheManager(this.zzi, this.zze, new zzbdj(context2));
            precacheManager = precacheManager2;
        }
        this.zzg = precacheManager;
    }

    private final Map<String, IBinder> zzc() {
        HashMap<String, IBinder> hashMap = new HashMap<String, IBinder>();
        if (this.zzk != null) {
            hashMap.put(this.zzk.getCategory(), this.zzk.zza());
        }
        if (this.zzl != null) {
            for (SessionProvider sessionProvider : this.zzl) {
                zzbq.zza((Object)sessionProvider, (Object)"Additional SessionProvider must not be null.");
                String string2 = zzbq.zza((String)sessionProvider.getCategory(), (Object)"Category for SessionProvider must not be null or empty string.");
                zzbq.zzb((!hashMap.containsKey(string2) ? 1 : 0) != 0, (Object)String.format("SessionProvider for category %s already added", string2));
                hashMap.put(string2, sessionProvider.zza());
            }
        }
        return hashMap;
    }

    private final void zzd() {
        if (!TextUtils.isEmpty((CharSequence)this.zzi.getReceiverApplicationId())) {
            this.zzk = new zzbaf(this.zzc, this.zzi, this.zzj);
            return;
        }
        this.zzk = null;
    }

    public final CastOptions getCastOptions() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzi;
    }

    public final SessionManager getSessionManager() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zze;
    }

    public final MediaRouteSelector getMergedSelector() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        try {
            return MediaRouteSelector.fromBundle((Bundle)this.zzd.zza());
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getMergedSelectorAsBundle", zzj.class.getSimpleName()});
            return null;
        }
    }

    public final int getCastState() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zze.zza();
    }

    public final PrecacheManager getPrecacheManager() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzg;
    }

    public final boolean isAppVisible() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        try {
            return this.zzd.zzb();
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isApplicationVisible", zzj.class.getSimpleName()});
            return false;
        }
    }

    public final MediaNotificationManager getMediaNotificationManager() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzh;
    }

    public final void addAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException, NullPointerException {
        zzbq.zzb((String)"Must be called from the main thread.");
        zzbq.zza((Object)appVisibilityListener);
        try {
            this.zzd.zza(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void removeAppVisibilityListener(AppVisibilityListener appVisibilityListener) throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (appVisibilityListener == null) {
            return;
        }
        try {
            this.zzd.zzb(new zza(appVisibilityListener));
            return;
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"addVisibilityChangeListener", zzj.class.getSimpleName()});
            return;
        }
    }

    public final void addCastStateListener(CastStateListener castStateListener) throws IllegalStateException, NullPointerException {
        zzbq.zzb((String)"Must be called from the main thread.");
        zzbq.zza((Object)castStateListener);
        this.zze.zza(castStateListener);
    }

    public final void removeCastStateListener(CastStateListener castStateListener) throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (castStateListener == null) {
            return;
        }
        this.zze.zzb(castStateListener);
    }

    public final void setReceiverApplicationId(String string2) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (TextUtils.equals((CharSequence)string2, (CharSequence)this.zzi.getReceiverApplicationId())) {
            return;
        }
        this.zzi.zza(string2);
        this.zzd();
        Map<String, IBinder> map = this.zzc();
        try {
            this.zzd.zza(string2, map);
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"setReceiverApplicationId", zzj.class.getSimpleName()});
        }
        CastButtonFactory.zza(this.zzc);
    }

    @Hide
    public final zze zza() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzf;
    }

    public final boolean onDispatchVolumeKeyEventBeforeJellyBean(KeyEvent keyEvent) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (zzs.zzb()) {
            return false;
        }
        CastSession castSession = this.zze.getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return false;
        }
        double d = this.getCastOptions().getVolumeDeltaBeforeIceCreamSandwich();
        boolean bl = keyEvent.getAction() == 0;
        switch (keyEvent.getKeyCode()) {
            case 24: {
                CastContext.zza(castSession, d, bl);
                return true;
            }
            case 25: {
                CastContext.zza(castSession, -d, bl);
                return true;
            }
        }
        return false;
    }

    private static boolean zza(CastSession castSession, double d, boolean bl) {
        if (bl) {
            try {
                double d2;
                double d3 = castSession.getVolume() + d;
                if (d2 > 1.0) {
                    d3 = 1.0;
                }
                castSession.setVolume(d3);
            }
            catch (IOException | IllegalStateException exception) {
                zza.zzd("Unable to call CastSession.setVolume(double).", new Object[]{exception});
            }
        }
        return true;
    }

    @Hide
    public final IObjectWrapper zzb() {
        try {
            return this.zzd.zze();
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedThis", zzj.class.getSimpleName()});
            return null;
        }
    }
}

