/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zzbgl {
    @Hide
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private String zza;
    private final List<String> zzb;
    private final boolean zzc;
    private final LaunchOptions zzd;
    private final boolean zze;
    private final CastMediaOptions zzf;
    private final boolean zzg;
    private final double zzh;

    CastOptions(String string2, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.zza = TextUtils.isEmpty((CharSequence)string2) ? "" : string2;
        int n = list == null ? 0 : list.size();
        this.zzb = new ArrayList<String>(n);
        if (n > 0) {
            this.zzb.addAll(list);
        }
        this.zzc = bl;
        this.zzd = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zze = bl2;
        this.zzf = castMediaOptions;
        this.zzg = bl3;
        this.zzh = d;
    }

    public String getReceiverApplicationId() {
        return this.zza;
    }

    @Hide
    public final void zza(String string2) {
        this.zza = string2;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzb);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzc;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzd;
    }

    public boolean getResumeSavedSession() {
        return this.zze;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzf;
    }

    public boolean getEnableReconnectionService() {
        return this.zzg;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzh;
    }

    @Hide
    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CastOptions castOptions = this;
        int n2 = zzbgo.zza((Parcel)parcel2);
        zzbgo.zza((Parcel)parcel2, (int)2, (String)castOptions.getReceiverApplicationId(), (boolean)false);
        zzbgo.zzb((Parcel)parcel2, (int)3, castOptions.getSupportedNamespaces(), (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)4, (boolean)castOptions.getStopReceiverApplicationWhenEndingSession());
        zzbgo.zza((Parcel)parcel2, (int)5, (Parcelable)castOptions.getLaunchOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)6, (boolean)castOptions.getResumeSavedSession());
        zzbgo.zza((Parcel)parcel2, (int)7, (Parcelable)castOptions.getCastMediaOptions(), (int)n, (boolean)false);
        zzbgo.zza((Parcel)parcel2, (int)8, (boolean)castOptions.getEnableReconnectionService());
        zzbgo.zza((Parcel)parcel2, (int)9, (double)castOptions.getVolumeDeltaBeforeIceCreamSandwich());
        zzbgo.zza((Parcel)parcel2, (int)n2);
    }

    public static final class Builder {
        private String zza;
        private List<String> zzb = new ArrayList<String>();
        private boolean zzc;
        private LaunchOptions zzd = new LaunchOptions();
        private boolean zze = true;
        private CastMediaOptions zzf = new CastMediaOptions.Builder().build();
        private boolean zzg = true;
        private double zzh = 0.05f;

        public Builder() {
        }

        public final Builder setReceiverApplicationId(String string2) {
            this.zza = string2;
            return this;
        }

        public final Builder setSupportedNamespaces(List<String> list) {
            this.zzb = list;
            return this;
        }

        public final Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzc = bl;
            return this;
        }

        public final Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzd = launchOptions;
            return this;
        }

        public final Builder setResumeSavedSession(boolean bl) {
            this.zze = bl;
            return this;
        }

        public final Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzf = castMediaOptions;
            return this;
        }

        public final Builder setEnableReconnectionService(boolean bl) {
            this.zzg = bl;
            return this;
        }

        public final Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzh = d;
            return this;
        }

        public final CastOptions build() {
            return new CastOptions(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, this.zzh);
        }
    }
}

