/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.CastOptions;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.zzi;
import com.google.android.gms.cast.framework.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbae;
import com.google.android.gms.internal.zzbag;
import com.google.android.gms.internal.zzbbi;
import com.google.android.gms.internal.zzbei;
import com.google.android.gms.internal.zzbej;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CastSession
extends Session {
    private static final zzbei zza = new zzbei("CastSession");
    private final Context zzb;
    private final Set<Cast.Listener> zzc = new HashSet<Cast.Listener>();
    private final zzl zzd;
    private final CastOptions zze;
    private final Cast.CastApi zzf;
    private final zzbag zzg;
    private final zzbbi zzh;
    private GoogleApiClient zzi;
    private RemoteMediaClient zzj;
    private CastDevice zzk;
    private Cast.ApplicationConnectionResult zzl;

    @Hide
    public CastSession(Context context, String string2, String string3, CastOptions castOptions, Cast.CastApi castApi, zzbag zzbag2, zzbbi zzbbi2) {
        super(context, string2, string3);
        this.zzb = context.getApplicationContext();
        this.zze = castOptions;
        this.zzf = castApi;
        this.zzg = zzbag2;
        this.zzh = zzbbi2;
        this.zzd = zzbae.zza(context, castOptions, this.zzc(), new zzb(this, null));
    }

    @Override
    protected void onStarting(Bundle bundle) {
        this.zzk = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void onResuming(Bundle bundle) {
        this.zzk = CastDevice.getFromBundle((Bundle)bundle);
    }

    @Override
    protected void start(Bundle bundle) {
        this.zza(bundle);
    }

    @Override
    protected void resume(Bundle bundle) {
        this.zza(bundle);
    }

    @Override
    protected void end(boolean bl) {
        try {
            this.zzd.zza(bl, 0);
        }
        catch (RemoteException remoteException) {
            zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"disconnectFromDevice", zzl.class.getSimpleName()});
        }
        this.notifySessionEnded(0);
    }

    public RemoteMediaClient getRemoteMediaClient() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzj;
    }

    public CastDevice getCastDevice() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzk;
    }

    public void requestStatus() throws IOException, IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            this.zzf.requestStatus(this.zzi);
        }
    }

    public int getActiveInputState() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.getActiveInputState(this.zzi);
        }
        return -1;
    }

    public int getStandbyState() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.getStandbyState(this.zzi);
        }
        return -1;
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.getApplicationMetadata(this.zzi);
        }
        return null;
    }

    public String getApplicationStatus() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.getApplicationStatus(this.zzi);
        }
        return null;
    }

    public void setVolume(double d) throws IOException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            this.zzf.setVolume(this.zzi, d);
        }
    }

    public double getVolume() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.getVolume(this.zzi);
        }
        return 0.0;
    }

    @Hide
    public final zzbbi zza() {
        return this.zzh;
    }

    public void setMute(boolean bl) throws IOException, IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            this.zzf.setMute(this.zzi, bl);
        }
    }

    public boolean isMute() throws IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.isMute(this.zzi);
        }
        return false;
    }

    public Cast.ApplicationConnectionResult getApplicationConnectionResult() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzl;
    }

    public void setMessageReceivedCallbacks(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IOException, IllegalStateException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            this.zzf.setMessageReceivedCallbacks(this.zzi, string2, messageReceivedCallback);
        }
    }

    public void removeMessageReceivedCallbacks(String string2) throws IOException, IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            this.zzf.removeMessageReceivedCallbacks(this.zzi, string2);
        }
    }

    public PendingResult<Status> sendMessage(String string2, String string3) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzi != null) {
            return this.zzf.sendMessage(this.zzi, string2, string3);
        }
        return null;
    }

    public void addCastListener(Cast.Listener listener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzc.add(listener);
        }
    }

    public void removeCastListener(Cast.Listener listener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzc.remove(listener);
        }
    }

    private final void zza(Bundle bundle) {
        zzd zzd2;
        this.zzk = CastDevice.getFromBundle((Bundle)bundle);
        if (this.zzk == null) {
            if (this.isResuming()) {
                this.notifyFailedToResumeSession(8);
                return;
            }
            this.notifyFailedToStartSession(8);
            return;
        }
        if (this.zzi != null) {
            this.zzi.disconnect();
            this.zzi = null;
        }
        zza.zza("Acquiring a connection to Google Play Services for %s", new Object[]{this.zzk});
        zzd zzd3 = zzd2 = new zzd(this, null);
        zzd zzd4 = zzd2;
        zzc zzc2 = new zzc(this, null);
        CastOptions castOptions = this.zze;
        CastDevice castDevice = this.zzk;
        Context context = this.zzb;
        Bundle bundle2 = new Bundle();
        bundle2.putBoolean("com.google.android.gms.cast.EXTRA_CAST_FRAMEWORK_NOTIFICATION_ENABLED", castOptions != null && castOptions.getCastMediaOptions() != null && castOptions.getCastMediaOptions().getNotificationOptions() != null);
        this.zzi = new GoogleApiClient.Builder(context).addApi(Cast.API, (Api.ApiOptions.HasOptions)new Cast.CastOptions.Builder(castDevice, (Cast.Listener)zzc2).zza(bundle2).build()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)zzd4).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)zzd3).build();
        this.zzi.connect();
    }

    private final void zza(int n) {
        this.zzh.zza(n);
        if (this.zzi != null) {
            this.zzi.disconnect();
            this.zzi = null;
        }
        this.zzk = null;
        if (this.zzj != null) {
            this.zzj.zza((GoogleApiClient)null);
            this.zzj = null;
        }
        this.zzl = null;
    }

    @Override
    public long getSessionRemainingTimeMs() {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (this.zzj == null) {
            return 0L;
        }
        return this.zzj.getStreamDuration() - this.zzj.getApproximateStreamPosition();
    }

    final class zzb
    extends zzi {
        private /* synthetic */ CastSession zza;

        private zzb(CastSession castSession) {
            this.zza = castSession;
        }

        @Override
        public final int zza() {
            return 12210278;
        }

        @Override
        public final void zza(String string2, String string3) {
            if (this.zza.zzi != null) {
                this.zza.zzf.joinApplication(this.zza.zzi, string2, string3).setResultCallback((ResultCallback)new zza(this.zza, "joinApplication"));
            }
        }

        @Override
        public final void zza(String string2, LaunchOptions launchOptions) {
            if (this.zza.zzi != null) {
                this.zza.zzf.launchApplication(this.zza.zzi, string2, launchOptions).setResultCallback((ResultCallback)new zza(this.zza, "launchApplication"));
            }
        }

        @Override
        public final void zza(String string2) {
            if (this.zza.zzi != null) {
                this.zza.zzf.stopApplication(this.zza.zzi, string2);
            }
        }

        @Override
        public final void zza(int n) {
            this.zza.zza(n);
        }

        /* synthetic */ zzb(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zza
    implements ResultCallback<Cast.ApplicationConnectionResult> {
        private String zza;
        private /* synthetic */ CastSession zzb;

        zza(CastSession castSession, String string2) {
            this.zzb = castSession;
            this.zza = string2;
        }

        public final /* synthetic */ void onResult(@NonNull Result result) {
            Cast.ApplicationConnectionResult applicationConnectionResult = (Cast.ApplicationConnectionResult)result;
            zza zza2 = this;
            zza2.zzb.zzl = applicationConnectionResult;
            try {
                if (applicationConnectionResult.getStatus().isSuccess()) {
                    zza.zza("%s() -> success result", new Object[]{zza2.zza});
                    zza2.zzb.zzj = new RemoteMediaClient(new zzbej(null, com.google.android.gms.common.util.zzi.zzd()), zza2.zzb.zzf);
                    try {
                        zza2.zzb.zzj.zza(zza2.zzb.zzi);
                        zza2.zzb.zzj.zza();
                        zza2.zzb.zzj.requestStatus();
                        zza2.zzb.zzh.zza(zza2.zzb.zzj, zza2.zzb.getCastDevice());
                    }
                    catch (IOException iOException) {
                        zza.zzc((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        zza2.zzb.zzj = null;
                    }
                    zza2.zzb.zzd.zza(applicationConnectionResult.getApplicationMetadata(), applicationConnectionResult.getApplicationStatus(), applicationConnectionResult.getSessionId(), applicationConnectionResult.getWasLaunched());
                    return;
                }
                zza.zza("%s() -> failure result", new Object[]{zza2.zza});
                zza2.zzb.zzd.zzb(applicationConnectionResult.getStatus().getStatusCode());
                return;
            }
            catch (RemoteException remoteException) {
                zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"methods", zzl.class.getSimpleName()});
                return;
            }
        }
    }

    final class zzc
    extends Cast.Listener {
        private /* synthetic */ CastSession zza;

        private zzc(CastSession castSession) {
            this.zza = castSession;
        }

        public final void onApplicationDisconnected(int n) {
            this.zza.zza(n);
            this.zza.notifySessionEnded(n);
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationDisconnected(n);
            }
        }

        public final void onApplicationStatusChanged() {
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationStatusChanged();
            }
        }

        public final void onApplicationMetadataChanged(ApplicationMetadata applicationMetadata) {
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onApplicationMetadataChanged(applicationMetadata);
            }
        }

        public final void onActiveInputStateChanged(int n) {
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onActiveInputStateChanged(n);
            }
        }

        public final void onStandbyStateChanged(int n) {
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onStandbyStateChanged(n);
            }
        }

        public final void onVolumeChanged() {
            Iterator iterator = new HashSet(this.zza.zzc).iterator();
            while (iterator.hasNext()) {
                ((Cast.Listener)iterator.next()).onVolumeChanged();
            }
        }

        /* synthetic */ zzc(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }

    final class zzd
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private /* synthetic */ CastSession zza;

        private zzd(CastSession castSession) {
            this.zza = castSession;
        }

        public final void onConnected(Bundle bundle) {
            try {
                if (this.zza.zzj != null) {
                    try {
                        this.zza.zzj.zza();
                        this.zza.zzj.requestStatus();
                    }
                    catch (IOException iOException) {
                        zza.zzc((Throwable)iOException, "Exception when setting GoogleApiClient.", new Object[0]);
                        this.zza.zzj = null;
                    }
                }
                this.zza.zzd.zza(bundle);
                return;
            }
            catch (RemoteException remoteException) {
                zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnected", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionSuspended(int n) {
            try {
                this.zza.zzd.zza(n);
                return;
            }
            catch (RemoteException remoteException) {
                zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionSuspended", zzl.class.getSimpleName()});
                return;
            }
        }

        public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            try {
                this.zza.zzd.zza(connectionResult);
                return;
            }
            catch (RemoteException remoteException) {
                zza.zza((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"onConnectionFailed", zzl.class.getSimpleName()});
                return;
            }
        }

        /* synthetic */ zzd(CastSession castSession, com.google.android.gms.cast.framework.zzc zzc2) {
            this(castSession);
        }
    }
}

