/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Keep;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzdny;
import com.google.android.gms.internal.zzdoa;

@Hide
class OuterHighlightDrawable
extends Drawable {
    private final int zza;
    private final int zzb;
    private final int zzc;
    private final Rect zzd = new Rect();
    private final Rect zze = new Rect();
    private final Paint zzf = new Paint();
    private float zzg;
    private float zzh = 1.0f;
    private float zzi;
    private float zzj;
    private float zzk = 0.0f;
    private float zzl = 0.0f;
    private int zzm = 244;

    public OuterHighlightDrawable(Context context) {
        if (zzs.zzg()) {
            Context context2 = context;
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843827, typedValue, true);
            this.zza(ColorUtils.setAlphaComponent((int)typedValue.data, (int)244));
        } else {
            this.zza(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzf.setAntiAlias(true);
        this.zzf.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zza = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzb = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzc = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.zzi + this.zzk, this.zzj + this.zzl, this.zzg * this.zzh, this.zzf);
    }

    public void setAlpha(int n) {
        this.zzf.setAlpha(n);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.zzf.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzf.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @ColorInt
    public final int zza() {
        return this.zzf.getColor();
    }

    public final void zza(@ColorInt int n) {
        this.zzf.setColor(n);
        this.zzm = this.zzf.getAlpha();
        this.invalidateSelf();
    }

    public final void zza(Rect rect, Rect rect2) {
        this.zzd.set(rect);
        this.zze.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        if (Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2) < (float)this.zza) {
            this.zzi = f;
            this.zzj = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.zzi = bl ? rect2.exactCenterX() + (float)this.zzb : rect2.exactCenterX() - (float)this.zzb;
            this.zzj = rect2.exactCenterY();
        }
        this.zzg = (float)this.zzc + Math.max(OuterHighlightDrawable.zza(this.zzi, this.zzj, rect), OuterHighlightDrawable.zza(this.zzi, this.zzj, rect2));
        this.invalidateSelf();
    }

    @Keep
    public void setScale(float f) {
        this.zzh = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationX(float f) {
        this.zzk = f;
        this.invalidateSelf();
    }

    @Keep
    public void setTranslationY(float f) {
        this.zzl = f;
        this.invalidateSelf();
    }

    public final float zzb() {
        return this.zzi;
    }

    public final float zzc() {
        return this.zzj;
    }

    public final boolean zza(float f, float f2) {
        return zzdoa.zza(f, f2, this.zzi, this.zzj) < this.zzg;
    }

    private static float zza(float f, float f2, Rect rect) {
        float f3;
        float f4 = rect.bottom;
        float f5 = rect.right;
        float f6 = rect.top;
        float f7 = rect.left;
        float f8 = f2;
        float f9 = f;
        float f10 = zzdoa.zza(f9, f8, f7, f4);
        float f11 = zzdoa.zza(f9, f8, f5, f4);
        float f12 = zzdoa.zza(f9, f8, f5, f6);
        float f13 = zzdoa.zza(f9, f8, f7, f6);
        return (float)Math.ceil(f3 > f12 && f13 > f11 && f13 > f10 ? f13 : (f12 > f11 && f12 > f10 ? f12 : (f11 > f10 ? f11 : f10)));
    }

    public final Animator zzb(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzm});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzdny.zza());
        return objectAnimator.setDuration(350L);
    }
}

