/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.Session;
import com.google.android.gms.cast.framework.SessionManager;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;

public class MediaIntentReceiver
extends BroadcastReceiver {
    public static final String ACTION_TOGGLE_PLAYBACK = "com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK";
    public static final String ACTION_SKIP_NEXT = "com.google.android.gms.cast.framework.action.SKIP_NEXT";
    public static final String ACTION_SKIP_PREV = "com.google.android.gms.cast.framework.action.SKIP_PREV";
    public static final String ACTION_FORWARD = "com.google.android.gms.cast.framework.action.FORWARD";
    public static final String ACTION_REWIND = "com.google.android.gms.cast.framework.action.REWIND";
    public static final String ACTION_STOP_CASTING = "com.google.android.gms.cast.framework.action.STOP_CASTING";
    public static final String ACTION_DISCONNECT = "com.google.android.gms.cast.framework.action.DISCONNECT";
    public static final String EXTRA_SKIP_STEP_MS = "googlecast-extra_skip_step_ms";

    public MediaIntentReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getAction();
        if (string2 == null) {
            return;
        }
        SessionManager sessionManager = CastContext.getSharedInstance(context).getSessionManager();
        switch (string2) {
            case "com.google.android.gms.cast.framework.action.TOGGLE_PLAYBACK": {
                this.onReceiveActionTogglePlayback(sessionManager.getCurrentSession());
                return;
            }
            case "com.google.android.gms.cast.framework.action.SKIP_NEXT": {
                this.onReceiveActionSkipNext(sessionManager.getCurrentSession());
                return;
            }
            case "com.google.android.gms.cast.framework.action.SKIP_PREV": {
                this.onReceiveActionSkipPrev(sessionManager.getCurrentSession());
                return;
            }
            case "com.google.android.gms.cast.framework.action.FORWARD": {
                long l = intent.getLongExtra(EXTRA_SKIP_STEP_MS, 0L);
                this.onReceiveActionForward(sessionManager.getCurrentSession(), l);
                return;
            }
            case "com.google.android.gms.cast.framework.action.REWIND": {
                long l = intent.getLongExtra(EXTRA_SKIP_STEP_MS, 0L);
                this.onReceiveActionRewind(sessionManager.getCurrentSession(), l);
                return;
            }
            case "com.google.android.gms.cast.framework.action.STOP_CASTING": {
                sessionManager.endCurrentSession(true);
                return;
            }
            case "com.google.android.gms.cast.framework.action.DISCONNECT": {
                sessionManager.endCurrentSession(false);
                return;
            }
            case "android.intent.action.MEDIA_BUTTON": {
                this.onReceiveActionMediaButton(sessionManager.getCurrentSession(), intent);
                return;
            }
        }
        this.onReceiveOtherAction(context, string2, intent);
    }

    protected void onReceiveActionTogglePlayback(Session session) {
        if (session instanceof CastSession) {
            MediaIntentReceiver.zza((CastSession)session);
        }
    }

    protected void onReceiveActionSkipNext(Session session) {
        if (session instanceof CastSession) {
            RemoteMediaClient remoteMediaClient = MediaIntentReceiver.zzb((CastSession)session);
            if (remoteMediaClient == null || remoteMediaClient.isPlayingAd()) {
                return;
            }
            remoteMediaClient.queueNext(null);
        }
    }

    protected void onReceiveActionSkipPrev(Session session) {
        if (session instanceof CastSession) {
            RemoteMediaClient remoteMediaClient = MediaIntentReceiver.zzb((CastSession)session);
            if (remoteMediaClient == null || remoteMediaClient.isPlayingAd()) {
                return;
            }
            remoteMediaClient.queuePrev(null);
        }
    }

    protected void onReceiveActionForward(Session session, long l) {
        if (session instanceof CastSession) {
            MediaIntentReceiver.zza((CastSession)session, l);
        }
    }

    protected void onReceiveActionRewind(Session session, long l) {
        if (session instanceof CastSession) {
            MediaIntentReceiver.zza((CastSession)session, -l);
        }
    }

    protected void onReceiveActionMediaButton(Session session, Intent intent) {
        if (session instanceof CastSession) {
            if (!intent.hasExtra("android.intent.extra.KEY_EVENT")) {
                return;
            }
            KeyEvent keyEvent = (KeyEvent)intent.getExtras().get("android.intent.extra.KEY_EVENT");
            if (keyEvent == null || keyEvent.getAction() != 0) {
                return;
            }
            if (keyEvent.getKeyCode() == 85) {
                MediaIntentReceiver.zza((CastSession)session);
            }
        }
    }

    @Deprecated
    protected void onReceiveOtherAction(String string2, Intent intent) {
        this.onReceiveOtherAction(null, string2, intent);
    }

    protected void onReceiveOtherAction(Context context, String string2, Intent intent) {
    }

    private static void zza(CastSession castSession) {
        RemoteMediaClient remoteMediaClient = MediaIntentReceiver.zzb(castSession);
        if (remoteMediaClient == null) {
            return;
        }
        remoteMediaClient.togglePlayback();
    }

    private static void zza(CastSession castSession, long l) {
        if (l == 0L) {
            return;
        }
        RemoteMediaClient remoteMediaClient = MediaIntentReceiver.zzb(castSession);
        if (remoteMediaClient == null || remoteMediaClient.isLiveStream() || remoteMediaClient.isPlayingAd()) {
            return;
        }
        remoteMediaClient.seek(remoteMediaClient.getApproximateStreamPosition() + l);
    }

    private static RemoteMediaClient zzb(CastSession castSession) {
        if (castSession == null || !castSession.isConnected()) {
            return null;
        }
        return castSession.getRemoteMediaClient();
    }
}

