/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaLoadOptions;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.framework.media.zzaa;
import com.google.android.gms.cast.framework.media.zzab;
import com.google.android.gms.cast.framework.media.zzac;
import com.google.android.gms.cast.framework.media.zzad;
import com.google.android.gms.cast.framework.media.zzae;
import com.google.android.gms.cast.framework.media.zzaf;
import com.google.android.gms.cast.framework.media.zzag;
import com.google.android.gms.cast.framework.media.zzah;
import com.google.android.gms.cast.framework.media.zzai;
import com.google.android.gms.cast.framework.media.zzaj;
import com.google.android.gms.cast.framework.media.zzak;
import com.google.android.gms.cast.framework.media.zzal;
import com.google.android.gms.cast.framework.media.zzam;
import com.google.android.gms.cast.framework.media.zzan;
import com.google.android.gms.cast.framework.media.zzao;
import com.google.android.gms.cast.framework.media.zzap;
import com.google.android.gms.cast.framework.media.zzaq;
import com.google.android.gms.cast.framework.media.zzn;
import com.google.android.gms.cast.framework.media.zzo;
import com.google.android.gms.cast.framework.media.zzp;
import com.google.android.gms.cast.framework.media.zzq;
import com.google.android.gms.cast.framework.media.zzr;
import com.google.android.gms.cast.framework.media.zzs;
import com.google.android.gms.cast.framework.media.zzt;
import com.google.android.gms.cast.framework.media.zzu;
import com.google.android.gms.cast.framework.media.zzv;
import com.google.android.gms.cast.framework.media.zzw;
import com.google.android.gms.cast.framework.media.zzx;
import com.google.android.gms.cast.framework.media.zzy;
import com.google.android.gms.cast.framework.media.zzz;
import com.google.android.gms.cast.zzbl;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BasePendingResult;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzbdf;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.internal.zzbek;
import com.google.android.gms.internal.zzbem;
import com.google.android.gms.internal.zzben;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object zza;
    private final Handler zzb;
    private final zzbej zzc;
    private final zza zzd;
    private final Cast.CastApi zze;
    private GoogleApiClient zzf;
    private final List<Listener> zzg = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zze> zzh = new ConcurrentHashMap<ProgressListener, zze>();
    private final Map<Long, zze> zzi = new ConcurrentHashMap<Long, zze>();
    private ParseAdsInfoCallback zzj;
    public static final String NAMESPACE = zzbej.zzd;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    @Hide
    public RemoteMediaClient(@NonNull zzbej zzbej2, @NonNull Cast.CastApi castApi) {
        this.zza = new Object();
        this.zzb = new Handler(Looper.getMainLooper());
        this.zzd = new zza();
        this.zze = castApi;
        this.zzc = (zzbej)zzbq.zza((Object)zzbej2);
        this.zzc.zza((zzbek)new zzn(this));
        this.zzc.zza((zzbem)this.zzd);
    }

    @Hide
    public final void zza(GoogleApiClient googleApiClient) {
        if (this.zzf == googleApiClient) {
            return;
        }
        if (this.zzf != null) {
            this.zzc.zzf();
            try {
                this.zze.removeMessageReceivedCallbacks(this.zzf, this.getNamespace());
            }
            catch (IOException iOException) {}
            this.zzd.zza(null);
            this.zzb.removeCallbacksAndMessages(null);
        }
        this.zzf = googleApiClient;
        if (this.zzf != null) {
            this.zzd.zza(this.zzf);
        }
    }

    @Hide
    public final void zza() throws IOException {
        if (this.zzf != null) {
            this.zze.setMessageReceivedCallbacks(this.zzf, this.getNamespace(), (Cast.MessageReceivedCallback)this);
        }
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, new MediaLoadOptions.Builder().build());
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    @Deprecated
    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, long[] lArray, JSONObject jSONObject) {
        MediaLoadOptions mediaLoadOptions = new MediaLoadOptions.Builder().setAutoplay(bl).setPlayPosition(l).setActiveTrackIds(lArray).setCustomData(jSONObject).build();
        return this.load(mediaInfo, mediaLoadOptions);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, MediaLoadOptions mediaLoadOptions) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzy(this, this.zzf, mediaInfo, mediaLoadOptions));
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzaf(this, this.zzf, jSONObject));
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzag(this, this.zzf, jSONObject));
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzah(this, this.zzf, jSONObject));
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzai(this, this.zzf, l, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzaj(this, this.zzf, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzak(this, this.zzf, bl, jSONObject));
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d) {
        return this.setPlaybackRate(d, null);
    }

    public PendingResult<MediaChannelResult> setPlaybackRate(double d, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        if (Double.compare(d, 2.0) > 0 || Double.compare(d, 0.5) < 0) {
            throw new IllegalArgumentException("playbackRate must be between PLAYBACK_RATE_MIN and PLAYBACK_RATE_MAX");
        }
        return this.zza(new zzal(this, this.zzf, d, jSONObject));
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzo(this, this.zzf));
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(long[] lArray) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzp(this, this.zzf, lArray));
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(TextTrackStyle textTrackStyle) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzq(this, this.zzf, textTrackStyle));
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, long l, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzr(this, this.zzf, mediaQueueItemArray, n, n2, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueInsertItems(MediaQueueItem[] mediaQueueItemArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzs(this, this.zzf, mediaQueueItemArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, long l, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzt(this, this.zzf, mediaQueueItem, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(MediaQueueItem[] mediaQueueItemArray, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzu(this, this.zzf, mediaQueueItemArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(int[] nArray, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzv(this, this.zzf, nArray, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueReorderItems(int[] nArray, int n, JSONObject jSONObject) throws IllegalArgumentException {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzw(this, this.zzf, nArray, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queuePrev(JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzx(this, this.zzf, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueNext(JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzz(this, this.zzf, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(int n, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzaa(this, this.zzf, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(int n, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzab(this, this.zzf, n, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, long l, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzac(this, this.zzf, n, l, jSONObject));
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(int n, int n2, JSONObject jSONObject) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzad(this, this.zzf, n, n2, jSONObject));
    }

    @Hide
    public final PendingResult<MediaChannelResult> zza(String string2, List<zzbl> list) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (!this.zzb()) {
            return RemoteMediaClient.zzc();
        }
        return this.zza(new zzae(this, this.zzf, true, string2, null));
    }

    private final int zza(int n) {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            return this.zzc.zza();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            return this.zzc.zzb();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            return this.zzc.zzc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            return this.zzc.zzd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.zza;
        synchronized (object) {
            zzbq.zzb((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        if (mediaStatus == null) {
            return null;
        }
        return mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzbq.zzb((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
            return;
        }
        this.play();
    }

    public boolean hasMediaSession() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzg.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (listener != null) {
            this.zzg.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzbq.zzb((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzh.containsKey(progressListener)) {
            return false;
        }
        zze zze2 = this.zzi.get(l);
        if (zze2 == null) {
            zze2 = new zze(l);
            this.zzi.put(l, zze2);
        }
        zze2.zza(progressListener);
        this.zzh.put(progressListener, zze2);
        if (this.hasMediaSession()) {
            zze2.zzc();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzbq.zzb((String)"Must be called from the main thread.");
        zze zze2 = this.zzh.remove(progressListener);
        if (zze2 != null) {
            zze2.zzb(progressListener);
            if (!zze2.zzb()) {
                this.zzi.remove(zze2.zza());
                zze2.zzd();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzbq.zzb((String)"Must be called from the main thread.");
        this.zzj = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzbq.zzb((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzbq.zzb((String)"Must be called from the main thread.");
        return this.zzc.zzg();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzc.zza(string3);
    }

    private final boolean zzb() {
        return this.zzf != null;
    }

    private static PendingResult<MediaChannelResult> zzc() {
        zzd zzd2 = new zzd();
        zzd2.zza(zzd2.zzb(new Status(17)));
        return zzd2;
    }

    private final zzb zza(zzb zzb2) {
        try {
            this.zzf.zzb((zzm)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.zza((MediaChannelResult)zzb2.zza(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private final void zza(Set<ProgressListener> set) {
        if (this.isBuffering() || this.isPaused()) {
            return;
        }
        HashSet<ProgressListener> hashSet = new HashSet<ProgressListener>(set);
        if (this.isPlaying()) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ProgressListener)iterator.next()).onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
            }
            return;
        }
        if (this.isLoadingNextItem()) {
            MediaQueueItem mediaQueueItem = this.getLoadingItem();
            if (mediaQueueItem != null && mediaQueueItem.getMedia() != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    ((ProgressListener)iterator.next()).onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
            }
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((ProgressListener)iterator.next()).onProgressUpdated(0L, 0L);
        }
    }

    private final void zzd() {
        for (zze zze2 : this.zzi.values()) {
            if (this.hasMediaSession() && !zze2.zze()) {
                zze2.zzc();
            } else if (!this.hasMediaSession() && zze2.zze()) {
                zze2.zzd();
            }
            if (!zze2.zze() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zze2.zzb);
        }
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient) {
        remoteMediaClient.zzd();
    }

    static /* synthetic */ ParseAdsInfoCallback zzc(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzj;
    }

    static /* synthetic */ Object zzd(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zza;
    }

    static /* synthetic */ zzbej zze(RemoteMediaClient remoteMediaClient) {
        return remoteMediaClient.zzc;
    }

    static /* synthetic */ int zza(RemoteMediaClient remoteMediaClient, int n) {
        return remoteMediaClient.zza(n);
    }

    static /* synthetic */ void zza(RemoteMediaClient remoteMediaClient, Set set) {
        remoteMediaClient.zza(set);
    }

    final class zze {
        private final Set<ProgressListener> zzb = new HashSet<ProgressListener>();
        private final long zzc;
        private final Runnable zzd;
        private boolean zze;

        public zze(long l) {
            this.zzc = l;
            this.zzd = new zzaq(this, RemoteMediaClient.this);
        }

        public final long zza() {
            return this.zzc;
        }

        public final void zza(ProgressListener progressListener) {
            this.zzb.add(progressListener);
        }

        public final void zzb(ProgressListener progressListener) {
            this.zzb.remove(progressListener);
        }

        public final boolean zzb() {
            return !this.zzb.isEmpty();
        }

        public final void zzc() {
            RemoteMediaClient.this.zzb.removeCallbacks(this.zzd);
            this.zze = true;
            RemoteMediaClient.this.zzb.postDelayed(this.zzd, this.zzc);
        }

        public final void zzd() {
            RemoteMediaClient.this.zzb.removeCallbacks(this.zzd);
            this.zze = false;
        }

        public final boolean zze() {
            return this.zze;
        }

        static /* synthetic */ long zzb(zze zze2) {
            return zze2.zzc;
        }
    }

    abstract class zzb
    extends zzbdf<MediaChannelResult> {
        zzben zza;
        private final boolean zzb;
        private /* synthetic */ RemoteMediaClient zzd;

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient) {
            this(remoteMediaClient, googleApiClient, false);
        }

        zzb(RemoteMediaClient remoteMediaClient, GoogleApiClient googleApiClient, boolean bl) {
            this.zzd = remoteMediaClient;
            super(googleApiClient);
            this.zzb = bl;
            this.zza = new zzan(this, remoteMediaClient);
        }

        abstract void zza(zzbdp var1);

        protected final /* synthetic */ void zza(Api.zzb zzb2) throws RemoteException {
            zzbdp zzbdp2 = (zzbdp)zzb2;
            zzb zzb3 = this;
            if (!zzb3.zzb) {
                Iterator iterator = zzb3.zzd.zzg.iterator();
                while (iterator.hasNext()) {
                    ((Listener)iterator.next()).onSendingRemoteMediaRequest();
                }
            }
            zzb3.zza(zzbdp2);
        }

        public final /* synthetic */ Result zza(Status status) {
            Status status2 = status;
            zzb zzb2 = this;
            return new zzao(zzb2, status2);
        }
    }

    static final class zzc
    implements MediaChannelResult {
        private final Status zza;
        private final JSONObject zzb;

        zzc(Status status, JSONObject jSONObject) {
            this.zza = status;
            this.zzb = jSONObject;
        }

        public final Status getStatus() {
            return this.zza;
        }

        @Override
        public final JSONObject getCustomData() {
            return this.zzb;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    final class zza
    implements zzbem {
        private GoogleApiClient zzb;
        private long zzc = 0L;

        public final void zza(GoogleApiClient googleApiClient) {
            this.zzb = googleApiClient;
        }

        public final void zza(String string2, String string3, long l, String string4) {
            if (this.zzb == null) {
                throw new IllegalStateException("No GoogleApiClient available");
            }
            RemoteMediaClient.this.zze.sendMessage(this.zzb, string2, string3).setResultCallback((ResultCallback)new zzam(this, l));
        }

        public final long zza() {
            return ++this.zzc;
        }
    }

    static final class zzd
    extends BasePendingResult<MediaChannelResult> {
        zzd() {
            super(null);
        }

        @NonNull
        protected final MediaChannelResult zzb(Status status) {
            return new zzap(this, status);
        }

        @NonNull
        protected final /* synthetic */ Result zza(Status status) {
            return this.zzb(status);
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

