/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TabHost;
import com.google.android.gms.R;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.framework.CastContext;
import com.google.android.gms.cast.framework.CastSession;
import com.google.android.gms.cast.framework.media.RemoteMediaClient;
import com.google.android.gms.cast.framework.media.zzar;
import com.google.android.gms.cast.framework.media.zzas;
import com.google.android.gms.cast.framework.media.zzat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TracksChooserDialogFragment
extends DialogFragment {
    private List<MediaTrack> zza;
    private List<MediaTrack> zzb;
    private long[] zzc;
    private Dialog zzd;

    public TracksChooserDialogFragment() {
    }

    public static TracksChooserDialogFragment newInstance(MediaInfo mediaInfo, long[] lArray) {
        if (mediaInfo == null) {
            return null;
        }
        List list = mediaInfo.getMediaTracks();
        if (list == null) {
            return null;
        }
        ArrayList<MediaTrack> arrayList = TracksChooserDialogFragment.zza(list, 2);
        ArrayList<MediaTrack> arrayList2 = TracksChooserDialogFragment.zza(list, 1);
        if (arrayList.size() <= 1 && arrayList2.isEmpty()) {
            return null;
        }
        TracksChooserDialogFragment tracksChooserDialogFragment = new TracksChooserDialogFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("extra_tracks_type_audio", arrayList);
        bundle.putParcelableArrayList("extra_tracks_type_text", arrayList2);
        bundle.putLongArray("extra_active_track_ids", lArray);
        tracksChooserDialogFragment.setArguments(bundle);
        return tracksChooserDialogFragment;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setRetainInstance(true);
        ArrayList arrayList = this.getArguments().getParcelableArrayList("extra_tracks_type_text");
        if (arrayList != null && !arrayList.isEmpty()) {
            this.zza = new ArrayList<MediaTrack>(arrayList);
            TracksChooserDialogFragment tracksChooserDialogFragment = this;
            this.zza.add(0, new MediaTrack.Builder(-1L, 1).setName(tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_none)).setSubtype(2).setContentId("").build());
        }
        this.zzb = this.getArguments().getParcelableArrayList("extra_tracks_type_audio");
        this.zzc = this.getArguments().getLongArray("extra_active_track_ids");
    }

    @NonNull
    public Dialog onCreateDialog(Bundle bundle) {
        TabHost.TabSpec tabSpec;
        int n = TracksChooserDialogFragment.zza(this.zza, this.zzc, 0);
        int n2 = TracksChooserDialogFragment.zza(this.zzb, this.zzc, -1);
        zzat zzat2 = new zzat((Context)this.getActivity(), this.zza, n);
        zzat zzat3 = new zzat((Context)this.getActivity(), this.zzb, n2);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        View view = this.getActivity().getLayoutInflater().inflate(R.layout.cast_tracks_chooser_dialog_layout, null);
        zzat zzat4 = zzat3;
        zzat zzat5 = zzat2;
        View view2 = view;
        TracksChooserDialogFragment tracksChooserDialogFragment = this;
        ListView listView = (ListView)view2.findViewById(R.id.text_list_view);
        ListView listView2 = (ListView)view2.findViewById(R.id.audio_list_view);
        TabHost tabHost = (TabHost)view2.findViewById(R.id.tab_host);
        tabHost.setup();
        if (zzat5.getCount() == 0) {
            listView.setVisibility(4);
        } else {
            listView.setAdapter((ListAdapter)zzat5);
            tabSpec = tabHost.newTabSpec("textTab");
            tabSpec.setContent(R.id.text_list_view);
            tabSpec.setIndicator((CharSequence)tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_subtitles));
            tabHost.addTab(tabSpec);
        }
        if (zzat4.getCount() <= 1) {
            listView2.setVisibility(4);
        } else {
            listView2.setAdapter((ListAdapter)zzat4);
            tabSpec = tabHost.newTabSpec("audioTab");
            tabSpec.setContent(R.id.audio_list_view);
            tabSpec.setIndicator((CharSequence)tracksChooserDialogFragment.getActivity().getString(R.string.cast_tracks_chooser_dialog_audio));
            tabHost.addTab(tabSpec);
        }
        builder.setView(view).setPositiveButton((CharSequence)this.getActivity().getString(R.string.cast_tracks_chooser_dialog_ok), (DialogInterface.OnClickListener)new zzas(this, zzat2, zzat3)).setNegativeButton(R.string.cast_tracks_chooser_dialog_cancel, (DialogInterface.OnClickListener)new zzar(this));
        if (this.zzd != null) {
            this.zzd.cancel();
            this.zzd = null;
        }
        this.zzd = builder.create();
        return this.zzd;
    }

    private final void zza(zzat zzat2, zzat zzat3) {
        Object object;
        long[] lArray;
        MediaTrack mediaTrack;
        CastSession castSession = CastContext.getSharedInstance(this.getContext()).getSessionManager().getCurrentCastSession();
        if (castSession == null || !castSession.isConnected()) {
            return;
        }
        RemoteMediaClient remoteMediaClient = castSession.getRemoteMediaClient();
        if (remoteMediaClient == null || !remoteMediaClient.hasMediaSession()) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        MediaTrack mediaTrack2 = zzat2.zza();
        if (mediaTrack2 != null && mediaTrack2.getId() != -1L) {
            arrayList.add(mediaTrack2.getId());
        }
        if ((mediaTrack = zzat3.zza()) != null) {
            arrayList.add(mediaTrack.getId());
        }
        if ((lArray = remoteMediaClient.getMediaStatus().getActiveTrackIds()) != null && lArray.length > 0) {
            object = new HashSet();
            for (MediaTrack mediaTrack3 : this.zzb) {
                ((HashSet)object).add(mediaTrack3.getId());
            }
            for (MediaTrack mediaTrack3 : this.zza) {
                ((HashSet)object).add(mediaTrack3.getId());
            }
            Object object2 = lArray;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Object object3 = object2[i];
                if (((HashSet)object).contains((long)object3)) continue;
                arrayList.add((long)object3);
            }
        }
        object = new long[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Long)arrayList.get(i);
        }
        Arrays.sort((long[])object);
        remoteMediaClient.setActiveMediaTracks((long[])object);
        if (this.zzd != null) {
            this.zzd.cancel();
            this.zzd = null;
        }
    }

    public void onDestroyView() {
        if (this.getDialog() != null && this.getRetainInstance()) {
            this.getDialog().setDismissMessage(null);
        }
        super.onDestroyView();
    }

    @NonNull
    private static ArrayList<MediaTrack> zza(List<MediaTrack> list, int n) {
        ArrayList<MediaTrack> arrayList = new ArrayList<MediaTrack>();
        if (list != null) {
            for (MediaTrack mediaTrack : list) {
                if (mediaTrack.getType() != n) continue;
                arrayList.add(mediaTrack);
            }
        }
        return arrayList;
    }

    private static int zza(List<MediaTrack> list, long[] lArray, int n) {
        if (lArray == null || list == null) {
            return n;
        }
        for (int i = 0; i < list.size(); ++i) {
            long[] lArray2 = lArray;
            int n2 = lArray.length;
            for (int j = 0; j < n2; ++j) {
                if (lArray2[j] != list.get(i).getId()) continue;
                return i;
            }
        }
        return n;
    }

    static /* synthetic */ Dialog zza(TracksChooserDialogFragment tracksChooserDialogFragment) {
        return tracksChooserDialogFragment.zzd;
    }

    static /* synthetic */ Dialog zza(TracksChooserDialogFragment tracksChooserDialogFragment, Dialog dialog) {
        tracksChooserDialogFragment.zzd = null;
        return null;
    }

    static /* synthetic */ void zza(TracksChooserDialogFragment tracksChooserDialogFragment, zzat zzat2, zzat zzat3) {
        tracksChooserDialogFragment.zza(zzat2, zzat3);
    }
}

